/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.banklogin;

import com.alibaba.fastjson.JSONObject;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.testnet.Response;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.lang.MultiLang;
import kd.ebg.aqap.formplugin.plugin.banklogin.BankLoginFromParentPlugin;
import kd.ebg.aqap.formplugin.plugin.util.ControlUtil;
import kd.ebg.aqap.formplugin.pojo.bizinfo.BankLoginInfo;
import kd.ebg.aqap.formplugin.repository.ConnectionsInfoRepository;
import kd.ebg.aqap.formplugin.util.ConfigTypeMapUtil;
import kd.ebg.aqap.formplugin.util.FieldUtil;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.aqap.formplugin.util.net.TestConnect;
import kd.ebg.egf.common.cache.CosmicConstants;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.AESUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.db.QueryCacheUtil;
import kd.ebg.egf.common.utils.log.OperationLogUtil;

public class BankLoginFormPlugin
extends BankLoginFromParentPlugin {
    EBGLogger ebgLogger = EBGLogger.getInstance().getLogger(BankLoginFormPlugin.class);
    private static final String ATTACHMENTPANELKEY = "attachmentPanelKey";
    private static final String UPLOAD_FILED_NAME_MAP_KEY = "upload_filed_name_map_key";
    private static String BTN_PREFIX = "btn_";

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (kd.ebg.aqap.formplugin.util.StringUtils.equals("exclusive", fieldKey)) {
            String isExclusive = (String)this.getModel().getValue("exclusive");
            if ("true".equals(isExclusive)) {
                String bankLoginID = (String)this.getModel().getValue("number");
                if (this.ebcBankAcntRepository.exitsAcntByBankLogin(bankLoginID)) {
                    this.getModel().setValue("exclusive", (Object)"false");
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u524d\u7f6e\u673a\u5173\u8054\u4e86\u94f6\u884c\u8d26\u6237\uff0c\u65e0\u6cd5\u542f\u7528\u4e3a\u4e13\u5c5e\u524d\u7f6e\u673a\uff0c\u8bf7\u5148\u5220\u9664\u6216\u8005\u79fb\u4ea4\u76f8\u5173\u8d26\u6237\u81f3\u5176\u4ed6\u4e3b\u524d\u7f6e\u673a\u3002", (String)"BankLoginFormPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject dynamicObject = this.bankLoginRelRepository.findByMasterNumber(bankLoginID);
                if (dynamicObject != null) {
                    this.getModel().setValue("exclusive", (Object)"false");
                    String exclusive_number = dynamicObject.getString("exclusive_number");
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u524d\u7f6e\u673a\u88ab\u4e13\u5c5e\u524d\u7f6e\u673a%s\u3002", (String)"BankLoginFormPlugin_22", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), exclusive_number) + String.format(ResManager.loadKDString((String)"\u6240\u5173\u8054\uff0c\u65e0\u6cd5\u542f\u7528\u4e3a\u4e13\u5c5e\u524d\u7f6e\u673a\uff0c\u8bf7\u5148\u5230%s\u7684\u524d\u7f6e\u673a\u914d\u7f6e\u9875[\u6240\u5c5e\u4e3b\u524d\u7f6e\u673a\u7f16\u53f7]\u9009\u62e9\u5176\u4ed6\u4e3b\u524d\u7f6e\u673a\uff0c\u53d6\u6d88\u5173\u8054\u5173\u7cfb\u3002", (String)"BankLoginFormPlugin_23", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), exclusive_number));
                    return;
                }
                this.getModel().setValue("business_type", (Object)CosmicConstants.BANK_LOGIN_REL_CONFIG_TYPE_PAY);
            } else if ("false".equals(isExclusive)) {
                this.getModel().setValue("business_type", (Object)"");
                this.getModel().setValue("master_number", (Object)"");
            }
        } else if (kd.ebg.aqap.formplugin.util.StringUtils.equals("business_type", fieldKey)) {
            List<String> canSelectBankLoginIDs;
            this.getModel().setValue("master_number", (Object)"");
            ArrayList<ComboItem> data = new ArrayList<ComboItem>(16);
            ComboEdit comboEdit = (ComboEdit)this.getControl("master_number");
            if (!"".equals(this.getModel().getValue("business_type")) && CollectionUtil.isNotEmpty(canSelectBankLoginIDs = this.getCanSelectBankLoginIDs())) {
                for (String bankLoginID : canSelectBankLoginIDs) {
                    data.add(new ComboItem(new LocaleString(bankLoginID), bankLoginID));
                }
            }
            comboEdit.setComboItems(data);
        }
        super.setFieldShowOrHide();
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        this.createDynamicPanel();
        this.getPageCache().put("hasAddToContainer", "true");
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("BankLoginFormPlugin", exp.getMessage()), new Object[0]);
        }
        super.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void afterCreateNewData(EventObject e) {
        String bankVersion = this.getBankVersion();
        DynamicObject data = BusinessDataServiceHelper.loadSingle((String)"aqap_bank", (String)"id, number, name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bankVersion)});
        String bankVersionNameCN = (String)data.get("name.zh_CN");
        String bankVersionNameEN = (String)data.get("name.en_US");
        List<BankLoginInfo> bankLoginInfos = super.getBankLoginInfoList(this.getBankVersion());
        if (bankLoginInfos == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u524d\u7f6e\u673a\u914d\u7f6e\u9879\u4e0d\u5b58\u5728\u3002", (String)"BankLoginFormPlugin_32", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            return;
        }
        bankLoginInfos.stream().forEach(bankLoginInfo -> {
            if (kd.ebg.aqap.formplugin.util.StringUtils.isNotEmpty(bankLoginInfo.getBankConfigValue())) {
                if ("ip".equalsIgnoreCase(bankLoginInfo.getBankConfigId())) {
                    Long id = this.saveIPConfigAsDefault(bankLoginInfo.getBankConfigValue());
                    if (id > 0L) {
                        this.getModel().setValue(bankLoginInfo.getBankConfigId(), (Object)id);
                    }
                } else {
                    this.getModel().getDataEntity().set(bankLoginInfo.getBankConfigId(), (Object)bankLoginInfo.getBankConfigValue());
                }
            }
        });
        this.getModel().setValue("custom_id", (Object)RequestContext.get().getTenantId());
        String maxVersionValue = super.getMaxVersionValue(bankVersion);
        this.getModel().getDataEntity().set("number", (Object)(bankVersion + "-" + maxVersionValue));
        LocaleString bankVersionName = new LocaleString();
        bankVersionName.setLocaleValue_zh_CN(bankVersionNameCN + maxVersionValue);
        bankVersionName.setLocaleValue_en(bankVersionNameEN + maxVersionValue);
        this.getModel().getDataEntity().set("name", (Object)bankVersionName);
        this.getModel().getDataEntity().set("group", (Object)data);
        DynamicObject channelData = BusinessDataServiceHelper.loadSingle((String)"aqap_bank", (String)"id , type", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bankVersion)});
        String typeCN = (String)channelData.get("type.zh_CN");
        String typeEN = (String)channelData.get("type.en_US");
        LocaleString type = new LocaleString();
        type.setLocaleValue_en(typeEN);
        type.setLocaleValue_zh_CN(typeCN);
        this.getModel().getDataEntity().set("type", (Object)type);
        super.showCmbOpaCloudType(bankVersion);
        super.setFieldShowOrHide();
    }

    private Long saveIPConfigAsDefault(String value) {
        boolean isExist;
        Long id = 0L;
        if (StringUtil.isNil(value)) {
            return id;
        }
        QFilter filter = QFilter.of((String)"number = ?", (Object[])new Object[]{value});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"aqap_white_list", (String)"id", (QFilter[])filter.toArray());
        boolean bl = isExist = collection.size() > 0;
        if (!isExist) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"aqap_white_list");
            dynamicObject.set("number", (Object)value);
            dynamicObject.set("name", (Object)value);
            dynamicObject.set("status", (Object)"C");
            dynamicObject.set("enable", (Object)"1");
            Object[] obj = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            dynamicObject = (DynamicObject)obj[0];
            id = dynamicObject.getLong("id");
        } else {
            id = ((DynamicObject)collection.get(0)).getLong("id");
        }
        return id;
    }

    public void afterLoadData(EventObject e) {
        String bankLogin = (String)this.getModel().getValue("number");
        if (kd.ebg.aqap.formplugin.util.StringUtils.isNotEmpty(bankLogin)) {
            QFilter qFilter = QFilter.of((String)"number=? and config_type=? and custom_id=?", (Object[])new Object[]{bankLogin, "ebg", RequestContext.get().getTenantId()});
            DynamicObjectCollection datas = QueryServiceHelper.query((String)"aqap_bank_login_config", (String)"id, bank_config_id, bank_config_value, input_type", (QFilter[])qFilter.toArray());
            if (datas.size() > 0) {
                HashSet dbDataSet = new HashSet(1);
                datas.stream().forEach(data -> {
                    String configid = data.getString("bank_config_id");
                    String value = data.getString("bank_config_value");
                    String input_type = data.getString("input_type");
                    String cacheKey = this.getPwdCacheKey(configid);
                    if (this.getView().getPageCache().get(cacheKey) != null) {
                        this.getView().getPageCache().put(cacheKey, value);
                        if (kd.ebg.aqap.formplugin.util.StringUtils.isNotEmpty(value)) {
                            value = "******";
                        }
                    }
                    try {
                        if ("ip".equalsIgnoreCase(configid) || "front_proxy_ip".equalsIgnoreCase(configid)) {
                            Long id = this.saveIPConfigAsDefault(value);
                            if (id > 0L) {
                                this.getModel().setValue(configid, (Object)id);
                            }
                        } else if (ConfigInputType.DATE.getInputType().equals(input_type)) {
                            Date date = DateUtil.string2Date((String)value, (String)"yyyy-MM-dd");
                            this.getModel().getDataEntity().set(configid, (Object)date);
                        } else if (ConfigInputType.DATE8.getInputType().equals(input_type)) {
                            Date date = DateUtil.string2Date((String)value, (String)"yyyyMMdd");
                            this.getModel().getDataEntity().set(configid, (Object)date);
                        } else {
                            this.getModel().getDataEntity().set(configid, (Object)value);
                        }
                        dbDataSet.add(configid);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    super.getBankLoginInfoList(this.getBankVersion()).stream().forEach(bankLoginInfo -> {
                        if (!dbDataSet.contains(bankLoginInfo.getBankConfigId()) && kd.ebg.aqap.formplugin.util.StringUtils.isNotEmpty(bankLoginInfo.getBankConfigValue())) {
                            if ("ip".equalsIgnoreCase(bankLoginInfo.getBankConfigId()) || "front_proxy_ip".equalsIgnoreCase(bankLoginInfo.getBankConfigId())) {
                                Long id = this.saveIPConfigAsDefault(bankLoginInfo.getBankConfigValue());
                                if (id > 0L) {
                                    this.getModel().setValue(bankLoginInfo.getBankConfigId(), (Object)id);
                                }
                            } else {
                                this.getModel().getDataEntity().set(bankLoginInfo.getBankConfigId(), (Object)bankLoginInfo.getBankConfigValue());
                            }
                        }
                    });
                });
            } else {
                List<BankLoginInfo> bankLoginInfos = super.getBankLoginInfoList(this.getBankVersion());
                bankLoginInfos.stream().forEach(bankLoginInfo -> {
                    if (kd.ebg.aqap.formplugin.util.StringUtils.isNotEmpty(bankLoginInfo.getBankConfigValue())) {
                        if ("ip".equalsIgnoreCase(bankLoginInfo.getBankConfigId())) {
                            Long id = this.saveIPConfigAsDefault(bankLoginInfo.getBankConfigValue());
                            if (id > 0L) {
                                this.getModel().setValue(bankLoginInfo.getBankConfigId(), (Object)id);
                            }
                        } else {
                            this.getModel().getDataEntity().set(bankLoginInfo.getBankConfigId(), (Object)bankLoginInfo.getBankConfigValue());
                        }
                    }
                });
            }
        }
        super.showCmbOpaCloudType(this.getBankVersion());
        super.setFieldShowOrHide();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        List<FlexPanelAp> flexPanelApList = this.createDynamicPanel();
        if (CollectionUtil.isEmpty(flexPanelApList)) {
            return;
        }
        Container myFldPanel = (Container)this.getView().getControl("conentpanel");
        flexPanelApList.stream().forEach(fieldsetPanelAp -> {
            myFldPanel.getItems().addAll(((Container)fieldsetPanelAp.buildRuntimeControl()).getItems());
            this.getView().createControlIndex(myFldPanel.getItems());
        });
    }

    private void initEBContext() {
        EBContext ebContext = EBContext.getContext();
        if (ebContext == null) {
            ebContext = EBContext.builder().build();
            EBContext.setContext((EBContext)ebContext);
        }
        String formId = this.getView().getFormShowParameter().getFormId();
        ebContext.setFormId(formId);
    }

    private void removeEBContext() {
        EBContext.destroy();
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        List<BankLoginInfo> bankLoginInfos = super.getBankLoginInfoList(this.getBankVersion());
        if (CollectionUtil.isEmpty(bankLoginInfos)) {
            return;
        }
        bankLoginInfos.stream().forEach(bankLoginInfo -> {
            if (kd.ebg.aqap.formplugin.util.StringUtils.equals(bankLoginInfo.getBankConfigId().toLowerCase(Locale.ENGLISH), e.getKey()) || kd.ebg.aqap.formplugin.util.StringUtils.equals(BTN_PREFIX + bankLoginInfo.getBankConfigId().toLowerCase(Locale.ENGLISH), e.getKey())) {
                String key = bankLoginInfo.getBankConfigId().toLowerCase(Locale.ENGLISH);
                if ("upload".equalsIgnoreCase(bankLoginInfo.getInputType()) && e.getKey().startsWith(BTN_PREFIX)) {
                    Button button = new Button();
                    button.setKey(BTN_PREFIX + key);
                    button.setOperationKey("upload");
                    button.setView(this.getView());
                    e.setControl((Control)button);
                } else if (ConfigInputType.SELECT.getInputType().equals(bankLoginInfo.getInputType())) {
                    ComboEdit edit = new ComboEdit();
                    edit.setKey(key);
                    edit.setView(this.getView());
                    e.setControl((Control)edit);
                } else if (ConfigInputType.MUL_SELECT.getInputType().equals(bankLoginInfo.getInputType())) {
                    MulComboEdit edit = new MulComboEdit();
                    edit.setKey(key);
                    edit.setView(this.getView());
                    e.setControl((Control)edit);
                } else if (ConfigInputType.SWITCH.getInputType().equals(bankLoginInfo.getInputType())) {
                    FieldEdit edit = new FieldEdit();
                    edit.setKey(key);
                    edit.setView(this.getView());
                    e.setControl((Control)edit);
                } else if (ConfigInputType.DATE.getInputType().equals(bankLoginInfo.getInputType()) || ConfigInputType.DATE8.getInputType().equals(bankLoginInfo.getInputType())) {
                    DateEdit edit = new DateEdit();
                    edit.setKey(key);
                    edit.setView(this.getView());
                    e.setControl((Control)edit);
                } else if (e.getKey().equalsIgnoreCase("ip")) {
                    BasedataEdit basedataEdit = new BasedataEdit();
                    basedataEdit.setKey("ip");
                    basedataEdit.setView(this.getView());
                    e.setControl((Control)basedataEdit);
                } else if (e.getKey().equalsIgnoreCase("front_proxy_ip")) {
                    BasedataEdit basedataEdit = new BasedataEdit();
                    basedataEdit.setKey("front_proxy_ip");
                    basedataEdit.setView(this.getView());
                    e.setControl((Control)basedataEdit);
                } else {
                    TextEdit textEdit = new TextEdit();
                    textEdit.setKey(key);
                    textEdit.setView(this.getView());
                    e.setControl((Control)textEdit);
                }
                return;
            }
        });
    }

    private List<FlexPanelAp> createDynamicPanel() {
        ArrayList<FlexPanelAp> result = new ArrayList<FlexPanelAp>(1);
        String hasAddToContainer = this.getPageCache().get("hasAddToContainer");
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey("headAp");
        List<BankLoginInfo> bankLoginInfos = super.getBankLoginInfoList(this.getBankVersion());
        if (CollectionUtil.isEmpty(bankLoginInfos)) {
            return result;
        }
        HashMap map = new HashMap(16);
        bankLoginInfos.stream().forEach(bankLoginInfo -> {
            String type = bankLoginInfo.getType() == null ? "default" : bankLoginInfo.getType();
            ArrayList<BankLoginInfo> bankLoginInfoList = (ArrayList<BankLoginInfo>)map.get(type);
            if (bankLoginInfoList == null) {
                bankLoginInfoList = new ArrayList<BankLoginInfo>(1);
                map.put(type, bankLoginInfoList);
            }
            bankLoginInfoList.add((BankLoginInfo)bankLoginInfo);
        });
        Container container = (Container)this.getView().getControl("conentpanel");
        List<String> typeSortList = ConfigTypeMapUtil.sort(map);
        for (String type : typeSortList) {
            FlexPanelAp flex = this.createFlexPanelAp(type);
            this.addFieldsetPanelApItems(flex, (List)map.get(type));
            if (hasAddToContainer == null) {
                container.addControls(Collections.singletonList(flex.createControl()));
            }
            result.add(flex);
        }
        return result;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl("tbmain");
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        List<String> attachmentPanelKeys = this.getAttachmentPanelKey();
        attachmentPanelKeys.stream().forEach(key -> {
            Button button = (Button)this.getView().getControl(key);
            if (button != null) {
                button.addClickListener((ClickListener)this);
            }
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)formOperate.getOperateKey())) {
            if (this.isAddBankLoginRepeat()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u524d\u7f6e\u673a\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u5173\u95ed\u6b64\u9875\u9762\u91cd\u65b0\u6dfb\u52a0\u3002", (String)"BankLoginFormPlugin_7", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                this.getModel().putContextVariable("updOrAdd_cancel", (Object)Boolean.TRUE);
                return;
            }
            try {
                String ip = (String)this.getModel().getDataEntity().get("ip.number");
                if ((ip.contains("http") || ip.contains("HTTP")) && ((ConnectionsInfoRepository)SpringContextUtil.getBean(ConnectionsInfoRepository.class)).exitsByGroupNumber(this.getBankVersion())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u7f51\u5173\u5730\u5740\u914d\u7f6e\u4e0d\u89c4\u8303\uff0c\u8bf7\u68c0\u67e5\u3002\u4f8b\u5982\uff1a\u94f6\u884c\u670d\u52a1\u5730\u5740\u4e3ahttps://abc.com.cn/api/,\u5219\u670d\u52a1\u7f51\u5173\u5730\u5740\u4e3aabc.com.cn\uff0c\u7aef\u53e3\u53f7\u4e3a443\uff0c\u901a\u8baf\u534f\u8bae\u4e3aHTTPS\uff0cURI\u8def\u5f84\u4e3a/api\u3002", (String)"BankLoginFormPlugin_35", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    this.getModel().putContextVariable("updOrAdd_cancel", (Object)Boolean.TRUE);
                    return;
                }
            }
            catch (Exception ip) {
                // empty catch block
            }
            if ("true".equals(super.getExclusive())) {
                String[] masters;
                String business_type = (String)this.getModel().getValue("business_type");
                if (StringUtil.isNullOrEmpty(business_type)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e13\u5c5e\u524d\u7f6e\u673a\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"BankLoginFormPlugin_8", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    this.getModel().putContextVariable("updOrAdd_cancel", (Object)Boolean.TRUE);
                    return;
                }
                String master_number = (String)this.getModel().getValue("master_number");
                if (StringUtil.isNullOrEmpty(master_number)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6240\u5c5e\u4e3b\u524d\u7f6e\u673a\u7f16\u53f7\u3002", (String)"BankLoginFormPlugin_9", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    this.getModel().putContextVariable("updOrAdd_cancel", (Object)Boolean.TRUE);
                    return;
                }
                String bankLoginID = (String)this.getModel().getValue("number");
                if (this.ebcBankAcntRepository.exitsAcntByBankLogin(bankLoginID)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u524d\u7f6e\u673a\u5173\u8054\u4e86\u94f6\u884c\u8d26\u6237\uff0c\u65e0\u6cd5\u542f\u7528\u4e3a\u4e13\u5c5e\u524d\u7f6e\u673a\uff0c\u8bf7\u5148\u5220\u9664\u6216\u8005\u79fb\u4ea4\u76f8\u5173\u8d26\u6237\u81f3\u5176\u4ed6\u4e3b\u524d\u7f6e\u673a\u3002", (String)"BankLoginFormPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    this.getModel().putContextVariable("updOrAdd_cancel", (Object)Boolean.TRUE);
                    return;
                }
                for (String master : masters = master_number.split(",")) {
                    if (!kd.ebg.aqap.formplugin.util.StringUtils.isNotEmpty(master)) continue;
                    DynamicObject bankLogin = this.ebcBankLoginRepository.getBankLoginByBankLoginID(master);
                    if (bankLogin == null) {
                        args.setCancel(true);
                        this.getModel().putContextVariable("updOrAdd_cancel", (Object)Boolean.TRUE);
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u4e3b\u524d\u7f6e\u673a%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u67e5\u770b\u662f\u5426\u5df2\u88ab\u5220\u9664\u3002", (String)"BankLoginFormPlugin_24", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), master));
                        return;
                    }
                    if ("1".equals(bankLogin.getString("config_type"))) {
                        args.setCancel(true);
                        this.getModel().putContextVariable("updOrAdd_cancel", (Object)Boolean.TRUE);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u4e3b\u524d\u7f6e\u673a\u5df2\u6539\u4e3a\u4e13\u5c5e\u524d\u7f6e\u673a\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u4e3b\u524d\u7f6e\u673a\u3002", (String)"BankLoginFormPlugin_12", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject dynamicObject = this.bankLoginRelRepository.findByConfigTypeAndMasterNumber(business_type, master);
                    if (dynamicObject == null || bankLoginID.equals(dynamicObject.getString("exclusive_number"))) continue;
                    String exclusive_number = dynamicObject.getString("exclusive_number");
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d%s", (String)"BankLoginFormPlugin_25", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), business_type) + String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u6240\u9009\u4e3b\u524d\u7f6e\u673a%s\u3002", (String)"BankLoginFormPlugin_26", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), master) + String.format(ResManager.loadKDString((String)"\u88ab\u4e13\u5c5e\u524d\u7f6e\u673a%s\u3002", (String)"BankLoginFormPlugin_27", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), exclusive_number) + String.format(ResManager.loadKDString((String)"\u6240\u5173\u8054\uff0c\u65e0\u6cd5\u542f\u7528\u4e3a\u4e13\u5c5e\u524d\u7f6e\u673a\uff0c\u8bf7\u5148\u5230%s\u7684\u524d\u7f6e\u673a\u914d\u7f6e\u9875[\u6240\u5c5e\u4e3b\u524d\u7f6e\u673a\u7f16\u53f7]\u9009\u62e9\u5176\u4ed6\u4e3b\u524d\u7f6e\u673a\uff0c\u53d6\u6d88\u5173\u8054\u5173\u7cfb\u3002", (String)"BankLoginFormPlugin_23", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), exclusive_number));
                    args.setCancel(true);
                    this.getModel().putContextVariable("updOrAdd_cancel", (Object)Boolean.TRUE);
                    return;
                }
                this.getModel().setValue("config_type", (Object)"1");
            } else {
                this.getModel().setValue("config_type", (Object)"0");
            }
        } else if (StringUtils.equals((CharSequence)"make_cert", (CharSequence)formOperate.getOperateKey())) {
            FormShowParameter formShowParameter = new FormShowParameter();
            String bankVersion = (String)this.getModel().getDataEntity().get("group.number");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("bankVersion", (Object)bankVersion);
            formShowParameter.setStatus(OperationStatus.EDIT);
            formShowParameter.setAppId("aqap");
            formShowParameter.setFormId("aqap_cert_make");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh"));
            this.getView().showForm(formShowParameter);
        }
        this.getModel().putContextVariable("updOrAdd_cancel", (Object)Boolean.FALSE);
    }

    public IFormView getView() {
        return super.getView();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (kd.ebg.aqap.formplugin.util.StringUtils.equals("bar_save", evt.getItemKey())) {
            IDataModel model = this.getModel();
            ArrayList<BankLoginInfo> CheckNullDisableInfoList = new ArrayList<BankLoginInfo>(1);
            String bankVersion = (String)model.getDataEntity().get("group.number");
            List<BankLoginInfo> bankLoginInfos = super.getBankLoginInfoList(bankVersion);
            boolean isCheckNullable = true;
            for (BankLoginInfo bankLoginInfo : bankLoginInfos) {
                DynamicObject dynamicObject;
                String string = bankLoginInfo.getBankConfigId();
                if (bankLoginInfo.isNullable()) continue;
                if (ConfigInputType.UPLOAD.getInputType().equalsIgnoreCase(bankLoginInfo.getInputType())) {
                    boolean isHidd;
                    String value = (String)model.getValue(string);
                    String isHiddStr = this.getView().getPageCache().get("hidd_" + bankLoginInfo.getBankConfigId());
                    boolean bl = isHidd = kd.ebg.aqap.formplugin.util.StringUtils.isNotEmpty(isHiddStr) && Boolean.parseBoolean(isHiddStr);
                    if (!kd.ebg.aqap.formplugin.util.StringUtils.isEmpty(value) || isHidd) continue;
                    isCheckNullable = false;
                    CheckNullDisableInfoList.add(bankLoginInfo);
                    continue;
                }
                if (bankLoginInfo.isNullable() || !"ip".equalsIgnoreCase(string) && !"front_proxy_ip".equalsIgnoreCase(string) || (dynamicObject = (DynamicObject)model.getValue(string)) != null) continue;
                String name = '\u201c' + bankLoginInfo.getMlBankConfigName().getDescription() + '\u201d';
                String showTip = String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%1$s\u3002", (String)"BankLoginFormPlugin_33", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), name);
                this.getView().showTipNotification(showTip);
                evt.setCancel(true);
                return;
            }
            if (!isCheckNullable) {
                StringBuilder sb = new StringBuilder();
                for (BankLoginInfo bankLoginInfo : CheckNullDisableInfoList) {
                    sb.append(bankLoginInfo.getMlBankConfigName().getDescription()).append('\uff0c');
                }
                String string = sb.toString();
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BankLoginFormPlugin_34", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), string));
                evt.setCancel(true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        IDataModel model = this.getModel();
        String bankLogin = (String)model.getValue("number");
        String bankVersion = (String)model.getDataEntity().get("group.number");
        String configType = "ebg";
        String customID = RequestContext.get().getTenantId();
        ArrayList<DynamicObject> dynamicObjectSaveList = new ArrayList<DynamicObject>(16);
        ArrayList<OpLogAppInfo> operateLogList = new ArrayList<OpLogAppInfo>(16);
        if (kd.ebg.aqap.formplugin.util.StringUtils.equals("bar_save", evt.getItemKey()) && !((Boolean)this.getModel().getContextVariable("updOrAdd_cancel")).booleanValue()) {
            List<BankLoginInfo> bankLoginInfos = super.getBankLoginInfoList(bankVersion);
            for (BankLoginInfo bankLoginInfo2 : bankLoginInfos) {
                Date date;
                String key = bankLoginInfo2.getBankConfigId();
                String value = "";
                if ("ip".equalsIgnoreCase(key) || "front_proxy_ip".equalsIgnoreCase(key)) {
                    DynamicObject dynamicObject = (DynamicObject)model.getValue(key);
                    if (dynamicObject != null) {
                        value = dynamicObject.getString("number");
                    }
                } else if (ConfigInputType.DATE.getInputType().equals(bankLoginInfo2.getInputType())) {
                    date = (Date)model.getValue(bankLoginInfo2.getBankConfigId());
                    value = DateUtil.formatDate((Date)date, (String)"yyyy-MM-dd");
                } else if (ConfigInputType.DATE8.getInputType().equals(bankLoginInfo2.getInputType())) {
                    date = (Date)model.getValue(bankLoginInfo2.getBankConfigId());
                    value = DateUtil.formatDate((Date)date, (String)"yyyyMMdd");
                } else {
                    value = (String)model.getValue(key);
                }
                value = value != null ? value.trim() : value;
                String pwdCacheKey = this.getPwdCacheKey(bankLoginInfo2.getBankConfigId());
                if (ConfigInputType.PASSWORD.getInputType().equalsIgnoreCase(bankLoginInfo2.getInputType()) && this.getView().getPageCache().get(pwdCacheKey) != null) {
                    if ("******".equalsIgnoreCase(value)) {
                        value = this.getView().getPageCache().get(pwdCacheKey);
                    } else if (kd.ebg.aqap.formplugin.util.StringUtils.isNotEmpty(value)) {
                        value = AESUtil.encrypt((String)value);
                    }
                }
                String name = FieldUtil.getName(bankLoginInfo2.getMlBankConfigName(), bankLoginInfo2.getBankConfigName());
                dynamicObjectSaveList.add(this.getDataEntity(bankLoginInfo2.getBankConfigId(), name, bankLoginInfo2.isNullable(), bankLogin.isEmpty(), bankLogin, bankVersion, value, customID, configType, bankLoginInfo2.getInputType()));
                operateLogList.add(this.operateLog(name, bankLoginInfo2.getBankConfigId(), value, bankVersion, bankLogin));
            }
            try (TXHandle h = TX.requiresNew();){
                String statusName = ((BaseShowParameter)this.getView().getFormShowParameter()).getStatus().name();
                if ("EDIT".equalsIgnoreCase(statusName)) {
                    this.deleteBankLogin(bankLogin, configType);
                }
                if ("true".equals(super.getExclusive())) {
                    this.savebankLoginRel(bankLogin);
                }
                boolean result = this.save(dynamicObjectSaveList.toArray(new DynamicObject[dynamicObjectSaveList.size()]));
                Map<String, DynamicObject> cerMap = this.getCerDataMap();
                List<BankLoginInfo> bankLoginUploadConfigs = this.infoService.getBankLoginUploadConfig(bankVersion);
                bankLoginUploadConfigs.stream().forEach(bankLoginInfo -> {
                    String key = bankLoginInfo.getBankConfigId();
                    if ("upload".equals(bankLoginInfo.getInputType())) {
                        this.initEBContext();
                        String value = (String)model.getValue(key);
                        if (cerMap.get(key) != null) {
                            if (this.getPageCache().get(key + "content") != null) {
                                this.updateCer((DynamicObject)cerMap.get(key), (BankLoginInfo)bankLoginInfo, bankVersion, bankLogin, customID, (CertInfo)JSONObject.parseObject((String)this.getPageCache().get(key + "content"), CertInfo.class), value);
                            }
                        } else if (this.getPageCache().get(key + "content") != null) {
                            this.addCer((BankLoginInfo)bankLoginInfo, bankVersion, bankLogin, customID, (CertInfo)JSONObject.parseObject((String)this.getPageCache().get(key + "content"), CertInfo.class), value);
                        }
                        this.removeEBContext();
                    }
                });
                if (!result) return;
                for (OpLogAppInfo opLogAppInfo : operateLogList) {
                    if (!kd.ebg.aqap.formplugin.util.StringUtils.isNotEmpty(opLogAppInfo.getBizAppID())) continue;
                    OperationLogUtil.recordInvoke((OpLogAppInfo)opLogAppInfo);
                }
                return;
            }
        }
        if (kd.ebg.aqap.formplugin.util.StringUtils.equals("test_telnet", evt.getOperationKey())) {
            TestConnect testConnect;
            Response response;
            HashMap<String, Integer> portMap = new HashMap<String, Integer>(4);
            HashMap<String, String> ipMap = new HashMap<String, String>(2);
            if (bankLogin.contains("EBG_SIM")) {
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6d4b\u8bd5\u8fde\u63a5\u6210\u529f\u3002", (String)"BankLoginFormPlugin_31", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), bankLogin));
                return;
            }
            Result<String> checkIP = this.checkIP("ip", "number", ResManager.loadKDString((String)"IP\u5730\u5740", (String)"BankLoginFormPlugin_36", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), false);
            if (checkIP.isStopped()) {
                return;
            }
            String ip = (String)((Result)checkIP).data;
            Result<Integer> bizPort = this.checkPort("exchangePort", ResManager.loadKDString((String)"\u4e1a\u52a1\u7aef\u53e3\u53f7", (String)"BankLoginFormPlugin_37", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), false);
            if (bizPort.isStopped()) {
                return;
            }
            Integer port = (Integer)((Result)bizPort).data;
            Result<Integer> checkPort = this.checkPort("signPort", ResManager.loadKDString((String)"\u7b7e\u540d\u7aef\u53e3\u53f7", (String)"BankLoginFormPlugin_38", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), true);
            if (checkPort.isStopped()) {
                return;
            }
            if (((Result)checkPort).state == State.NTH) {
                portMap.put("signPort", (Integer)((Result)checkPort).data);
            }
            if ((checkIP = this.checkIP("front_proxy_ip", "number", ResManager.loadKDString((String)"\u91d1\u8776\u4ee3\u7406\u670d\u52a1IP\u5730\u5740", (String)"BankLoginFormPlugin_40", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), true)).isStopped()) {
                return;
            }
            if (((Result)checkIP).state == State.NTH) {
                ipMap.put("front_proxy_ip", (String)((Result)checkIP).data);
            }
            if ((checkPort = this.checkPort("frontProxy_Port", ResManager.loadKDString((String)"\u91d1\u8776\u4ee3\u7406\u670d\u52a1\u7aef\u53e3\u53f7", (String)"BankLoginFormPlugin_39", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), true)).isStopped()) {
                return;
            }
            if (((Result)checkPort).state == State.NTH) {
                portMap.put("frontProxy_Port", (Integer)((Result)checkPort).data);
            }
            if (((Result)checkIP).state == State.NTH && ((Result)checkPort).state == State.NO_VALUE) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e%s\u3002", (String)"BankLoginFormPlugin_41", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u91d1\u8776\u4ee3\u7406\u670d\u52a1\u7aef\u53e3\u53f7", (String)"BankLoginFormPlugin_39", (String)"ebg-aqap-formplugin", (Object[])new Object[0])));
                return;
            }
            if (((Result)checkIP).state == State.NO_VALUE && ((Result)checkPort).state == State.NTH) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e%s\u3002", (String)"BankLoginFormPlugin_41", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u91d1\u8776\u4ee3\u7406\u670d\u52a1IP\u5730\u5740", (String)"BankLoginFormPlugin_40", (String)"ebg-aqap-formplugin", (Object[])new Object[0])));
                return;
            }
            String protocol = (String)this.checkExist("exchangeProtocol").data;
            if (port == null) {
                try {
                    URI uri = new URI(ip);
                    port = uri.getPort();
                    if (port == -1) {
                        String scheme = uri.getScheme();
                        if (scheme == null) {
                            scheme = protocol;
                        }
                        port = scheme == null || "http".equalsIgnoreCase(scheme) ? Integer.valueOf(80) : Integer.valueOf(443);
                    }
                    if (uri.getHost() != null) {
                        ip = uri.getHost();
                    }
                }
                catch (Exception e) {
                    this.ebgLogger.error(ResManager.loadKDString((String)"\u57df\u540d\u89e3\u6790\u5931\u8d25\u3002", (String)"", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), (Throwable)e);
                    this.getView().showTipNotification(MultiLang.getCheckLinkErrorTip(bankLogin));
                    return;
                }
            }
            if ((response = (testConnect = TestConnect.getInstance()).test(customID, bankLogin, ip, port, portMap, ipMap)).isSuccess()) {
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6d4b\u8bd5\u8fde\u63a5\u6210\u529f\u3002", (String)"BankLoginListPlugin_14", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), bankLogin));
                return;
            } else {
                String responseErrMsg = response.getErrMsg();
                this.getView().showErrorNotification(responseErrMsg);
            }
            return;
        }
        if (!kd.ebg.aqap.formplugin.util.StringUtils.equals("get_connections_info", evt.getOperationKey())) return;
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("groupId", this.getModel().getDataEntity().get("group.id"));
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"aqap_connections_info", (boolean)false, (int)0, (boolean)true);
        StyleCss style = new StyleCss();
        style.setWidth("1000");
        style.setHeight("600");
        listShowParameter.getOpenStyle().setInlineStyleCss(style);
        listShowParameter.setListFilterParameter(new ListFilterParameter(Collections.singletonList(QFilter.of((String)("group=" + this.getModel().getDataEntity().get("group.id")), (Object[])new Object[0])), "type"));
        listShowParameter.setCustomParams(customParams);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u94f6\u884c\u8fde\u63a5\u914d\u7f6e\u5bfc\u5165", (String)"BankLoginFormPlugin_51", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "test"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public DynamicObject getDataEntity(String bankConfigId, String bankConfigName, boolean isNullable, boolean isReadOnly, String bankLogin, String bankVersion, String value, String customID, String configType, String inputType) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)"aqap_bank_login_config");
        dataEntity.set("number", (Object)bankLogin);
        dataEntity.set("bank_config_id", (Object)bankConfigId);
        dataEntity.set("name", (Object)bankConfigName);
        dataEntity.set("bank_version_id", (Object)bankVersion);
        dataEntity.set("bank_config_value", (Object)value);
        dataEntity.set("nullable", (Object)isNullable);
        dataEntity.set("readonly", (Object)isReadOnly);
        dataEntity.set("custom_id", (Object)customID);
        dataEntity.set("config_type", (Object)configType);
        dataEntity.set("input_type", (Object)inputType);
        return dataEntity;
    }

    public boolean save(DynamicObject[] dataEntities) {
        try {
            SaveServiceHelper.save((DynamicObject[])dataEntities);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    private OpLogAppInfo operateLog(String name, String key, String newValue, String bankVersionId, String bankLoginId) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "BusinessPropertyFormPlugin_12", "ebg-aqap-formplugin");
        QFilter filter = QFilter.of((String)"number=?", (Object[])new Object[]{bankLoginId});
        filter.and(new QFilter("bank_config_id", "=", (Object)key));
        DynamicObject object = QueryCacheUtil.getSingleDynamicObject((String)"aqap_bank_login_config", (String)"bank_config_value", (QFilter[])filter.toArray());
        newValue = this.infoService.getBankLoginConfigSourceName(bankVersionId, key, newValue);
        if (object != null) {
            String value = object.getString("bank_config_value");
            if (!kd.ebg.aqap.formplugin.util.StringUtils.equalsIgnoreCase(newValue, value = this.infoService.getBankLoginConfigSourceName(bankVersionId, key, value))) {
                MultiLangEnumBridge descBridge = new MultiLangEnumBridge("%1$s\u66f4\u65b0\u914d\u7f6e\u9879\uff0c%2$s\uff1a[%3$s] -> [%4$s]\u3002", "BankLoginFormPlugin_2", "ebg-aqap-formplugin");
                appLogInfo = OperationLogUtil.getOpLogAppInfo((String)"aqap", (String)this.getView().getEntityId(), (String)"save", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)descBridge, (String[])new String[]{bankVersionId, name, value, newValue});
            }
        } else {
            MultiLangEnumBridge descBridge = new MultiLangEnumBridge("%1$s\u65b0\u589e\u914d\u7f6e\u9879\uff0c%2$s\uff1a[%3$s]\u3002", "BankLoginFormPlugin_1", "ebg-aqap-formplugin");
            appLogInfo = OperationLogUtil.getOpLogAppInfo((String)"aqap", (String)this.getView().getEntityId(), (String)"save", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)descBridge, (String[])new String[]{bankVersionId, name, newValue});
        }
        return appLogInfo;
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        String bankVersion = (String)this.getModel().getDataEntity().get("group.number");
        List<String> attachmentPanelKeys = this.getAttachmentPanelKey();
        if (CollectionUtil.isNotEmpty(attachmentPanelKeys)) {
            for (String uploadKey : attachmentPanelKeys) {
                if (!kd.ebg.aqap.formplugin.util.StringUtils.equals(source.getKey(), uploadKey)) continue;
                ControlUtil.showUploadPage(this.getUploadNameMap(uploadKey), uploadKey, true, (IFormPlugin)this, this.getView(), bankVersion);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() != null) {
            if (closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
                ListSelectedRowCollection selectCollections = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                for (ListSelectedRow row : selectCollections) {
                    DynamicObject data = ((ConnectionsInfoRepository)SpringContextUtil.getBean(ConnectionsInfoRepository.class)).getById((Long)row.getPrimaryKeyValue());
                    if (data != null) {
                        this.setConnectionsParamValue("ip", data.getString("ip"));
                        this.setConnectionsParamValue("exchangePort", data.getInt("port"));
                        this.setConnectionsParamValue("exchangeUri", data.getString("uri"));
                        this.setConnectionsParamValue("exchangeProtocol", data.getString("protocol"));
                        this.setConnectionsParamValue("filePort", data.getString("file_port"));
                        this.setConnectionsParamValue("fileurl", data.getString("file_ip"));
                        this.setConnectionsParamValue("file_uri", data.getString("file_uri"));
                        continue;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u94f6\u884c\u8fde\u63a5\u914d\u7f6e\u5f15\u5165\u5931\u8d25\uff0c\u83b7\u53d6\u6570\u636e\u5f02\u5e38", (String)"BankLoginPlugin_50", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                }
            } else {
                CertInfo certInfo = (CertInfo)JSONObject.parseObject((String)((String)closedCallBackEvent.getReturnData()), CertInfo.class);
                String fieldKey = closedCallBackEvent.getActionId();
                fieldKey = fieldKey.replaceFirst(BTN_PREFIX, "");
                this.getPageCache().put(fieldKey + "content", JSONObject.toJSONString((Object)certInfo));
                this.getModel().setValue(fieldKey, (Object)certInfo.getFileName());
            }
        }
    }

    private void setConnectionsParamValue(String key, Object value) {
        try {
            key = key.toLowerCase(Locale.ENGLISH);
            if ("ip".equalsIgnoreCase(key)) {
                Long id = this.saveIPConfigAsDefault((String)value);
                if (id > 0L) {
                    this.getModel().setValue(key, (Object)id);
                } else {
                    this.getModel().setValue(key, null);
                }
            } else {
                this.getModel().setValue(key, value);
            }
        }
        catch (Exception ex) {
            this.ebgLogger.monitorInfo(String.format(ResManager.loadKDString((String)"\u5f00\u53d1\u94f6\u884c\u8fde\u63a5\u914d\u7f6e\u5f15\u5165\uff0c%s\u53c2\u6570\u8bbe\u7f6e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6b64\u5b57\u6bb5\u662f\u5426\u5b58\u5728", (String)"BankLoginPlugin_51", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), key));
        }
    }

    List<String> getAttachmentPanelKey() {
        List fileUploadConfigItemInfoList;
        if (this.getPageCache().get(ATTACHMENTPANELKEY) != null) {
            String keys = this.getPageCache().get(ATTACHMENTPANELKEY);
            return StringUtil.isNil(keys) ? new ArrayList(1) : Arrays.asList(keys.split(","));
        }
        ArrayList<String> result = new ArrayList<String>(1);
        List<BankLoginInfo> infos = super.getBankLoginInfoList(this.getBankVersion());
        String str = "";
        if (CollectionUtil.isNotEmpty(infos) && CollectionUtil.isNotEmpty(fileUploadConfigItemInfoList = infos.stream().filter(p -> "upload".equals(p.getInputType())).collect(Collectors.toList()))) {
            for (BankLoginInfo p2 : fileUploadConfigItemInfoList) {
                str = str + BTN_PREFIX + p2.getBankConfigId() + ",";
                result.add(BTN_PREFIX + p2.getBankConfigId());
            }
            str = str.substring(0, str.length() - 1);
        }
        this.getPageCache().put(ATTACHMENTPANELKEY, str);
        return result;
    }

    String getUploadNameMap(String key) {
        List fileUploadConfigItemInfoList;
        if (this.getPageCache().get(UPLOAD_FILED_NAME_MAP_KEY) != null) {
            String keys = this.getPageCache().get(UPLOAD_FILED_NAME_MAP_KEY);
            return ControlUtil.getUploadName(keys, key);
        }
        List<BankLoginInfo> infos = super.getBankLoginInfoList(this.getBankVersion());
        String str = "";
        if (CollectionUtil.isNotEmpty(infos) && CollectionUtil.isNotEmpty(fileUploadConfigItemInfoList = infos.stream().filter(p -> "upload".equals(p.getInputType())).collect(Collectors.toList()))) {
            StringBuilder sb = new StringBuilder();
            for (BankLoginInfo p2 : fileUploadConfigItemInfoList) {
                String name = FieldUtil.getName(p2.getMlBankConfigName(), p2.getBankConfigName());
                sb.append(BTN_PREFIX).append(p2.getBankConfigId()).append('-').append(name).append(',');
            }
            str = sb.toString();
            str = str.substring(0, str.length() - 1);
        }
        this.getPageCache().put(UPLOAD_FILED_NAME_MAP_KEY, str);
        return ControlUtil.getUploadName(str, key);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        this.getModel().setDataChanged(false);
    }

    public Result<String> checkIP(String pageName, String propertyName, String cnName, boolean canNoValue) {
        try {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(pageName);
            return new Result<String>(dynamicObject.getString(propertyName));
        }
        catch (KDException e) {
            return new Result<String>(State.NOT_EXIST);
        }
        catch (NullPointerException e) {
            if (canNoValue) {
                return new Result<String>(State.NO_VALUE);
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e%s\u3002", (String)"BankLoginFormPlugin_41", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), cnName));
            return new Result<String>(State.EXIST_BUT_NO_VALUE);
        }
    }

    public <T> Result<T> checkExist(String pageName) {
        try {
            return new Result<Object>(this.getModel().getValue(pageName));
        }
        catch (KDException e) {
            return new Result(State.NOT_EXIST);
        }
    }

    public Result<Integer> checkPort(String pageName, String cnName, boolean canNoValue) {
        try {
            String s = (String)this.getModel().getValue(pageName);
            if (kd.ebg.aqap.formplugin.util.StringUtils.isEmpty(s)) {
                if (canNoValue) {
                    return new Result<Integer>(State.NO_VALUE);
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e%s\u3002", (String)"BankLoginFormPlugin_41", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), cnName));
                return new Result<Integer>(State.EXIST_BUT_NO_VALUE);
            }
            int port = Integer.parseInt(s);
            if (port < 0 || port > 65535) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5e94\u8be5\u57280\u523065535\u7684\u8303\u56f4\u3002", (String)"BankLoginFormPlugin_42", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), cnName));
                return new Result<Integer>(State.ERROR);
            }
            return new Result<Integer>(Integer.parseInt(s));
        }
        catch (KDException e) {
            return new Result<Integer>(State.NOT_EXIST);
        }
        catch (NumberFormatException e) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u683c\u5f0f\u6709\u8bef\u3002", (String)"BankLoginFormPlugin_43", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), cnName));
            return new Result<Integer>(State.ERROR);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String bankVersion = (String)this.getModel().getDataEntity().get("group.number");
        if (!"GSNX_DC".equals(bankVersion)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"make_cert"});
        }
    }

    static class Result<T> {
        private final State state;
        private T data;

        public Result(State state) {
            this.state = state;
        }

        public Result(T data) {
            this.state = State.NTH;
            this.data = data;
        }

        public Result(State state, T data) {
            this.state = state;
            this.data = data;
        }

        public boolean isStopped() {
            return this.state == State.EXIST_BUT_NO_VALUE || this.state == State.ERROR;
        }
    }

    static enum State {
        NOT_EXIST,
        EXIST_BUT_NO_VALUE,
        NTH,
        ERROR,
        NO_VALUE;

    }
}

