/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.license;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.util.StringUtils;
import kd.ebg.egf.common.license.EbgLicenseModuleEnum;
import kd.ebg.egf.common.license.TenantInfo;
import kd.ebg.egf.common.license.old.LicenseManager;
import kd.ebg.egf.common.license.old.OldLicenseCache;
import kd.ebg.egf.common.model.license.LicenseDetail;
import kd.ebg.egf.common.model.license.LicenseFile;
import kd.ebg.egf.common.repository.license.LicenseFileRepository;

public class OldLicensePlugin
extends AbstractFormPlugin
implements ClickListener,
HyperLinkClickListener {
    private static final String UPLOADLIC = "uploadLic";
    private static final String BTN_DELETE = "deleteLicense";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Lang lang = Lang.get();
        this.getModel().setValue("help_desc", (Object)ResManager.loadKDString((String)"1.\u4ec5\u652f\u6301\u5bfc\u5165\u94f6\u4f01\u4e914.0\u7248\u672c\u8bb8\u53ef\u3002\u82e5\u9700\u4f7f\u7528\u94f6\u4f01\u4e915.0\u53ca\u4ee5\u4e0a\u7248\u672c\u7684\u8bb8\u53ef\uff0c\u5219\u52a1\u5fc5\u901a\u8fc7\u3010\u5220\u9664\u3011\u6309\u94ae\u5220\u6389\u672c\u8bb8\u53ef\u540e\u65b9\u53ef\u751f\u6548\u3002\u8bb8\u53ef\u63a7\u5236\u903b\u8f91\u4ee5\u661f\u701a5.0\u53ca\u4ee5\u4e0a\u7248\u672c\u7684\u53d1\u6587\u4e2d\u94f6\u4f01\u4e91\u7684\u63a7\u5236\u903b\u8f91\u4e3a\u51c6\u3002", (String)"HELP_DESC_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("help_desc1", (Object)ResManager.loadKDString((String)"2.\u5f534.0\u7248\u672c\u8bb8\u53ef\u8fc7\u671f\u65f6\uff0c\u5efa\u8bae\u8d2d\u4e70\u94f6\u4f01\u4e915.0\u53ca\u4ee5\u4e0a\u7248\u672c\u8bb8\u53ef\uff0c\u672c\u529f\u80fd\u4e3b\u8981\u7528\u4e8e\u4ece\u94f6\u4f01\u4e914.0\u7248\u672c\u5347\u7ea7\u52305.0\u53ca\u4ee5\u4e0a\u7248\u672c\u7684\u8fc7\u6e21\u9636\u6bb5\u3002", (String)"HELP_DESC_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"upload_license", "delete", "refresh", "close", "feature_code"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("upload_license".equalsIgnoreCase(key)) {
            this.showUploadPage(ResManager.loadKDString((String)"\u4e0a\u4f20\u8bb8\u53ef", (String)"OldLicensePlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), UPLOADLIC);
        } else if ("delete".equalsIgnoreCase(key)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(BTN_DELETE, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb8\u53ef\u5417\uff1f", (String)"OldLicensePlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
        } else if ("refresh".equalsIgnoreCase(key)) {
            DynamicObjectType dynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)"aqap_license_detail").getDynamicObjectType();
            BusinessDataServiceHelper.removeCache((DynamicObjectType)dynamicObjectType);
            DynamicObjectType licenseFileDynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)"aqap_license_file").getDynamicObjectType();
            BusinessDataServiceHelper.removeCache((DynamicObjectType)licenseFileDynamicObjectType);
            this.getView().invokeOperation("refresh");
        } else if ("feature_code".equalsIgnoreCase(key)) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7279\u5f81\u7801:%s", (String)"OldLicensePlugin_6", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), LicenseManager.getCustomerFeatureCode((String)RequestContext.get().getTenantId())));
        } else if ("close".equalsIgnoreCase(key)) {
            this.getView().invokeOperation("close");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (MessageBoxResult.Yes == evt.getResult() && BTN_DELETE.equals(evt.getCallBackId())) {
            LicenseFile licenseFile = this.findLinceseByCustom();
            if (licenseFile == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5df2\u5bfc\u5165\u8bb8\u53ef\u6587\u4ef6\uff0c\u65e0\u9700\u5220\u9664\u3002", (String)"OldLicensePlugin_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            this.deleteLicenseFile();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"OldLicensePlugin_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
            return;
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showLicenseList();
    }

    private void showLicenseList() {
        this.getModel().deleteEntryData("entryentity");
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        TenantInfo tenant = OldLicenseCache.getTenant();
        ArrayList tempLists = Lists.newArrayList();
        List licenseDetails = tenant.getInfos();
        tempLists.addAll(licenseDetails);
        Map<String, List<LicenseDetail>> map = tempLists.stream().collect(Collectors.groupingBy(LicenseDetail::getModuleCode));
        ArrayList ebgLicenseModuleEnums = Lists.newArrayList((Object[])EbgLicenseModuleEnum.values());
        Iterator iterator = ebgLicenseModuleEnums.iterator();
        while (iterator.hasNext()) {
            EbgLicenseModuleEnum next = (EbgLicenseModuleEnum)iterator.next();
            if (!"EBG_NOTE".equalsIgnoreCase(next.getModuleCode()) && !"EBG_BR".equalsIgnoreCase(next.getModuleCode()) && !"EBG_CCY_PAY".equalsIgnoreCase(next.getModuleCode())) continue;
            iterator.remove();
        }
        List<EbgLicenseModuleEnum> sortList = ebgLicenseModuleEnums.stream().sorted(Comparator.comparing(EbgLicenseModuleEnum::getSort)).collect(Collectors.toList());
        sortList.forEach(ebgLicenseModuleEnum -> {
            String moduleCode = ebgLicenseModuleEnum.getModuleCode();
            List lists = (List)map.get(moduleCode);
            DynamicObject row = entries.addNew();
            this.setEntryValues((EbgLicenseModuleEnum)ebgLicenseModuleEnum, row, lists);
            row.set("module_expired_date", (Object)(StringUtils.isNotEmpty(tenant.getExpiredDate()) ? tenant.getExpiredDate().substring(0, 10) : tenant.getExpiredDate()));
            EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
            grid.setRowBackcolor("#eff3fd", new int[]{0});
        });
    }

    private void setEntryValues(EbgLicenseModuleEnum licenseModuleEnum, DynamicObject row, List<LicenseDetail> licenseDetailList) {
        String moduleCode = licenseModuleEnum.getModuleCode();
        String moduleName = licenseModuleEnum.getModuleName();
        row.set("license_module_name", (Object)moduleName);
        row.set("license_module_code", (Object)moduleCode);
        row.set("used_license_count", (Object)(licenseDetailList != null ? licenseDetailList.size() : 0));
        String businessScope = EbgLicenseModuleEnum.getBusinessScopeWithModuleCode((String)moduleCode);
        row.set("business_scope", (Object)businessScope);
        TenantInfo tenant = OldLicenseCache.getTenant();
        if (EbgLicenseModuleEnum.PAY.getModuleCode().equalsIgnoreCase(moduleCode)) {
            row.set("module_group_code", (Object)"PRO_AQAP");
            row.set("module_group_name", (Object)ResManager.loadKDString((String)"\u94f6\u4f01\u63a5\u53e3", (String)"LicenseInfoPlugin_12", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            row.set("license_count", (Object)tenant.getTotalLicenseCount());
            row.set("module_unused_count", (Object)tenant.getUnusedLicenseCount());
        } else {
            row.set("module_group_code", (Object)"");
            row.set("module_group_name", (Object)"");
        }
    }

    private LicenseFile findLinceseByCustom() {
        LicenseFileRepository licenseFileRepository = (LicenseFileRepository)SpringContextUtil.getBean(LicenseFileRepository.class);
        return licenseFileRepository.findByCustomId(RequestContext.get().getTenantId());
    }

    private void deleteLicenseFile() {
        String customID = RequestContext.get().getTenantId();
        QFilter filter = QFilter.of((String)"custom_id=?", (Object[])new Object[]{customID});
        DeleteServiceHelper.delete((String)"aqap_license_file", (QFilter[])filter.toArray());
    }

    private void showUploadPage(String pageCaption, String fieldKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("aqap_old_license_parse");
        StyleCss style = new StyleCss();
        style.setWidth("550");
        style.setHeight("400");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getOpenStyle().setInlineStyleCss(style);
        showParameter.setCaption(pageCaption);
        showParameter.setCustomParam("fieldKey", (Object)fieldKey);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
        this.getView().showForm(showParameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if ("used_license_count".equals(evt.getFieldName()) && evt.getRowIndex() >= 0) {
            DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            String licenseModuleCode = ((DynamicObject)collection.get(evt.getRowIndex())).getString("license_module_code");
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("licenseModuleCode", licenseModuleCode);
            FormShowParameter showParameter = OldLicensePlugin.getFormShowParameter(this, "aqap_license_detail_page", ResManager.loadKDString((String)"\u8bb8\u53ef\u4f7f\u7528\u8be6\u60c5", (String)"OldLicensePlugin_5", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), params, null);
            StyleCss style = new StyleCss();
            style.setWidth("800");
            style.setHeight("600");
            showParameter.getOpenStyle().setInlineStyleCss(style);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    private static FormShowParameter getFormShowParameter(AbstractFormPlugin form, String entity, String caption, Map<String, Object> params, String callback) {
        FormShowParameter p = new FormShowParameter();
        p.setFormId(entity);
        p.setCustomParams(params);
        p.setCaption(caption);
        if (callback != null) {
            p.setCloseCallBack(new CloseCallBack((IFormPlugin)form, callback));
        }
        return p;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String result;
        if (closedCallBackEvent.getReturnData() != null && "save_success".equals(result = (String)closedCallBackEvent.getReturnData())) {
            this.getView().invokeOperation("refresh");
        }
    }
}

