/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.license;

import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.license.EbgLicenseModuleEnum;
import kd.ebg.egf.common.license.LicenseCache;
import kd.ebg.egf.common.license.TenantInfo;
import kd.ebg.egf.common.license.old.OldLicenseCache;
import kd.ebg.egf.common.model.license.LicenseDetail;
import kd.ebg.egf.common.model.license.LicenseFile;
import kd.ebg.egf.common.repository.license.LicenseFileRepository;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class ShowLicenseDetailPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showLicenseDetailList();
    }

    private void showLicenseDetailList() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String licenseModuleCode = params.get("licenseModuleCode").toString();
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        List licenseDetails = null;
        if (EbgLicenseModuleEnum.NOTE.getModuleCode().equalsIgnoreCase(licenseModuleCode)) {
            TenantInfo tenantForNote = LicenseCache.getTenantForNote();
            licenseDetails = tenantForNote.getInfos();
        } else {
            LicenseFileRepository licenseFileRepository = (LicenseFileRepository)SpringContextUtil.getBean(LicenseFileRepository.class);
            LicenseFile licenseFile = licenseFileRepository.findByCustomId(RequestContext.get().getTenantId());
            TenantInfo tenantLicenseInfo = licenseFile != null ? OldLicenseCache.getTenant() : LicenseCache.getTenant();
            licenseDetails = tenantLicenseInfo.getInfos();
        }
        Map<String, List<LicenseDetail>> map = licenseDetails.stream().collect(Collectors.groupingBy(LicenseDetail::getModuleCode));
        List<LicenseDetail> detailList = map.get(licenseModuleCode);
        Comparator<LicenseDetail> comparing = Comparator.comparing(LicenseDetail::getCreatetime).reversed();
        if (detailList != null && detailList.size() > 0) {
            List<LicenseDetail> collect = detailList.stream().sorted(comparing).collect(Collectors.toList());
            List<String> bankVersions = collect.stream().map(LicenseDetail::getBankVersion).collect(Collectors.toList());
            Map<String, String> bankVersionMlNames = this.getBankVersionMlName(bankVersions);
            collect.forEach(licenseDetail -> {
                DynamicObject row = entries.addNew();
                this.setEntryValues(licenseModuleCode, row, (LicenseDetail)licenseDetail, bankVersionMlNames);
            });
        }
    }

    public Map<String, String> getBankVersionMlName(List<String> bankVersionIds) {
        HashMap<String, String> resultMap = new HashMap<String, String>(bankVersionIds.size());
        QFilter filter = new QFilter("number", "in", bankVersionIds);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"aqap_bank", (String)"id,number", (QFilter[])filter.toArray());
        for (Map.Entry map : dynamicObjectMap.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)map.getValue();
            String number = dynamicObject.getString("number");
            String bankName = dynamicObject.getLocaleString("name").getLocaleValue();
            resultMap.put(number, bankName);
        }
        return resultMap;
    }

    private void setEntryValues(String moduleCode, DynamicObject row, LicenseDetail licenseDetail, Map<String, String> bankVersionMlNames) {
        row.set("module_name", (Object)EbgLicenseModuleEnum.getModuleNameWithModuleCode((String)moduleCode));
        row.set("module_code", (Object)moduleCode);
        row.set("bank_version", (Object)licenseDetail.getBankVersion());
        String bankVersionName = bankVersionMlNames.get(licenseDetail.getBankVersion());
        if (StringUtils.isEmpty((String)bankVersionName)) {
            bankVersionName = BankBundleManager.getInstance().getBankVersionName(licenseDetail.getBankVersion());
        }
        row.set("bank_version_name", (Object)bankVersionName);
        row.set("createtime", (Object)DateUtil.transTimeZoneSystemToUser((LocalDateTime)licenseDetail.getCreatetime()));
    }
}

