/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.proxy;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.constant.CertSource;
import kd.ebg.aqap.common.model.constant.CertTypeEnum;
import kd.ebg.aqap.common.model.repository.CertRepository;
import kd.ebg.aqap.common.model.testnet.Response;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.ca.bean.KeyStoreInfo;
import kd.ebg.aqap.formplugin.ca.util.DigitalCertificateGenerator;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.aqap.formplugin.util.StringUtils;
import kd.ebg.aqap.formplugin.util.net.TestConnect;
import kd.ebg.egf.common.constant.CertType;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.file.FileCommonUtils;

public class BankLoginProxyPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String LOGIN_TREE_ENTITY = "login_tree_entity";
    private static final String BILL_BANK_LOGIN_FIELD = "bd_bank_login";
    private static final String entity = "aqap_proxy_config";
    private static final String properties = "id,proxy_host,proxy_port,proxy_type,custom_id,rsa_sign_algo,public_key,public_key_tag,public_key_alias,public_key_secret,private_key,private_key_tag,private_key_alias,private_key_secret";
    private static final String EB = "eb_BankLoginPlugin_";
    private static final String bank_login_entity = "aqap_proxy_bank_login";
    private static final String bank_login_properties = "bank_login_id,custom_id,insert_time,bank_name,bank_version";
    private static final String PRIVATE_KEY = "private_key";
    private static final String PUBLIC_KEY = "public_key";
    private static final String FIELD_PRIVATE_ALIAS = "private_alias";
    private static final String FIELD_PRIVATE_SECRET = "private_secret";
    private static final String FIELD_PRIVATE_NAME = "private_name";
    private static final String FIELD_PRIVATE_PATCH = "private_patch";
    private static final String FIELD_PUBLIC_ALIAS = "public_alias";
    private static final String FIELD_PUBLIC_SECRET = "public_secret";
    private static final String FIELD_PUBLIC_NAME = "public_name";
    private static final String FIELD_PUBLIC_PATCH = "public_patch";
    private static final String PRIVATE_CERTINFO = "eb_private_certInfo";
    private static final String PUBLIC_CERTINFO = "eb_public_certInfo";
    private CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);
    String pattern = "(?!^(\\d+|[a-zA-Z]+|[~!@#$%^&*()_.]+)$)^[\\w~!@#$%^&*()_.]{8,16}$";
    String msg = ResManager.loadKDString((String)"\u751f\u6210\u8bc1\u4e66\u65f6%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankLoginProxyPlugin_20", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit baseDataEdit = (BasedataEdit)this.getControl(BILL_BANK_LOGIN_FIELD);
        baseDataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        HashMap<String, String> fieldMap = new HashMap<String, String>(16);
        fieldMap.put("bc", "white");
        this.getView().updateControlMetadata("ebc_flexpanelap", fieldMap);
        this.getView().updateControlMetadata("ebc_flexpanelap1", fieldMap);
        this.getView().updateControlMetadata("ebc_flexpanelap2", fieldMap);
        this.getView().updateControlMetadata("ebc_flexpanelap3", fieldMap);
        this.getView().updateControlMetadata("ebc_advconchildpanelap3", fieldMap);
        this.getView().updateControlMetadata("ebc_advconchildpanelap2", fieldMap);
        this.getView().updateControlMetadata("ebc_advconchildpanelap", fieldMap);
        this.getView().updateControlMetadata("flex1", fieldMap);
        this.getView().updateControlMetadata("flex2", fieldMap);
        this.getView().updateControlMetadata("flex3", fieldMap);
        this.getView().updateControlMetadata("flex4", fieldMap);
        this.getView().updateControlMetadata("flex_upload1", fieldMap);
        this.getView().updateControlMetadata("flex_upload2", fieldMap);
        this.getView().updateControlMetadata("flex_private", fieldMap);
        this.getView().updateControlMetadata("flex_public", fieldMap);
        this.getView().updateControlMetadata("flex_sign_algo", fieldMap);
    }

    public void beforeBindData(EventObject e) {
        this.loadProxyConfig();
        this.loadProxyBankLogin();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        int row = this.getModel().getEntryCurrentRowIndex(LOGIN_TREE_ENTITY);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtil.equals(formOperate.getOperateKey(), "save")) {
            QFilter filter;
            DynamicObject object;
            boolean savaSuccess = this.saveProxyConfig();
            this.freshProxyBankLogins();
            if (savaSuccess && (object = BusinessDataServiceHelper.loadSingle((String)"aqap_bank_login", (String)"number", (QFilter[])(filter = QFilter.of((String)"custom_id=?", (Object[])new Object[]{RequestContext.get().getTenantId()})).toArray())) != null) {
                String bankLoginID = object.getString("number");
                Response response = TestConnect.getInstance().tryProxyConnect(RequestContext.get().getTenantId(), bankLoginID);
                if (!response.isSuccess() && response.isCosmic2ProxyStopped()) {
                    String errMsg = response.getErrMsg();
                    this.getView().showErrorNotification(errMsg);
                }
            }
        } else if (StringUtil.equals(formOperate.getOperateKey(), "delete")) {
            this.removeProxyBankLogin(row);
            this.getModel().deleteEntryRow(LOGIN_TREE_ENTITY, row);
            this.freshProxyBankLogins();
        } else if (StringUtil.equals(formOperate.getOperateKey(), "test")) {
            this.testConnection(row);
            this.freshProxyBankLogins();
        } else if (StringUtil.equals(formOperate.getOperateKey(), "submit")) {
            this.submitProxyBankLogin(row);
            this.freshProxyBankLogins();
        } else if ("upload_private_key".equalsIgnoreCase(formOperate.getOperateKey())) {
            this.showUploadPage(ResManager.loadKDString((String)"\u4e0a\u4f20\u79c1\u94a5\u8bc1\u4e66", (String)"BankLoginProxyPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), PRIVATE_KEY, true);
        } else if ("upload_public_key".equalsIgnoreCase(formOperate.getOperateKey())) {
            this.showUploadPage(ResManager.loadKDString((String)"\u4e0a\u4f20\u516c\u94a5\u8bc1\u4e66", (String)"BankLoginProxyPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), PUBLIC_KEY, true);
        } else if ("new_cert".equalsIgnoreCase(formOperate.getOperateKey())) {
            if (!this.validNewCert()) {
                args.setCancel(true);
                return;
            }
            this.newCaAndUpload();
        } else if ("delete_cert".equalsIgnoreCase(formOperate.getOperateKey())) {
            this.deleteCert();
        } else if ("download_cert".equalsIgnoreCase(formOperate.getOperateKey())) {
            if (StringUtils.isEmpty((String)this.getModel().getValue(FIELD_PRIVATE_NAME)) || StringUtils.isEmpty((String)this.getModel().getValue(FIELD_PUBLIC_NAME))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8bc1\u4e66\u8bb0\u5f55\uff0c\u65e0\u6cd5\u4e0b\u8f7d\u3002", (String)"BankLoginProxyPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            QFilter filter = QFilter.of((String)"custom_id=? and type=?", (Object[])new Object[]{RequestContext.get().getTenantId(), CertType.PROXY_CER.getType()});
            String selectProps = "bank_config_id, file_name, download_path";
            DynamicObject[] collections = BusinessDataServiceHelper.load((String)"aqap_bd_cert", (String)selectProps, (QFilter[])filter.toArray());
            HashMap<String, String> pathMap = new HashMap<String, String>(2);
            if (collections != null && collections.length > 0) {
                for (DynamicObject dynamicObject : collections) {
                    String path = dynamicObject.getString("download_path");
                    if (StringUtils.isEmpty(path)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5728\u7ebf\u751f\u6210\u7684\u8bc1\u4e66\uff0c\u65e0\u6cd5\u4e0b\u8f7d\u3002", (String)"BankLoginProxyPlugin_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    pathMap.put(dynamicObject.getString("bank_config_id"), path);
                }
                this.downloadCert(pathMap);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8bc1\u4e66\u8bb0\u5f55\uff0c\u65e0\u6cd5\u4e0b\u8f7d\u3002", (String)"BankLoginProxyPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private boolean downloadCert(Map<String, String> pathMap) {
        if (pathMap == null) {
            return false;
        }
        FileService fs = FileServiceFactory.getAttachmentFileService();
        String userAgent = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36";
        String privatePath = FileServiceExtFactory.getAttachFileServiceExt().getRealPath(pathMap.get(PRIVATE_KEY));
        String publicPath = FileServiceExtFactory.getAttachFileServiceExt().getRealPath(pathMap.get(PUBLIC_KEY));
        BatchDownloadRequest.File privateFile = new BatchDownloadRequest.File(ResManager.loadKDString((String)"\u516c\u94a5\u8bc1\u4e66.keystore", (String)"BankLoginProxyPlugin_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), privatePath);
        BatchDownloadRequest.File publicFile = new BatchDownloadRequest.File(ResManager.loadKDString((String)"\u79c1\u94a5\u8bc1\u4e66.keystore", (String)"BankLoginProxyPlugin_5", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), publicPath);
        BatchDownloadRequest bdr = new BatchDownloadRequest(ResManager.loadKDString((String)"\u7f51\u7edc\u4ee3\u7406\u5de5\u5177\u8bc1\u4e66", (String)"BankLoginProxyPlugin_6", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        bdr.setFiles(new BatchDownloadRequest.File[]{privateFile, publicFile});
        try {
            File file = File.createTempFile(ResManager.loadKDString((String)"\u7f51\u7edc\u4ee3\u7406\u5de5\u5177\u8bc1\u4e66", (String)"BankLoginProxyPlugin_6", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), ".zip");
            try (FileOutputStream out = new FileOutputStream(file);){
                fs.batchDownload(bdr, (OutputStream)out, userAgent);
                TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                try (FileInputStream fis = new FileInputStream(file);){
                    String url = cache.saveAsUrl(file.getName(), (InputStream)fis, 120);
                    this.getView().download(url);
                }
            }
            catch (Exception ex) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (String)"BankLoginProxyPlugin_7", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), (Throwable)ex);
            }
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.serviceException((Throwable)ex);
        }
        return true;
    }

    private boolean newCaAndUpload() {
        int days = 365;
        String fileDir = System.getProperty("user.dir") + File.separator + "proxy" + File.separator + RequestContext.get().getTenantId() + File.separator + RequestContext.get().getAccountId() + File.separator;
        boolean result = this.newServerKeystore(fileDir, days, "kclient.keystore", FIELD_PRIVATE_PATCH);
        if (result) {
            result = this.newServerKeystore(fileDir, days, "tclient.keystore", FIELD_PUBLIC_PATCH);
        }
        return result;
    }

    boolean newServerKeystore(String fileDir, int validDays, String fileName, String uploadResultKey) {
        String privateAlias = FIELD_PRIVATE_PATCH.equals(uploadResultKey) ? (String)this.getModel().getValue(FIELD_PRIVATE_ALIAS) : (String)this.getModel().getValue(FIELD_PUBLIC_ALIAS);
        String privateSecret = FIELD_PRIVATE_PATCH.equals(uploadResultKey) ? (String)this.getModel().getValue(FIELD_PRIVATE_SECRET) : (String)this.getModel().getValue(FIELD_PUBLIC_SECRET);
        File file = FileCommonUtils.getFileByPath((String)fileDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        String org = "kingdee";
        String cnName = ResManager.loadKDString((String)"\u94f6\u4f01\u4e91", (String)"BankLoginProxyPlugin_8", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
        String path = fileDir + fileName;
        KeyStoreInfo keyStoreInfo = new KeyStoreInfo(privateAlias, privateSecret, privateSecret, cnName, org, org, "ShenZhen", "GuangDong", "CN", new Date(), validDays, path);
        DigitalCertificateGenerator.generateJKS(keyStoreInfo);
        this.upload(fileName, path, uploadResultKey, validDays, privateSecret);
        FileCommonUtils.getFileByPath((String)path).delete();
        return true;
    }

    public boolean upload(String fileName, String filePath, String uploadResultKey, int validDays, String pwd) {
        File file = FileCommonUtils.getFileByPath((String)filePath);
        if (!file.exists()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0a\u4f20\u8bc1\u4e66\u5931\u8d25\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u8bc1\u4e66\u3002", (String)"BankLoginProxyPlugin_9", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        }
        FileService fs = FileServiceFactory.getAttachmentFileService();
        String path = FileNameUtils.getAttachmentFileName((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (Object)"keystore", (String)filePath);
        try (FileItem fi = null;
             FileInputStream inputStream = new FileInputStream(FileCommonUtils.checkPath((String)filePath));){
            fi = new FileItem(fileName, path, (InputStream)inputStream);
            fi.setCreateNewFileWhenExists(true);
            String resultPath = fs.upload(fi);
            CertInfo certInfo = new CertInfo();
            certInfo.setDownLoadPath(resultPath);
            certInfo.setCertPassword(pwd);
            certInfo.setFileName(fileName);
            certInfo.setExpireTime(LocalDateTime.now().plusDays(validDays));
            certInfo.setCustomID(RequestContext.get().getTenantId());
            try (FileInputStream inputStream2 = new FileInputStream(FileCommonUtils.checkPath((String)filePath));){
                String fileContent = DesUtil.encryptProxyCert((byte[])BankLoginProxyPlugin.input2byte(inputStream2), (String)RequestContext.get().getTenantId());
                certInfo.setFileContent(fileContent);
            }
            catch (Exception ex) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"BankLoginProxyPlugin_10", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), (Throwable)ex);
            }
            if (FIELD_PRIVATE_PATCH.equals(uploadResultKey)) {
                this.getModel().setValue(FIELD_PRIVATE_NAME, (Object)fileName);
                this.getPageCache().put(PRIVATE_CERTINFO, JSONObject.toJSONString((Object)certInfo));
            } else {
                this.getPageCache().put(PUBLIC_CERTINFO, JSONObject.toJSONString((Object)certInfo));
                this.getModel().setValue(FIELD_PUBLIC_NAME, (Object)fileName);
            }
        }
        return true;
    }

    public static final byte[] input2byte(InputStream inStream) throws IOException {
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[100];
        int rc = 0;
        while ((rc = inStream.read(buff, 0, 100)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        byte[] in2b = swapStream.toByteArray();
        return in2b;
    }

    private void freshProxyBankLogins() {
        ArrayList<String> opeIds = new ArrayList<String>(1);
        opeIds.add("submit");
        int rows = this.getModel().getEntryRowCount(LOGIN_TREE_ENTITY);
        for (int i = 0; i < rows; ++i) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(LOGIN_TREE_ENTITY, i);
            DynamicObject obj = (DynamicObject)dynamicObject.get(BILL_BANK_LOGIN_FIELD);
            if (obj == null) continue;
            String customID = RequestContext.get().getTenantId();
            String bankLogin = obj.getString("number");
            QFilter filter = QFilter.of((String)"custom_id=? and bank_login_id=?", (Object[])new Object[]{customID, bankLogin});
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)bank_login_entity, (String)bank_login_properties, (QFilter[])filter.toArray());
            if (object == null) continue;
            EntryGrid entryGrid = (EntryGrid)this.getControl(LOGIN_TREE_ENTITY);
            entryGrid.hideOperateItems("op", i, opeIds);
        }
    }

    void showUploadPage(String pageCaption, String fieldKey, boolean isUpload) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("aqap_cert_parse");
        StyleCss style = new StyleCss();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (!isUpload) {
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("type", (Object)CertType.PROXY_CER.getType());
            showParameter.setCustomParam("bank_config_id", (Object)fieldKey);
        }
        showParameter.setCustomParam("source", (Object)"proxy");
        showParameter.getOpenStyle().setInlineStyleCss(style);
        showParameter.setCaption(pageCaption);
        showParameter.setCustomParam("fieldKey", (Object)fieldKey);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() != null) {
            CertInfo certInfo = (CertInfo)JSONObject.parseObject((String)((String)closedCallBackEvent.getReturnData()), CertInfo.class);
            if (PRIVATE_KEY.equalsIgnoreCase(closedCallBackEvent.getActionId())) {
                this.getPageCache().put(PRIVATE_CERTINFO, JSONObject.toJSONString((Object)certInfo));
                this.getModel().setValue(FIELD_PRIVATE_NAME, (Object)certInfo.getFileName());
                this.getModel().setValue(FIELD_PRIVATE_SECRET, (Object)certInfo.getCertPassword());
            } else if (PUBLIC_KEY.equalsIgnoreCase(closedCallBackEvent.getActionId())) {
                this.getPageCache().put(PUBLIC_CERTINFO, JSONObject.toJSONString((Object)certInfo));
                this.getModel().setValue(FIELD_PUBLIC_NAME, (Object)certInfo.getFileName());
                if (StringUtil.isNotNil(certInfo.getCertPassword())) {
                    this.getModel().setValue(FIELD_PUBLIC_SECRET, (Object)certInfo.getCertPassword());
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        parameter.setShowApproved(false);
        ArrayList<Object> selectBankLogins = new ArrayList<Object>(1);
        int rows = this.getModel().getEntryRowCount(LOGIN_TREE_ENTITY);
        for (int i = 0; i < rows; ++i) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(LOGIN_TREE_ENTITY, i);
            DynamicObject obj = (DynamicObject)dynamicObject.get(BILL_BANK_LOGIN_FIELD);
            if (obj == null) continue;
            selectBankLogins.add(obj.get("number"));
        }
        QFilter filter = new QFilter("number", "not in", selectBankLogins);
        parameter.getListFilterParameter().setFilter(filter);
    }

    public boolean saveProxyConfig() {
        boolean isPublicChanaged;
        String host = this.getModel().getValue("proxy_host").toString();
        String port = this.getModel().getValue("proxy_port").toString();
        String algo = this.getModel().getValue("combo_sign_algo").toString();
        String privateName = this.getModel().getValue(FIELD_PRIVATE_NAME).toString();
        if (StringUtil.isNil(privateName)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u79c1\u94a5\u8bc1\u4e66\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u8bc1\u4e66", (String)"BankLoginProxyPlugin_12", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            return false;
        }
        String privateAlias = this.getModel().getValue(FIELD_PRIVATE_ALIAS).toString();
        String privatePWD = this.getModel().getValue(FIELD_PRIVATE_SECRET).toString();
        String publicName = this.getModel().getValue(FIELD_PUBLIC_NAME).toString();
        if (StringUtil.isNil(publicName)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u516c\u94a5\u8bc1\u4e66\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u8bc1\u4e66", (String)"BankLoginProxyPlugin_13", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            return false;
        }
        String publicAlias = this.getModel().getValue(FIELD_PUBLIC_ALIAS).toString();
        String publicPWD = this.getModel().getValue(FIELD_PUBLIC_SECRET).toString();
        String customID = RequestContext.get().getTenantId();
        QFilter filter = QFilter.of((String)"custom_id=?", (Object[])new Object[]{customID});
        DynamicObject dynamicObject = null;
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entity, (String)properties, (QFilter[])filter.toArray());
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entity);
            dynamicObject.set("custom_id", (Object)customID);
            dynamicObject.set("proxy_type", (Object)"SSLSoftProxy");
            dynamicObject.set("status", (Object)"A");
        } else {
            dynamicObject = dynamicObjects[0];
        }
        dynamicObject.set("proxy_host", (Object)host);
        dynamicObject.set("proxy_port", (Object)port);
        dynamicObject.set("rsa_sign_algo", (Object)algo);
        dynamicObject.set(PUBLIC_KEY, (Object)publicName);
        dynamicObject.set("public_key_alias", (Object)publicAlias);
        dynamicObject.set("public_key_secret", (Object)DesUtil.encryptPwd((String)publicPWD, (String)RequestContext.get().getTenantId()));
        dynamicObject.set(PRIVATE_KEY, (Object)privateName);
        dynamicObject.set("private_key_alias", (Object)privateAlias);
        dynamicObject.set("private_key_secret", (Object)DesUtil.encryptPwd((String)privatePWD, (String)RequestContext.get().getTenantId()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        boolean isPrivateChanaged = this.getPageCache().get(PRIVATE_CERTINFO) != null;
        boolean bl = isPublicChanaged = this.getPageCache().get(PUBLIC_CERTINFO) != null;
        if (!isPrivateChanaged && !isPublicChanaged) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002\u5efa\u8bae\u5230\u3010\u94f6\u4f01\u76d1\u63a7\u3011-\u3010\u8bc1\u4e66\u9884\u8b66\u76d1\u63a7\u3011\u4e2d\u8fdb\u884c\u201c\u8fc7\u671f\u9884\u8b66\u8bbe\u7f6e\u201d\uff0c\u4ee5\u514d\u672c\u8bc1\u4e66\u5230\u671f\u540e\u5f71\u54cd\u4e1a\u52a1\u3002", (String)"BankLoginProxyPlugin_14", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), Integer.valueOf(7000));
            return true;
        }
        DynamicObject[] certDynamicObjects = this.certRepository.loadCertByType(CertType.PROXY_CER.getType());
        MultiLangEnumBridge publicKeyBridge = new MultiLangEnumBridge("\u7f51\u7edc\u4ee3\u7406\u516c\u94a5\u8bc1\u4e66", "BankLoginProxyPlugin_16", "ebg-aqap-formplugin");
        MultiLangEnumBridge privateKeyBridge = new MultiLangEnumBridge("\u7f51\u7edc\u4ee3\u7406\u79c1\u94a5\u8bc1\u4e66", "BankLoginProxyPlugin_15", "ebg-aqap-formplugin");
        if (certDynamicObjects != null && certDynamicObjects.length > 0) {
            DynamicObject oldPrivate = null;
            DynamicObject oldPublic = null;
            for (DynamicObject certDynamicObject : certDynamicObjects) {
                if (PRIVATE_KEY.equals(certDynamicObject.get("bank_config_id"))) {
                    oldPrivate = certDynamicObject;
                    continue;
                }
                if (!PUBLIC_KEY.equals(certDynamicObject.get("bank_config_id"))) continue;
                oldPublic = certDynamicObject;
            }
            if (isPrivateChanaged) {
                if (oldPrivate != null) {
                    this.updateCer(PRIVATE_KEY, JsonUtil.toJsonLine((Object)privateKeyBridge), oldPrivate, (CertInfo)JSONObject.parseObject((String)this.getPageCache().get(PRIVATE_CERTINFO), CertInfo.class));
                } else {
                    this.addCer(PRIVATE_KEY, JsonUtil.toJsonLine((Object)privateKeyBridge), (CertInfo)JSONObject.parseObject((String)this.getPageCache().get(PRIVATE_CERTINFO), CertInfo.class));
                }
            }
            if (isPublicChanaged) {
                if (oldPublic != null) {
                    this.updateCer(PUBLIC_KEY, JsonUtil.toJsonLine((Object)publicKeyBridge), oldPublic, (CertInfo)JSONObject.parseObject((String)this.getPageCache().get(PUBLIC_CERTINFO), CertInfo.class));
                } else {
                    this.addCer(PUBLIC_KEY, JsonUtil.toJsonLine((Object)publicKeyBridge), (CertInfo)JSONObject.parseObject((String)this.getPageCache().get(PUBLIC_CERTINFO), CertInfo.class));
                }
            }
        } else {
            if (isPrivateChanaged) {
                this.addCer(PRIVATE_KEY, JsonUtil.toJsonLine((Object)privateKeyBridge), (CertInfo)JSONObject.parseObject((String)this.getPageCache().get(PRIVATE_CERTINFO), CertInfo.class));
            }
            if (isPublicChanaged) {
                this.addCer(PUBLIC_KEY, JsonUtil.toJsonLine((Object)publicKeyBridge), (CertInfo)JSONObject.parseObject((String)this.getPageCache().get(PUBLIC_CERTINFO), CertInfo.class));
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002\u5efa\u8bae\u5230\u3010\u94f6\u4f01\u76d1\u63a7\u3011-\u3010\u8bc1\u4e66\u9884\u8b66\u76d1\u63a7\u3011\u4e2d\u8fdb\u884c\u201c\u8fc7\u671f\u9884\u8b66\u8bbe\u7f6e\u201d\uff0c\u4ee5\u514d\u672c\u8bc1\u4e66\u5230\u671f\u540e\u5f71\u54cd\u4e1a\u52a1\u3002", (String)"BankLoginProxyPlugin_14", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), Integer.valueOf(7000));
        return true;
    }

    void updateCer(String key, String name, DynamicObject oldCerData, CertInfo certInfo) {
        this.initEBContext();
        certInfo.setCertType(CertTypeEnum.PROXY.getType() + "");
        certInfo.setCertSource(CertSource.SYSTEM.getSource() + "");
        certInfo.setAlert(oldCerData.getBoolean("is_alert"));
        certInfo.setAlertDay(oldCerData.getString("alert_day"));
        this.certRepository.updateCert(oldCerData, key, name, null, certInfo, CertType.PROXY_CER.getType());
        this.removeEBContext();
    }

    void addCer(String key, String name, CertInfo certInfo) {
        this.initEBContext();
        certInfo.setCertType(CertTypeEnum.PROXY.getType() + "");
        certInfo.setCertSource(CertSource.SYSTEM.getSource() + "");
        this.certRepository.addCert(key, name, null, certInfo, CertType.PROXY_CER.getType());
        this.removeEBContext();
    }

    private void initEBContext() {
        EBContext ebContext = EBContext.getContext();
        if (ebContext == null) {
            ebContext = EBContext.builder().build();
            EBContext.setContext((EBContext)ebContext);
        }
        String formId = this.getView().getFormShowParameter().getFormId();
        ebContext.setFormId(formId);
    }

    private void removeEBContext() {
        EBContext.destroy();
    }

    public void loadProxyConfig() {
        String customID = RequestContext.get().getTenantId();
        QFilter filter = QFilter.of((String)"custom_id=?", (Object[])new Object[]{customID});
        DynamicObject dynamicObject = null;
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entity, (String)properties, (QFilter[])filter.toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            dynamicObject = dynamicObjects[0];
            String id = dynamicObject.getString("id");
            String host = dynamicObject.getString("proxy_host");
            this.getModel().setValue("proxy_host", (Object)host);
            String port = dynamicObject.getString("proxy_port");
            this.getModel().setValue("proxy_port", (Object)port);
            String algo = dynamicObject.getString("rsa_sign_algo");
            this.getModel().setValue("combo_sign_algo", (Object)algo);
            String publicName = dynamicObject.getString(PUBLIC_KEY);
            this.getModel().setValue(FIELD_PUBLIC_NAME, (Object)publicName);
            String publicAlias = dynamicObject.getString("public_key_alias");
            this.getModel().setValue(FIELD_PUBLIC_ALIAS, (Object)publicAlias);
            String publicPWD = dynamicObject.getString("public_key_secret");
            publicPWD = DesUtil.decryptPwd((String)publicPWD, (String)RequestContext.get().getTenantId(), (String)entity, (String)id, (String)"public_key_secret");
            this.getModel().setValue(FIELD_PUBLIC_SECRET, (Object)publicPWD);
            String privateName = dynamicObject.getString(PRIVATE_KEY);
            this.getModel().setValue(FIELD_PRIVATE_NAME, (Object)privateName);
            String privateKey = dynamicObject.getString("private_key_tag");
            this.getPageCache().put(EB + privateName, privateKey);
            String privateAlias = dynamicObject.getString("private_key_alias");
            this.getModel().setValue(FIELD_PRIVATE_ALIAS, (Object)privateAlias);
            String privatePWD = dynamicObject.getString("private_key_secret");
            privatePWD = DesUtil.decryptPwd((String)privatePWD, (String)RequestContext.get().getTenantId(), (String)entity, (String)id, (String)"private_key_secret");
            this.getModel().setValue(FIELD_PRIVATE_SECRET, (Object)privatePWD);
        }
    }

    public void loadProxyBankLogin() {
        String customID = RequestContext.get().getTenantId();
        QFilter filter = QFilter.of((String)"custom_id=?", (Object[])new Object[]{customID});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)bank_login_entity, (String)bank_login_properties, (QFilter[])filter.toArray());
        EntryGrid entryGrid = (EntryGrid)this.getControl(LOGIN_TREE_ENTITY);
        ArrayList<String> opeIds = new ArrayList<String>(1);
        opeIds.add("submit");
        BasedataEdit baseDataEdit = (BasedataEdit)this.getControl(BILL_BANK_LOGIN_FIELD);
        if (dynamicObjects != null && !dynamicObjects.isEmpty()) {
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                int row = this.getModel().createNewEntryRow(LOGIN_TREE_ENTITY);
                String bankLogin = ((DynamicObject)dynamicObjects.get(i)).getString("bank_login_id");
                DynamicObject dynamicObject = this.getModel().getEntryRowEntity(LOGIN_TREE_ENTITY, row);
                QFilter filter1 = QFilter.of((String)"number=?", (Object[])new Object[]{bankLogin});
                DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"aqap_bank_login", (String)"number", (QFilter[])filter1.toArray());
                dynamicObject.set(BILL_BANK_LOGIN_FIELD, (Object)object);
                entryGrid.hideOperateItems("op", row, opeIds);
                baseDataEdit.setEnable("", false, row);
            }
        }
    }

    public void submitProxyBankLogin(int row) {
        String bankLogin = "";
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity(LOGIN_TREE_ENTITY, row);
        DynamicObject obj = (DynamicObject)dynamicObject.get(BILL_BANK_LOGIN_FIELD);
        if (obj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u53d6\u94f6\u884c\u524d\u7f6e\u673a\u3002", (String)"BankLoginProxyPlugin_17", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            return;
        }
        bankLogin = obj.get("number").toString();
        String customID = RequestContext.get().getTenantId();
        QFilter filter = QFilter.of((String)"custom_id=? and bank_login_id=?", (Object[])new Object[]{customID, bankLogin});
        dynamicObject = BusinessDataServiceHelper.loadSingle((String)bank_login_entity, (String)bank_login_properties, (QFilter[])filter.toArray());
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)bank_login_entity);
            dynamicObject.set("bank_login_id", (Object)bankLogin);
            dynamicObject.set("custom_id", (Object)customID);
            dynamicObject.set("status", (Object)"A");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
        BasedataEdit baseDataEdit = (BasedataEdit)this.getControl(BILL_BANK_LOGIN_FIELD);
        baseDataEdit.setEnable("", false, row);
        EntryGrid entryGrid = (EntryGrid)this.getControl(LOGIN_TREE_ENTITY);
        ArrayList<String> opeIds = new ArrayList<String>(1);
        opeIds.add("submit");
        entryGrid.hideOperateItems("op", row, opeIds);
    }

    public void removeProxyBankLogin(int row) {
        String bankLogin = this.getBankLogin(row);
        if (StringUtil.isNotNil(bankLogin)) {
            String customID = RequestContext.get().getTenantId();
            QFilter filter = QFilter.of((String)"custom_id=? and bank_login_id=?", (Object[])new Object[]{customID, bankLogin});
            DeleteServiceHelper.delete((String)bank_login_entity, (QFilter[])filter.toArray());
        }
    }

    public void testConnection(int row) {
        String bankLogin = this.getBankLogin(row);
        if (StringUtil.isNotNil(bankLogin)) {
            String customId = RequestContext.get().getTenantId();
            TestConnect testConnect = TestConnect.getInstance();
            Response response = testConnect.tryMultiProxyConnect(customId, bankLogin);
            if (response.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u6210\u529f\u3002", (String)"BankLoginPlugin_8", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(response.getErrMsg());
            }
        }
    }

    public String getBankLogin(int row) {
        String bankLogin = "";
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity(LOGIN_TREE_ENTITY, row);
        DynamicObject obj = (DynamicObject)dynamicObject.get(BILL_BANK_LOGIN_FIELD);
        if (obj != null) {
            bankLogin = obj.get("number").toString();
        }
        return bankLogin;
    }

    boolean validNewCert() {
        String privateSecret = (String)this.getModel().getValue(FIELD_PRIVATE_SECRET);
        String publicSecret = (String)this.getModel().getValue(FIELD_PUBLIC_SECRET);
        String privateAlias = (String)this.getModel().getValue(FIELD_PRIVATE_ALIAS);
        String publicAlias = (String)this.getModel().getValue(FIELD_PUBLIC_ALIAS);
        if (StringUtils.isNotEmpty((String)this.getModel().getValue(FIELD_PRIVATE_NAME)) || StringUtils.isNotEmpty((String)this.getModel().getValue(FIELD_PUBLIC_NAME))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u5b58\u5728CA\u8bc1\u4e66\u8bb0\u5f55\uff0c\u8bf7\u5220\u9664\u8bc1\u4e66\u540e\u518d\u64cd\u4f5c\u3002", (String)"BankLoginProxyPlugin_21", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        } else if (StringUtils.isEmpty(privateAlias)) {
            this.getView().showTipNotification(String.format(this.msg, ResManager.loadKDString((String)"\u79c1\u94a5\u522b\u540d", (String)"BankLoginProxyPlugin_22", (String)"ebg-aqap-formplugin", (Object[])new Object[0])));
        } else if (StringUtils.isEmpty(privateSecret)) {
            this.getView().showTipNotification(String.format(this.msg, ResManager.loadKDString((String)"\u79c1\u94a5\u5bc6\u7801", (String)"BankLoginProxyPlugin_23", (String)"ebg-aqap-formplugin", (Object[])new Object[0])));
        } else if (!Pattern.matches(this.pattern, privateSecret)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u79c1\u94a5\u5bc6\u7801\u9700\u8981\u5305\u542b\u6700\u5c118\u4f4d\u5927\u5c0f\u5199\u5b57\u6bcd\u548c\u6570\u5b57\u7684\u7ec4\u5408\u3002", (String)"BankLoginProxyPlugin_24", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        } else if (StringUtils.isEmpty(publicAlias)) {
            this.getView().showTipNotification(String.format(this.msg, ResManager.loadKDString((String)"\u516c\u94a5\u522b\u540d", (String)"BankLoginProxyPlugin_25", (String)"ebg-aqap-formplugin", (Object[])new Object[0])));
        } else if (!privateAlias.equals(publicAlias)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u516c\u94a5\u522b\u540d\u548c\u79c1\u94a5\u522b\u540d\u9700\u4fdd\u6301\u4e00\u81f4\u3002", (String)"BankLoginProxyPlugin_29", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        } else if (StringUtils.isEmpty(publicSecret)) {
            this.getView().showTipNotification(String.format(this.msg, ResManager.loadKDString((String)"\u516c\u94a5\u5bc6\u7801", (String)"BankLoginProxyPlugin_26", (String)"ebg-aqap-formplugin", (Object[])new Object[0])));
        } else if (!privateSecret.equals(publicSecret)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u516c\u94a5\u5bc6\u7801\u548c\u79c1\u94a5\u5bc6\u7801\u9700\u4fdd\u6301\u4e00\u81f4\u3002", (String)"BankLoginProxyPlugin_30", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        } else if (!Pattern.matches(this.pattern, publicSecret)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u516c\u94a5\u5bc6\u7801\u9700\u8981\u5305\u542b\u6700\u5c118\u4f4d\u5927\u5c0f\u5199\u5b57\u6bcd\u548c\u6570\u5b57\u7684\u7ec4\u5408\u3002", (String)"BankLoginProxyPlugin_27", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        } else if (!"SHA256".equals(this.getModel().getValue("combo_sign_algo"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5728\u7ebf\u751f\u6210\u8bc1\u4e66\u53ea\u652f\u6301SHA256\u7b7e\u540d\u7b97\u6cd5\u3002", (String)"BankLoginProxyPlugin_28", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        } else {
            return true;
        }
        return false;
    }

    boolean deleteCert() {
        this.getModel().setValue(FIELD_PRIVATE_ALIAS, (Object)"");
        this.getModel().setValue(FIELD_PRIVATE_SECRET, (Object)"");
        this.getModel().setValue(FIELD_PRIVATE_NAME, (Object)"");
        this.getModel().setValue(FIELD_PUBLIC_ALIAS, (Object)"");
        this.getModel().setValue(FIELD_PUBLIC_NAME, (Object)"");
        this.getModel().setValue(FIELD_PUBLIC_SECRET, (Object)"");
        return true;
    }
}

