/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ynnx.dc.services;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Packer {
    public static final int DETAIL_PAGE_SIZE = 100;

    public static String packAllocation(BankPayRequest bankPayRequest, String transCode) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = Packer.packRoot();
        Packer.packHead(root, transCode, paymentInfo.getBankDetailSeqID());
        Element body = Packer.packBody(root);
        Element map = Packer.packMap(body);
        JDomUtils.addChild((Element)map, (String)"PayerAcNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)map, (String)"PayerAcName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)map, (String)"PayeeAcNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)map, (String)"PayeeAcName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)map, (String)"Amount", (String)paymentInfo.getAmount().toPlainString());
        JDomUtils.addChild((Element)map, (String)"Currency", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)map, (String)"Remark", (String)(paymentInfo.getExplanation().length() > 30 ? paymentInfo.getExplanation().substring(0, 30) : paymentInfo.getExplanation()));
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String packDetail(BankDetailRequest bankDetailRequest, String transCode, String pageTag) {
        Element root = Packer.packRoot();
        Packer.packHead(root, transCode);
        Element body = Packer.packBody(root);
        Element map = Packer.packMap(body);
        JDomUtils.addChild((Element)map, (String)"AcNo", (String)bankDetailRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)map, (String)"QryOrd", (String)"2");
        JDomUtils.addChild((Element)map, (String)"DCFlag", (String)"0");
        JDomUtils.addChild((Element)map, (String)"MinAmt", (String)"0.00");
        JDomUtils.addChild((Element)map, (String)"MaxAmt", (String)"0.00");
        JDomUtils.addChild((Element)map, (String)"BeginDate", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)map, (String)"EndDate", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)map, (String)"PageSize", (String)String.valueOf(100));
        JDomUtils.addChild((Element)map, (String)"PageNum", (String)pageTag);
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String packBalance(BankBalanceRequest bankBalanceRequest, String transCode) {
        Element root = Packer.packRoot();
        Packer.packHead(root, transCode);
        Element body = Packer.packBody(root);
        Element map = Packer.packMap(body);
        String accNo = bankBalanceRequest.getAcnt().getAccNo();
        String bankCurrency = bankBalanceRequest.getBankCurrency();
        JDomUtils.addChild((Element)map, (String)"AcNo", (String)accNo);
        JDomUtils.addChild((Element)map, (String)"Currency", (String)bankCurrency);
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static Element packHead(Element root, String transCode) {
        Element head = JDomUtils.addChild((Element)root, (String)"Head");
        JDomUtils.addChild((Element)head, (String)"TransCode", (String)transCode);
        JDomUtils.addChild((Element)head, (String)"ERPTrsTimestamp", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        JDomUtils.addChild((Element)head, (String)"ERPJnlNo", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)head, (String)"TrsFlag", (String)"0");
        return head;
    }

    public static Element packHead(Element root, String transCode, String erpJnlNo) {
        Element head = JDomUtils.addChild((Element)root, (String)"Head");
        JDomUtils.addChild((Element)head, (String)"TransCode", (String)transCode);
        JDomUtils.addChild((Element)head, (String)"ERPTrsTimestamp", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        JDomUtils.addChild((Element)head, (String)"ERPJnlNo", (String)erpJnlNo);
        JDomUtils.addChild((Element)head, (String)"TrsFlag", (String)"0");
        return head;
    }

    public static Element packMap(Element body) {
        return JDomUtils.addChild((Element)body, (String)"Map");
    }

    public static Element packBody(Element root) {
        return JDomUtils.addChild((Element)root, (String)"Body");
    }

    public static Element packRoot() {
        return JDomUtils.createRoot((String)"Message");
    }
}

