package kd.ebg.aqap.banks.jxnsb.cmp;

import com.google.common.collect.Lists;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfigType;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;

import java.util.List;

public class BankBusinessConfig extends BankPropertyConfig {
    @Override
    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        List<PropertyConfigItem> bankProps = super.getBankAddtionalPropertyConfigItems(true, false);
        bankProps.addAll(Lists.newArrayList(
                JXNSB_DC_SALARY_SELECT,
                JXNSB_DC_SALARY_SAME_BANK,
                JXNSB_DC_SALARY_OTHER_BANK,
                JXNSB_DC_SALARY_BATCH_SIZE,
                TextNoEncode
        ));
        return bankProps;
    }

    private static final PropertyConfigItem JXNSB_DC_SALARY_SELECT =
            PropertyConfigItem.builder()
                    .key(SALARY_SELECT)
                    .mlName(new MultiLangEnumBridge("关联接口", "BankBusinessConfig_0", "ebg-aqap-banks-jxnsb-cmp"))
                    .mlDesc(new MultiLangEnumBridge("已对接的代发业务接口:1)代发工资 (300002交易);", "BankBusinessConfig_12", "ebg-aqap-banks-jxnsb-cmp"))
                    .mlSourceNames(new MultiLangEnumBridge("代发工资 (300002交易)", "BankBusinessConfig_3", "ebg-aqap-banks-jxnsb-cmp"))
                    .sourceValues(Lists.newArrayList(ResManager.loadKDString("代发工资 (300002交易)", "BankBusinessConfig_3", "ebg-aqap-banks-jxnsb-cmp")))
                    .defaultValues(Lists.newArrayList(ResManager.loadKDString("代发工资 (300002交易)", "BankBusinessConfig_3", "ebg-aqap-banks-jxnsb-cmp")))
                    .mustInput(true)
                    .type(BankPropertyConfigType.PAY_FOR_SALARY_PARAM.getName())
                    .build();

    private static final PropertyConfigItem JXNSB_DC_SALARY_SAME_BANK =
            PropertyConfigItem.builder()
                    .key(SALARY_SAME_BANK)
                    .mlName(new MultiLangEnumBridge("是否支持同行代发工资", "BankBusinessConfig_4", "ebg-aqap-banks-jxnsb-cmp"))
                    .mlDesc(Lists.newArrayList(new MultiLangEnumBridge("是否支持同行代发工资:1)是;", "BankBusinessConfig_13", "ebg-aqap-banks-jxnsb-cmp")
                            , new MultiLangEnumBridge("2)否;", "BankBusinessConfig_14", "ebg-aqap-banks-jxnsb-cmp")))
                    .mlSourceNames(mlTrueFalseCN)
                    .sourceValues(trueFalseEN)
                    .defaultValues(defaultTrue)
                    .isHide(true)
                    .readonly(true)
                    .type(BankPropertyConfigType.PAY_FOR_SALARY_PARAM.getName())
                    .build();
    private static final PropertyConfigItem JXNSB_DC_SALARY_OTHER_BANK =
            PropertyConfigItem.builder()
                    .key(SALARY_OTHER_BANK)
                    .mlName(new MultiLangEnumBridge("是否支持跨行代发工资", "BankBusinessConfig_8", "ebg-aqap-banks-jxnsb-cmp"))
                    .mlDesc(Lists.newArrayList(new MultiLangEnumBridge("是否支持跨行代发工资:1)是;", "BankBusinessConfig_15", "ebg-aqap-banks-jxnsb-cmp"),
                            new MultiLangEnumBridge("2)否;", "BankBusinessConfig_14", "ebg-aqap-banks-jxnsb-cmp")))
                    .mlSourceNames(mlTrueFalseCN)
                    .sourceValues(trueFalseEN)
                    .defaultValues(defaultTrue)
                    .isHide(true)
                    .readonly(true)
                    .type(BankPropertyConfigType.PAY_FOR_SALARY_PARAM.getName())
                    .build();

    private static final PropertyConfigItem JXNSB_DC_SALARY_BATCH_SIZE =
            PropertyConfigItem.builder()
                    .key(SALARY_BATCH_SIZE)
                    .mlName(new MultiLangEnumBridge("每批笔数", "BankBusinessConfig_10", "ebg-aqap-banks-jxnsb-cmp"))
                    .mlDesc(new MultiLangEnumBridge("代发接口每个批次支持的笔数。", "BankBusinessConfig_11", "ebg-aqap-banks-jxnsb-cmp"))
                    .sourceNames(Lists.newArrayList("1000"))
                    .sourceValues(Lists.newArrayList("1000"))
                    .defaultValues(Lists.newArrayList("1000"))
                    .isHide(true)
                    .readonly(true)
                    .type(BankPropertyConfigType.PAY_FOR_SALARY_PARAM.getName())
                    .build();

    public final static PropertyConfigItem TextNoEncode =
            PropertyConfigItem.builder()
                    .key("TextNoEncode")
                    .mlName(new MultiLangEnumBridge("TextNoEncode", "", "ebg-aqap-banks-gsnx-dc"))
                    .mlDesc(Lists.newArrayList(new MultiLangEnumBridge("sit_test", "", "ebg-aqap-banks-gsnx-dc")))
                    .mlSourceNames(mlTrueFalseCN)
                    .sourceValues(trueFalseEN)
                    .defaultValues(defaultTrue)
                    .isHide(true)
                    .mustInput(true)
                    .type(BankPropertyConfigType.PAY_FOR_SALARY_PARAM.getName())
                    .build();

    public static boolean getTextNoEncode() {
        return TextNoEncode.getCurrentValueAsBoolean();
    }
}
