package kd.ebg.aqap.banks.jxnsb.cmp.services.payment;
import kd.bos.dataentity.resource.ResManager;

import kd.ebg.aqap.banks.jxnsb.cmp.services.Common;
import kd.ebg.aqap.banks.jxnsb.cmp.services.Constants;
import kd.ebg.aqap.banks.jxnsb.cmp.services.Packer;
import kd.ebg.aqap.banks.jxnsb.cmp.services.utils.EncodeAnDecodeHandler;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import org.jdom2.Element;

import java.io.InputStream;
import java.util.List;

public class PaymentImpl extends AbstractPayImpl implements IPay {
    @Override
    public int getBatchSize() {
        return 0;
    }

    @Override
    public Class<? extends IQueryPay> defaultQueryClass() {
        return QryPaymentImpl.class;
    }

    @Override
    public String pack(BankPayRequest bankPayRequest) {
        List<PaymentInfo> paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = paymentInfos.get(0);
        String tr_code = Constants.CODE_Payment;
        Element ap = Packer.createCommonHead(tr_code, paymentInfo.getPackageId(), "0"); // 报文头
        Element body = ap.getChild(Constants.XML_body);
        JDomUtils.addChild(body, "cert_type", "");//凭证种类
        JDomUtils.addChild(body, "cert_no", paymentInfo.getPackageId());//凭证号

        JDomUtils.addChild(body, "pay_acno", paymentInfo.getAccNo()); // 账号
        JDomUtils.addChild(body, "pay_cur_code", paymentInfo.getCurrency());//付款币种
        JDomUtils.addChild(body, "pay_acname", paymentInfo.getAccName());//付款户名
        JDomUtils.addChild(body, "pay_accaddr", "");//付款地址
        JDomUtils.addChild(body, "as_flag", "");//账簿标志
        JDomUtils.addChild(body, "as_acno", "");//账簿号
        JDomUtils.addChild(body, "as_acname", "");//账簿名称
        JDomUtils.addChild(body, "subject_code", "");//科目代码
        JDomUtils.addChild(body, "vir_acno", "");//虚账号
        JDomUtils.addChild(body, "vir_acname", "");//虚账号名称
        JDomUtils.addChild(body, "bank_flag", paymentInfo.is2SameBank() ? "0" : "1");//银行标志 0：本行 1：他行
        JDomUtils.addChild(body, "area_flag", paymentInfo.is2SameCity() ? "0" : "1");//同城异地标志 0：同城 1：异地
        JDomUtils.addChild(body, "urgency_flag", paymentInfo.is2Urgent() ? "1" : "0");//加急标志 0：普通 1：快速 2-实时
        JDomUtils.addChild(body, "rcv_acno", paymentInfo.getIncomeAccNo());//收款账号
        JDomUtils.addChild(body, "rcv_cur_code", paymentInfo.getCurrency());//收款币种
        JDomUtils.addChild(body, "rcv_acname", paymentInfo.getIncomeAccName());//收款户名
        JDomUtils.addChild(body, "rcv_bank_no", paymentInfo.getIncomeCnaps());//收款行号
        JDomUtils.addChild(body, "rcv_bank_name", paymentInfo.getIncomeBankName());//收款行名
        JDomUtils.addChild(body, "mobiles", paymentInfo.getMobiles());//收款方手机号码
        JDomUtils.addChild(body, "saverecvinfo_flag", "");//是否保存收款方信息
        JDomUtils.addChild(body, "rcv_accaddr", "");//收款人地址
        JDomUtils.addChild(body, "amt", paymentInfo.getAmount().toPlainString());//交易金额
        JDomUtils.addChild(body, "booking_flag", "");//预约标志 0－是实时交易		1－是预约交易
        JDomUtils.addChild(body, "booking_date", "");//预约日期
        JDomUtils.addChild(body, "booking_time", "");//预约时间
        JDomUtils.addChild(body, "purpose", paymentInfo.getExplanation());//用途
        JDomUtils.addChild(body, "postscript", "");//附言
        JDomUtils.addChild(body, "CAPTCHA", "");//验证码

        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration(ap, encoding);
        xmlMsg = EncodeAnDecodeHandler.encode(xmlMsg);
        return Common.createCommonMsg(xmlMsg);
    }

    @Override
    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        s = EncodeAnDecodeHandler.decode(s);
        List<PaymentInfo> paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root(s, encoding);

        Element head = ap.getChild(Constants.XML_head);
        BankResponse response = Common.parseBankResponse(head);
        if ("0_0000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(paymentInfos, PaymentState.SUBMITED, ResManager.loadKDString("银行处理中", "PaymentImpl_0", "ebg-aqap-banks-jxnsb-cmp"), response.getResponseCode(), response.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState(paymentInfos, PaymentState.UNKNOWN, ResManager.loadKDString("交易结果未知", "PaymentImpl_1", "ebg-aqap-banks-jxnsb-cmp"), response.getResponseCode(), response.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    @Override
    public String getDeveloper() {
        return null;
    }

    @Override
    public String getBizCode() {
        return ResManager.loadKDString("300001交易", "PaymentImpl_2", "ebg-aqap-banks-jxnsb-cmp");
    }

    @Override
    public String getBizDesc() {
        return ResManager.loadKDString("对外支付(300001交易),查询转账交易流水状态 (200205交易)", "PaymentImpl_3", "ebg-aqap-banks-jxnsb-cmp");
    }

    @Override
    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType());
    }

    @Override
    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg(super.recv(inputStream));
    }
}
