package kd.ebg.aqap.banks.jxnsb.cmp.services.payment.Salary;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jxnsb.cmp.services.Common;
import kd.ebg.aqap.banks.jxnsb.cmp.services.Constants;
import kd.ebg.aqap.banks.jxnsb.cmp.services.Packer;
import kd.ebg.aqap.banks.jxnsb.cmp.services.utils.EncodeAnDecodeHandler;
import kd.ebg.aqap.banks.jxnsb.cmp.services.proxy.FileDownLoad;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.util.CommonPayStatusMatchUtil;
import kd.ebg.aqap.business.util.pojo.BankResPaymentInfo;
import kd.ebg.aqap.business.util.pojo.MatchPayStatusModel;
import kd.ebg.aqap.business.util.pojo.MatchRule;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class QrySalPaymentImpl extends AbstractQueryPayImpl implements IQueryPay {
    private final static EBGLogger log = EBGLogger.getInstance().getLogger(QrySalPaymentImpl.class);

    @Override
    public int getBatchSize() {
        return 500;
    }

    @Override
    public String pack(BankPayRequest bankPayRequest) {
        List<PaymentInfo> paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = paymentInfos.get(0);
        String tr_code = Constants.CODE_SalaryDetail;
        String req_no = Sequence.genSequence();
        Element ap = Packer.createCommonHead(tr_code, req_no, "0"); // 报文头
        Element body = ap.getChild(Constants.XML_body);

        String serial_no = PaymentInfoSysFiled.get(paymentInfo, Constants.JXNSBSERIALNO);
        LocalDateTime submitSuccessTime = paymentInfo.getSubmitSuccessTime();
        if(StringUtils.isEmpty(serial_no)){
            throw EBExceiptionUtil.payUnknownException(ResManager.loadKDString("流水号serial_no为空。","QrySalPaymentImpl_8","ebg-aqap-banks-jxnsb-cmp"));
        }else if(submitSuccessTime == null){
            throw EBExceiptionUtil.payUnknownException(ResManager.loadKDString("交易日期tr_acdt为空。","QrySalPaymentImpl_7","ebg-aqap-banks-jxnsb-cmp"));
        }
        String d = submitSuccessTime.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild(body, "tr_acdt", d); // 交易日期
        JDomUtils.addChild(body, "batch_no", paymentInfo.getPackageId()); // 批次号
        JDomUtils.addChild(body, "serial_no", serial_no); // 平台流水号
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration(ap, encoding);
        xmlMsg = EncodeAnDecodeHandler.encode(xmlMsg);
        return Common.createCommonMsg(xmlMsg);
    }

    @Override
    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        s = EncodeAnDecodeHandler.decode(s);
        List<PaymentInfo> infos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root(s, encoding);

        Element head = ap.getChild(Constants.XML_head);
        BankResponse response = Common.parseBankResponse(head);

        if (!"0_0000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(infos, PaymentState.UNKNOWN, ResManager.loadKDString("交易结果未知", "QrySalPaymentImpl_0", "ebg-aqap-banks-jxnsb-cmp"), response.getResponseCode(), response.getResponseMessage());
            return new EBBankPayResponse(infos);
        }

        Element body = ap.getChild(Constants.XML_body);
        String record_num = body.getChildTextTrim(Constants.XML_record_num);
        String field_num = body.getChildTextTrim(Constants.XML_field_num);
        String file_name = body.getChildTextTrim(Constants.XML_file_name);
        int recordNum = -1;
        if (!StringUtils.isEmpty(record_num)) {
            recordNum = Integer.parseInt(record_num);
        }

        int fieldNum = -1;
        if (!StringUtils.isEmpty(field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }

        if (recordNum <= 0) {
            EBGBusinessUtils.setPaymentState(infos, PaymentState.UNKNOWN, String.format(ResManager.loadKDString("交易结果未知，银行返回记录条数=%s。", "QrySalPaymentImpl_6", "ebg-aqap-banks-jxnsb-cmp") , record_num), "", "");
            return new EBBankPayResponse(infos);
        }

        String file_flag = head.getChildTextTrim(Constants.XML_file_flag);//0-报文1-文件
        String content = "";
        if ("1".equals(file_flag)) {//文件
            log.info("###本次[代发工资结果明细查询]返回'文件'");
            content = new FileDownLoad().doBiz(file_name);
        } else {
            log.info("###本次[代发工资结果明细查询]返回'报文'");
            content = body.getChildTextTrim(Constants.XML_serial_record);
        }
        log.info("###本次[代发工资结果明细查询]的具体内容：" + content);
        String[][] rs = parseRecord(content, recordNum, fieldNum);
        ArrayList<BankResPaymentInfo> bankResPaymentInfos = new ArrayList<>(16);
        for (int i = 0; i < rs.length; i++) {
            //交易序号|账号|币种|账户名|借贷标志|金额|摘要|交易日期|交易时间|状态|错误信息|批次号|
            String ACNO = rs[i][1];//账号
            String ACNAME = rs[i][3];//账户名
            String AMT = rs[i][5];//金额
            String STAT = rs[i][9];//状态
            String ERR_MSG = rs[i][10];//错误信息
            // String BATCH_NO = rs[i][11];//批次号
            BankResPaymentInfo bankResPaymentInfo = new BankResPaymentInfo(ACNO, ACNAME, AMT);
            bankResPaymentInfo.setBankStatus(STAT);
            bankResPaymentInfo.setBankMsg(ERR_MSG);

            //4 等待提交 6 交易失败9 交易成功
            if ("9".equals(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUCCESS);
                //EBGBusinessUtils.setPaymentState(payInfo, PaymentState.SUCCESS, ResManager.loadKDString("交易成功", "QrySalPaymentImpl_2", "ebg-aqap-banks-jxnsb-cmp"), STAT, ResManager.loadKDString("交易成功", "QrySalPaymentImpl_2", "ebg-aqap-banks-jxnsb-cmp"));
            } else if ("6".equals(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.FAIL);
                //EBGBusinessUtils.setPaymentState(payInfo, PaymentState.FAIL, ResManager.loadKDString("交易失败", "QrySalPaymentImpl_3", "ebg-aqap-banks-jxnsb-cmp"), STAT, ERR_MSG);
            } else if ("4".equals(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUBMITED);
                // EBGBusinessUtils.setPaymentState(payInfo, PaymentState.SUBMITED, ResManager.loadKDString("银行处理中", "QrySalPaymentImpl_4", "ebg-aqap-banks-jxnsb-cmp"), STAT, ERR_MSG);
            } else {
                bankResPaymentInfo.setPaymentState(PaymentState.UNKNOWN);
                // EBGBusinessUtils.setPaymentState(payInfo, PaymentState.UNKNOWN, ResManager.loadKDString("交易结果未知", "QrySalPaymentImpl_0", "ebg-aqap-banks-jxnsb-cmp"), STAT, ERR_MSG);
            }
            bankResPaymentInfos.add(bankResPaymentInfo);
        }

        MatchPayStatusModel matchPayStatusModel = new MatchPayStatusModel();
        matchPayStatusModel.setMatchRule(MatchRule.MATCH_DEFAULT);
        matchPayStatusModel.setBankResPaymentInfoList(bankResPaymentInfos);
        List<PaymentInfo> allPaymentInfo = CommonPayStatusMatchUtil.getAllPaymentInfoByBankBatchNo(infos.get(0).getBankBatchSeqID());

        return new EBBankPayResponse(CommonPayStatusMatchUtil.HandlePayStatus(matchPayStatusModel,allPaymentInfo));

    }

    private PaymentInfo findPaymentInfo(PaymentInfo[] infos, String BATCH_NO, String ACNO, String ACNAME, String AMT) {

        String packageId = infos[0].getPackageId();
        for (PaymentInfo pay : infos) {
            if (packageId.equals(BATCH_NO)
                    && pay.getIncomeAccNo().equals(ACNO)
                    && pay.getIncomeAccName().equals(ACNAME)
                    && pay.getAmount().toPlainString().equals(AMT)
            ) {

                return pay;
            }
        }

        return null;
    }

    private String[][] parseRecord(String serial_record, int recordNum, int fieldNum) {
        String[] allrecord = StringUtils.split(serial_record, Constants.separator);
        log.info("###[代发工资结果明细查询] fieldNum =" + fieldNum + ", recordNum =" + recordNum + ", allrecord.length =" + allrecord.length);
        String[][] r2 = new String[recordNum][fieldNum];
        for (int i = 0; i < recordNum; i++) {
            for (int j = 0; j < fieldNum; j++) {
                r2[i][j] = allrecord[(i + 1) * fieldNum + j];//前42个全是字段名
            }
        }
        return r2;
    }

    @Override
    public String getDeveloper() {
        return null;
    }

    @Override
    public String getBizCode() {
        return null;
    }

    @Override
    public String getBizDesc() {
        return ResManager.loadKDString("代发工资 (300002交易)", "QrySalPaymentImpl_5", "ebg-aqap-banks-jxnsb-cmp");
    }

    @Override
    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg(super.recv(inputStream));
    }
}
