package kd.ebg.aqap.banks.jxnsb.cmp.services.utils;/**
 * @Description
 * @Author yChiu
 * @Date 2024年09月03日 13:30
 */

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import kd.bos.util.ConfigurationUpdateObserver;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;

public class CodeComm {

    public EBGLogger logger = EBGLogger.getInstance().getLogger(CodeComm.class);
    /**
     * 加密解密秘钥
     */
    public String key = null;
    public static String encodeLibPath = "/mservice/lib/biz/libhscrypt.so";
    public static String filePath = FileHandler.getPublicKeyPath();

    public interface CLibrary extends Library {

        // dll
        CLibrary INSTANCE = (CLibrary) Native.load(encodeLibPath, CLibrary.class);

        // 加密
        Integer GM_Encode_Comm(String sin, Integer msg_len, Pointer sout, String file_name, String key);

        // 解密
        Integer GM_Decode_Comm(String sin, Integer msg_len, Pointer sout, String file_name, String key);
    }

    public String encode(String sin) {

        logger.info("加密前请求报文==={}",sin);
        /** 这句话很重要 */
//        System.setProperty("jna.encoding", "GBK");
        ConfigurationUpdateObserver.registerInterest("jna.encoding", "GBK");
        ConfigurationUpdateObserver.notify(key);

        /** 接收-String */
        String str = null;
        try {
            /** 字符串长度 */
            int msg_len = sin.getBytes("GBK").length;
            //长度*4
            int sout_len = msg_len * 4;
            /** 定义-Pointer */
            Pointer sout = new Memory(sout_len);
            /** 加密 */
            logger.info("===开始调用加密方法==");
          /*  logger.info("so库绝对路径===" + encodeLibPath);
            logger.info("PUBlICKEy绝对路径===" + filePath);*/
            int n = CLibrary.INSTANCE.GM_Encode_Comm(sin, msg_len, sout, filePath, key);
            /** 接收-String */
            str = sout.getString(0);
            /** 手动释放内存 */
            long peer = Pointer.nativeValue(sout);
            Native.free(peer);//手动释放内存
            /** 避免Memory对象被GC时重复执行Nativ.free()方法 */
            Pointer.nativeValue(sout, 0);
            return str;
        } catch (Exception e) {
            logger.info("加密方法调用异常===" + e.getMessage());
        }
        return str;
    }

    /**
     * 解密
     */
    public String decode(String sin) {

        /** 这句话很重要 */
//        System.setProperty("jna.encoding", "GBK");
        ConfigurationUpdateObserver.registerInterest("jna.encoding", "GBK");
        ConfigurationUpdateObserver.notify(key);
        /** 接收-String */
        String str = null;
        try {
            /** 字符串长度 */
            int msg_len = sin.getBytes("GBK").length;
            // 长度
            int sout_len = msg_len;
            /** 定义-Pointer */
            Pointer sout = new Memory(sout_len);
            /** 解密 */
            Integer n = CLibrary.INSTANCE.GM_Decode_Comm(sin, msg_len, sout, this.filePath, this.key);
            str = sout.getString(0, "GBK");
            /** 手动释放内存 */
            long peer = Pointer.nativeValue(sout);
            Native.free(peer);//手动释放内存
            /** 避免Memory对象被GC时重复执行Nativ.free()方法 */
            Pointer.nativeValue(sout, 0);
            return str;
        } catch (Exception e) {
            logger.info("解密方法调用异常===" + e.getMessage());
        }

        logger.info("解密后返回报文==={}",str);
        return str;
    }

    public static void main(String[] args) {


        CodeComm comm = new CodeComm();
        String sin;
        sin = "<ap><head><tr_code>200108</tr_code><cms_corp_no>10032654</cms_corp_no><user_no>1</user_no><org_code></org_code><serial_no></serial_no><req_no>202110181443</req_no><tr_acdt>20201207</tr_acdt><tr_time>202400</tr_time><CorpCustID></CorpCustID><channel>5</channel><sign>0</sign><file_flag>0</file_flag><reserved></reserved></head><body><acno>106049000000122234</acno><cur_code>01</cur_code></body></ap>";
        System.out.println(comm.encode(sin));
        sin = "777CC5C30A8F14362A104258E52BC7C279D34C1A9D9E009CA54D3034397C3B7CAD4C87AE7874B58BE10F383AA506F547762E3E3237183DA48746A216DC6386BF82562E36BD5068BE9E56131B044D06622AA573ACDB42CAA2EDDD00B143B12E545CCCD84406D5B574B7A0F9717626FA53D8CAFC9E4842D59186A7321191D22D83E103A8ACDB54551D86D492A609D6821C6232C6889588B44CDE82A12417A6A3E8DF8E4EF8154DD3C0DB68A113420687623ABFFDB8DFBD9C7E49F728DB5252BD8504315D2D062E8702ED9ECD3DE869816363579A67A8059CF8F2A5FA39CC5AD9309A0E07B2D0EFBB99DDD274D70371E3916CC62E4387BFB31DDF9037851AC121A18A53B7016932C7B6AED591FC8B3F20D5409E30D56F457C589E6158F23CF6EC0C50A4DEDC42E190C098C527C3745A1F2CF40EB44FB9741B3775F86A0761F1386BC82C6984D00D123ED2264DE8E93E62763B45E2DC7CA523CCB6F257DA4B21CD4A8DAA8F777BDF9F68203C7336CDE65F8F712E0CF8759E6403A6429AC3148AF24F";
        System.out.println(comm.decode(sin));
    }




}
