package kd.ebg.aqap.banks.jxnsb.cmp.services.utils;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jxnsb.cmp.BankBusinessConfig;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

import java.io.File;

/**
 * @Description
 * @Author yChiu
 * @Date 2024年09月09日 14:28
 */
public class EncodeAnDecodeHandler {
    private static CodeComm codeComm;

    public static String encode(String responseMessage) {
        if (BankBusinessConfig.getTextNoEncode()) {
            return responseMessage;
        }
        checkFileAndInit();
        return codeComm.encode(responseMessage);
    }

    public static String decode(String requestMessage) {
        if (BankBusinessConfig.getTextNoEncode()) {
            return requestMessage;
        }
        checkFileAndInit();
        return codeComm.decode(requestMessage);
    }


    private synchronized static void checkFileAndInit() {
        // 检查动态库是否存在
        // 检查publicKey是否存在
        String encodeLibPath = "/mservice/lib/biz/libhscrypt.so";

        String  filePath = FileHandler.copyPublicFile();

        if (!new File(filePath).exists()) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString("PUBLICKEY文件不在保存的路径下。","EncodeAnDecodeHandler_1","ebg-aqap-banks-jxnsb-cmp"));
        }
        if (!new File(encodeLibPath).exists()) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString("so动态库文件不在保存的路径下。","EncodeAnDecodeHandler_2","ebg-aqap-banks-jxnsb-cmp"));
        }

        if (codeComm == null) {
            synchronized (EncodeAnDecodeHandler.class) {
                if (codeComm == null) {
                    codeComm = new CodeComm();
                }
            }
        }

    }



}
