/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.communication;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.HttpConnection;
import kd.ebg.egf.common.framework.communication.HttpsConnection;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.LoggerConnection;
import kd.ebg.egf.common.framework.communication.SSLConnection;
import kd.ebg.egf.common.framework.communication.TcpConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.sdk.annotation.SdkDeprecated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactory {
    private static Logger logger = LoggerFactory.getLogger(ConnectionFactory.class);
    private Map<String, String> protocolKey = new HashMap<String, String>(16);
    private Map<String, String> httpHeaders = new HashMap<String, String>(16);
    private boolean isLogging = true;
    private int SSLProxyType = 0;

    public static ConnectionFactory getInstance() {
        return new ConnectionFactory();
    }

    public static ConnectionFactory getInstanceAutoInit() {
        return new ConnectionFactory().autoInit();
    }

    @SdkDeprecated
    public ConnectionFactory setUri(String uri) {
        this.protocolKey.put("uri", uri);
        return this;
    }

    public ConnectionFactory setIp(String ip) {
        this.protocolKey.put("front_proxy_ip", ip);
        return this;
    }

    public ConnectionFactory setPort(String port) {
        this.protocolKey.put("front_proxy_port", port);
        return this;
    }

    public ConnectionFactory setProtocol(String protocol) {
        this.protocolKey.put("front_proxy_protocol", protocol);
        return this;
    }

    @SdkDeprecated
    public ConnectionFactory setHttpHeader(String key, String value) {
        this.httpHeaders.put(key, value);
        return this;
    }

    public ConnectionFactory setLogging(boolean isLogging) {
        this.isLogging = isLogging;
        return this;
    }

    @SdkDeprecated
    public ConnectionFactory addHeader(String key, String value) {
        this.httpHeaders.put(key, value);
        return this;
    }

    public ConnectionFactory addHeaders(Map<String, String> headers) {
        this.httpHeaders.putAll(headers);
        return this;
    }

    private ConnectionFactory autoInit() {
        IParameter parameter = EBContext.getContext().getParameter();
        String ip = parameter.getBankParameter("ip");
        String timeOut = parameter.getBankParameter("timeout");
        this.protocolKey.put("ip", ip);
        this.protocolKey.put("timeout", timeOut);
        this.httpHeaders.put("Connection", "close");
        return this;
    }

    public IConnection createExchangeConnection() {
        IParameter parameter = EBContext.getContext().getParameter();
        if (StringUtils.isEmpty((String)parameter.getBankParameter("exchangeProtocol"))) {
            this.protocolKey.put("protocol", "http");
        } else {
            this.protocolKey.put("protocol", parameter.getBankParameter("exchangeProtocol"));
        }
        if (StringUtils.isEmpty((String)parameter.getBankParameter("exchangePort"))) {
            this.protocolKey.put("port", "0");
        } else {
            this.protocolKey.put("port", parameter.getBankParameter("exchangePort"));
        }
        if (this.protocolKey.containsKey("front_proxy_ip")) {
            this.protocolKey.put("ip", this.protocolKey.get("front_proxy_ip"));
        }
        if (this.protocolKey.containsKey("front_proxy_port")) {
            this.protocolKey.put("port", this.protocolKey.get("front_proxy_port"));
        }
        if (this.protocolKey.containsKey("front_proxy_protocol")) {
            this.protocolKey.put("protocol", this.protocolKey.get("front_proxy_protocol"));
        }
        if (!this.protocolKey.containsKey("uri")) {
            this.protocolKey.put("uri", parameter.getBankParameter("exchangeUri"));
        } else if (!StringUtils.isEmpty((String)parameter.getBankParameter("exchangeUri"))) {
            this.protocolKey.put("uri", parameter.getBankParameter("exchangeUri"));
        }
        return this.createConnection();
    }

    public IConnection createFrontProxyConnection() {
        IParameter parameter = EBContext.getContext().getParameter();
        if (StringUtils.isEmpty((String)parameter.getBankParameter("frontProxyProtocol"))) {
            this.protocolKey.put("protocol", "http");
        } else {
            this.protocolKey.put("protocol", parameter.getBankParameter("frontProxyProtocol"));
        }
        if (StringUtils.isEmpty((String)parameter.getBankParameter("frontProxy_Port"))) {
            this.protocolKey.put("port", parameter.getBankParameter("frontProxy_port"));
        } else {
            this.protocolKey.put("port", parameter.getBankParameter("frontProxy_Port"));
        }
        this.protocolKey.put("uri", "");
        return this.createConnection();
    }

    public IConnection createFrontProxyExtConnection() {
        IParameter parameter = EBContext.getContext().getParameter();
        if (StringUtils.isEmpty((String)parameter.getBankParameter("frontProxyProtocol"))) {
            this.protocolKey.put("protocol", "http");
        } else {
            this.protocolKey.put("protocol", parameter.getBankParameter("frontProxyProtocol"));
        }
        if (StringUtils.isEmpty((String)parameter.getBankParameter("frontProxy_Port"))) {
            this.protocolKey.put("port", parameter.getBankParameter("frontProxy_port"));
        } else {
            this.protocolKey.put("port", parameter.getBankParameter("frontProxy_Port"));
        }
        this.protocolKey.put("ip", parameter.getBankParameter("front_proxy_ip"));
        this.protocolKey.put("uri", "");
        return this.createConnection();
    }

    public IConnection createFileConnection() {
        IParameter parameter = EBContext.getContext().getParameter();
        if (StringUtils.isEmpty((String)parameter.getBankParameter("fileProtocol"))) {
            this.protocolKey.put("protocol", "http");
        } else {
            this.protocolKey.put("protocol", parameter.getBankParameter("fileProtocol"));
        }
        if (StringUtils.isEmpty((String)parameter.getBankParameter("filePort"))) {
            this.protocolKey.put("port", "0");
        } else {
            this.protocolKey.put("port", parameter.getBankParameter("filePort"));
        }
        this.protocolKey.put("uri", "");
        return this.createConnection();
    }

    public IConnection createUserConfigConnection(String protocol, String ip, int port, int timeout) {
        return this.createDirectConnection(protocol, ip, port, timeout);
    }

    public IConnection createValidateConnection() {
        IParameter parameter = EBContext.getContext().getParameter();
        this.protocolKey.put("protocol", parameter.getBankParameter("validateProtocol"));
        this.protocolKey.put("port", parameter.getBankParameter("validatePort"));
        if (!this.protocolKey.containsKey("uri")) {
            this.protocolKey.put("uri", parameter.getBankParameter("validateUri"));
        }
        return this.createConnection();
    }

    public IConnection createAppointConnection(String protocol, String ip, String port, String timeOut) {
        this.protocolKey.put("protocol", protocol);
        this.protocolKey.put("ip", ip);
        this.protocolKey.put("port", port);
        this.protocolKey.put("timeout", timeOut);
        return this.createConnection();
    }

    public IConnection createSignConnection() {
        IParameter parameter = EBContext.getContext().getParameter();
        this.protocolKey.put("protocol", parameter.getBankParameter("signProtocol"));
        logger.info("\u4f20\u5165\u53c2\u6570\u540d\u79f0{},\u503c\u4e3a{}", (Object)"protocol", (Object)parameter.getBankParameter("signProtocol"));
        String port = parameter.getBankParameter("signPort");
        if (port == null || port.trim().isEmpty()) {
            port = "449";
        }
        this.protocolKey.put("port", port);
        logger.info("\u4f20\u5165\u53c2\u6570\u540d\u79f0{},\u503c\u4e3a{}", (Object)"port", (Object)port);
        if (!this.protocolKey.containsKey("uri")) {
            this.protocolKey.put("uri", parameter.getBankParameter("signUri"));
            logger.info("\u4f20\u5165\u53c2\u6570\u540d\u79f0{},\u503c\u4e3a{}", (Object)"uri", (Object)parameter.getBankParameter("signUri"));
        }
        return this.createConnection();
    }

    private IConnection createConnection() {
        IConnection connection = null;
        String protocol = this.protocolKey.get("protocol");
        String ip = this.protocolKey.get("ip");
        String s = this.protocolKey.get("port");
        if (StringUtils.isEmpty((String)s)) {
            s = this.protocolKey.get("front_proxy_port");
        }
        if (StringUtils.isEmpty((String)s)) {
            s = this.protocolKey.get("frontProxy_port");
        }
        int port = Integer.parseInt(s);
        int timeout = 3;
        if (!StringUtils.isEmpty((String)this.protocolKey.get("timeout"))) {
            timeout = Integer.parseInt(this.protocolKey.get("timeout"));
        }
        connection = this.createDirectConnection(protocol, ip, port, timeout);
        String charset = IOUtils.getCharsetName();
        if (this.isSSLProxyConnection()) {
            return new SSLConnection(connection, protocol, ip, port, timeout, this.protocolKey, this.httpHeaders, charset, EBContext.getContext());
        }
        if (this.isLogging) {
            return new LoggerConnection(connection);
        }
        return connection;
    }

    private boolean isSSLProxyConnection() {
        return EBContext.getContext().getProxyType() != null;
    }

    private IConnection createDirectConnection(String protocol, String ip, int port, int timeout) {
        IConnection connection = null;
        if ("HTTP".equalsIgnoreCase(protocol)) {
            String uri = this.protocolKey.get("uri");
            String method = this.httpHeaders.get("Request Method");
            if (StrUtil.isBlank(method)) {
                method = "POST";
            } else {
                this.httpHeaders.remove("Request Method");
            }
            connection = new HttpConnection(ip, port, uri, this.httpHeaders, timeout, method);
        } else if ("TCP".equalsIgnoreCase(protocol)) {
            connection = new TcpConnection(ip, port, timeout);
        } else if ("HTTPS".equalsIgnoreCase(protocol)) {
            String uri = this.protocolKey.get("uri");
            connection = new HttpsConnection(ip, port, uri, this.httpHeaders, timeout);
        } else {
            throw EBExceiptionUtil.connectionException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u534f\u8bae\u7c7b\u578b %s", (String)"ConnectionFactory_0", (String)"ebg-egf-common", (Object[])new Object[0]), protocol));
        }
        return connection;
    }
}

