/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.security.factory;

import com.alibaba.fastjson.JSONObject;
import kd.ebg.egf.common.entity.service.EBBaseRequest;
import kd.ebg.egf.common.framework.security.EBSecuritySuit;
import kd.ebg.egf.common.framework.security.api.ICustomerInfoProvider;
import kd.ebg.egf.common.framework.security.api.IEBSecurityProvider;
import kd.ebg.egf.common.framework.security.atomic.IEncrypt;
import kd.ebg.egf.common.framework.security.atomic.ISignature;
import kd.ebg.egf.common.model.tenant.CustomerInfo;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.bouncycastle.util.encoders.Base64;

public class DefaultEBSecurityProvider
implements IEBSecurityProvider {
    private ICustomerInfoProvider customerInfoProvider;
    private byte[] ebPrivateKey;
    private byte[] ebPublicKey;
    private ISignature signature;

    public DefaultEBSecurityProvider(ICustomerInfoProvider provider, byte[] ebPrivateKey, byte[] ebPublicKey) {
        this.customerInfoProvider = provider;
        this.ebPrivateKey = ebPrivateKey;
        this.ebPublicKey = ebPublicKey;
    }

    public ICustomerInfoProvider getCustomerInfoProvider() {
        return this.customerInfoProvider;
    }

    public void setCustomerInfoProvider(ICustomerInfoProvider customerInfoProvider) {
        this.customerInfoProvider = customerInfoProvider;
    }

    public byte[] getEbPrivateKey() {
        return this.ebPrivateKey;
    }

    public void setEbPrivateKey(byte[] ebPrivateKey) {
        this.ebPrivateKey = ebPrivateKey;
    }

    public ISignature getSignature() {
        return this.signature;
    }

    public void setSignature(ISignature signature) {
        this.signature = signature;
    }

    @Override
    public IEncrypt getEncrypt(EBBaseRequest request) {
        EBSecuritySuit suit = new EBSecuritySuit(request.getEncryptAlgorithm(), Base64.decode((String)request.getEncryptKey()));
        return suit;
    }

    @Override
    public ISignature getSignature(EBBaseRequest request) {
        JSONObject jsonObject;
        String source;
        if (!StringUtils.isEmpty(request.getExtData()) && "manage".equalsIgnoreCase(source = (jsonObject = JSONObject.parseObject((String)request.getExtData())).getString("from"))) {
            return new EBSecuritySuit(this.ebPublicKey, this.ebPrivateKey, request.getSignAlgorithm());
        }
        if (null == this.signature) {
            CustomerInfo info = this.customerInfoProvider.getCustomerInfoByID(request.getCustomerID());
            this.signature = new EBSecuritySuit(info.getPublicKey(), this.ebPrivateKey, request.getSignAlgorithm());
        }
        return this.signature;
    }

    @Override
    public ISignature getResponseSignature(EBBaseRequest request) {
        EBSecuritySuit signature = new EBSecuritySuit(this.ebPublicKey, this.ebPrivateKey, request.getSignAlgorithm());
        return signature;
    }
}

