/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.security.manage;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.framework.security.manage.ICipherSecurity;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.BASE64Util;
import kd.sdk.annotation.SdkDeprecated;

public class AbstractCipherSecurity
implements ICipherSecurity {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(AbstractCipherSecurity.class);
    private int version = 1;
    public static final int DEFAULT_LENGTH = 128;
    public static final String ALGORITHM_AES = "AES";
    static final String DEFAULT_CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    private Map<Integer, CipherInfo> keyMap = new HashMap<Integer, CipherInfo>(16);
    boolean isJDKSupportAES256 = this.testAES256();

    protected boolean updateCipherPD() {
        StringBuilder sb = new StringBuilder();
        sb.append(RequestContext.get().getTenantId());
        sb.append(ID.genStringId());
        String cipher = sb.toString();
        String rootPD = "";
        return true;
    }

    public void updateKeyMap() {
        this.resetVersion();
        QFilter filter = QFilter.of((String)"algo=? and group=? and enable=?", (Object[])new Object[]{ALGORITHM_AES, "USER", "1"});
        Map map = BusinessDataServiceHelper.loadFromCache((String)"aqap_cipher", (QFilter[])filter.toArray());
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                int version = dynamicObject.getInt("version");
                String key = dynamicObject.getString("key");
                key = BASE64Util.decodeBase64(key);
                String group = dynamicObject.getString("group");
                String algo = dynamicObject.getString("algo");
                int length = dynamicObject.getInt("length");
                SecretKeySpec secretKey = this.createSecretKey(key, length);
                if (length == 256) {
                    if (this.isSupportAES256()) {
                        this.setVersion(version);
                    }
                } else {
                    this.setVersion(version);
                }
                this.addKeyMap(key, version, algo, group, length, secretKey);
            }
        }
    }

    private void addKeyMap(String key, int version, String algo, String group, int length, SecretKeySpec secretKey) {
        CipherInfo cipherInfo = new CipherInfo();
        cipherInfo.setCipherData(key);
        cipherInfo.setCipherVersion(version);
        cipherInfo.setAlgo(algo);
        cipherInfo.setGroup(group);
        cipherInfo.setLength(length);
        cipherInfo.setSecretKey(secretKey);
        this.keyMap.put(version, cipherInfo);
    }

    private boolean testAES256() {
        byte[] content = "test AES 256".getBytes();
        String pass = "test_pass";
        try {
            KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM_AES);
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(pass.getBytes());
            kg.init(256, secureRandom);
            SecretKey secretKey = kg.generateKey();
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getEncoded(), ALGORITHM_AES);
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(1, secretKeySpec);
            byte[] iv = cipher.getIV();
            assert (iv.length == 12);
            byte[] encryptData = cipher.doFinal(content);
            return encryptData.length == content.length + 16;
        }
        catch (Throwable e) {
            logger.monitorError("ebg AbstractCipherSecurity test AES 256 error, jdk not support AES 256", e);
            return false;
        }
    }

    public boolean isSupportAES256() {
        String value = "128";
        if (this.isJDKSupportAES256) {
            String selectFields = "attr_value";
            QFilter filter = QFilter.of((String)"object_id=? and attr_key=?", (Object[])new Object[]{"common_business", "AES_KEY_SIZE"});
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"aqap_object_properties", (String)selectFields, (QFilter[])filter.toArray());
            value = dynamicObject != null ? dynamicObject.getString("attr_value") : "256";
        }
        return "256".equals(value);
    }

    private SecretKeySpec createSecretKey(String encryptPass, int length) {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM_AES);
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(encryptPass.getBytes());
            kg.init(length, secureRandom);
            SecretKey secretKey = kg.generateKey();
            return new SecretKeySpec(secretKey.getEncoded(), ALGORITHM_AES);
        }
        catch (NoSuchAlgorithmException e) {
            logger.monitorError("ebg AbstractCipherSecurity createSecretKey error, NoSuchAlgorithmException", e);
            return null;
        }
    }

    private SecretKeySpec getSecretKey(int version) {
        CipherInfo cipherInfo = this.keyMap.get(version);
        if (cipherInfo != null) {
            return cipherInfo.getSecretKey();
        }
        return null;
    }

    public String getAESCipherPD() {
        int version = this.getVersion();
        return this.getAESCipherPD(version);
    }

    public String getAESCipherPD(int version) {
        CipherInfo cipherInfo = this.keyMap.get(version);
        return cipherInfo.getCipherData();
    }

    @SdkDeprecated
    public CipherInfo getCipherInfo() {
        return this.getCipherInfo(this.getVersion());
    }

    @SdkDeprecated
    public CipherInfo getCipherInfo(int version) {
        return this.keyMap.get(version);
    }

    @Override
    public String encrypt(String PlainData) {
        return "";
    }

    @Override
    public String decrypt(String cipherData) {
        return "";
    }

    @Override
    public String decrypt(String cipherData, int version) {
        return "";
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        if (version > this.version) {
            this.version = version;
        }
    }

    private void resetVersion() {
        this.version = 1;
    }

    public int getCipherLength() {
        CipherInfo cipherInfo = this.keyMap.get(this.getVersion());
        if (cipherInfo != null) {
            return cipherInfo.getLength();
        }
        return 128;
    }
}

