/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.task;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frontProxy.ParamUtil;
import kd.ebg.egf.common.framework.task.TaskStatusEnum;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.zookeeper.node.SingleNodeIDGetter;

public class BizTaskTool {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BizTaskTool.class);
    protected static final String BIZ_TASK_ENTITY = "aqap_biz_task";
    public static final String BIZ_TASK_SWITCH = "biz_task_switch";
    private static BizTaskTool instance = new BizTaskTool();

    public static BizTaskTool getInstance() {
        return instance;
    }

    public String createBizTask(EBContext context) {
        String taskId = "";
        if (this.isOpen() && context != null) {
            String bankVersionID = context.getBankVersionID();
            String bankLoginID = context.getBankLoginID();
            String bizNo = context.getBizSeqID();
            String loggerNo = context.getLogger_batch_no();
            String bankBatchSeqID = context.getLogger_detail_no();
            String loggerBankNo = context.getLogger_bank_no();
            String accNO = context.getBankAcnt().getAccNo();
            String bizType = context.getBizName();
            long pk_bankVersion = BizTaskTool.getBankVersionPK(bankVersionID);
            long pk_bizType = BizTaskTool.getBizTypePK(bizType);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)BIZ_TASK_ENTITY);
            dynamicObject.set("number", (Object)String.valueOf(ID.genLongId()));
            dynamicObject.set("enable", (Object)"1");
            dynamicObject.set("bank_version", (Object)bankVersionID);
            dynamicObject.set("biz_type", (Object)bizType);
            dynamicObject.set("bd_bank_version", (Object)pk_bankVersion);
            dynamicObject.set("bd_biz_type", (Object)pk_bizType);
            dynamicObject.set("bank_login", (Object)bankLoginID);
            dynamicObject.set("biz_no", (Object)bizNo);
            dynamicObject.set("logger_no", (Object)loggerNo);
            dynamicObject.set("bank_batch_no", (Object)bankBatchSeqID);
            dynamicObject.set("acc_no", (Object)accNO);
            dynamicObject.set("status_no", (Object)TaskStatusEnum.TASK_WAIT.getId());
            dynamicObject.set("is_skip", (Object)"0");
            dynamicObject.set("sub_biz_type", (Object)context.getSubBizName());
            dynamicObject.set("request_seq", (Object)context.getRequestSeqID());
            dynamicObject.set("ebg_node", (Object)SingleNodeIDGetter.getInstance().nodeID());
            dynamicObject.set("logger_bank_no", (Object)loggerBankNo);
            Object[] results = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            if (results != null) {
                DynamicObject saveDynamicObject = (DynamicObject)results[0];
                taskId = String.valueOf(saveDynamicObject.getLong("id"));
            }
        }
        return taskId;
    }

    private static long getBankVersionPK(String bankVersionID) {
        long id = 0L;
        QFilter filter = QFilter.of((String)"number=?", (Object[])new Object[]{bankVersionID});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"aqap_bank", (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            id = dynamicObject.getLong("id");
        }
        return id;
    }

    private static long getBizTypePK(String bizType) {
        long id = 0L;
        QFilter filter = QFilter.of((String)"number=?", (Object[])new Object[]{bizType});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"aqap_business_type", (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            id = dynamicObject.getLong("id");
        }
        return id;
    }

    public DynamicObject setTaskProcessing(String taskID) {
        if (this.isOpen() && StringUtils.isNotEmpty(taskID)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)taskID, (String)BIZ_TASK_ENTITY);
            if (dynamicObject != null) {
                dynamicObject.set("wait_time", (Object)this.getDeltaSecondsByNow(dynamicObject.getString("createtime")));
                dynamicObject.set("status_no", (Object)TaskStatusEnum.TASK_PROCESSING.getId());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
            return dynamicObject;
        }
        return null;
    }

    public void setTaskFinish(String taskID) {
        DynamicObject dynamicObject;
        if (this.isOpen() && StringUtils.isNotEmpty(taskID) && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)taskID, (String)BIZ_TASK_ENTITY)) != null) {
            dynamicObject.set("full_time", (Object)this.getDeltaSecondsByNow(dynamicObject.getString("createtime")));
            dynamicObject.set("process_time", (Object)this.getDeltaSecondsByNow(dynamicObject.getString("modifytime")));
            dynamicObject.set("status_no", (Object)TaskStatusEnum.TASK_FINISH.getId());
            dynamicObject.set("enable", (Object)"0");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
        this.clearHistoryTask();
    }

    private void clearHistoryTask() {
        LocalDateTime queryDateTime = LocalDateTime.now().minusDays(7L);
        QFilter filter = QFilter.of((String)"createtime<?", (Object[])new Object[]{queryDateTime});
        if (QueryServiceHelper.exists((String)BIZ_TASK_ENTITY, (QFilter[])filter.toArray())) {
            DeleteServiceHelper.delete((String)BIZ_TASK_ENTITY, (QFilter[])filter.toArray());
        }
    }

    private long getDeltaSecondsByNow(String timeString) {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime time2 = DTFactoryUtil.parseDateTime(timeString);
        long stamp1 = now.toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
        long stamp2 = time2.toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
        return stamp1 - stamp2;
    }

    public void checkFallBack(EBContext context) {
    }

    private boolean isOpen() {
        boolean result = Boolean.parseBoolean(ParamUtil.getObjectPropValue(BIZ_TASK_SWITCH));
        return result;
    }
}

