/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.acnt;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.bank.MappingTable;
import kd.ebg.egf.common.utils.string.StringUtils;

public class MappingAcctRepository {
    private static final String ENTITY_NAME = "aqap_mapping_acct";
    private static final String SELECT_PROPERTIES = "ID,parentacct,childacct,currency,swiftcode,reserve";
    private static MappingAcctRepository instance = new MappingAcctRepository();

    public static MappingAcctRepository getInstance() {
        return instance;
    }

    public long getCountsByParentAcct(String parent) {
        QFilter qFilter = QFilter.of((String)"parentacct = ?", (Object[])new Object[]{parent});
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)ENTITY_NAME, (String)"id", (QFilter[])qFilter.toArray(), (String)"");){
            long l = dataSet.count("id", Boolean.FALSE.booleanValue());
            return l;
        }
    }

    public BankAcnt loadProxy(BankAcnt acnt) {
        if (acnt == null) {
            return null;
        }
        String accNo = acnt.getAccNo();
        MappingTable table = this.loadByAcc(accNo);
        if (table.getChildAccts().isEmpty()) {
            return acnt;
        }
        ArrayList<BankAcnt.Proxy> proxyList = new ArrayList<BankAcnt.Proxy>(2);
        for (MappingTable.TableStruct childAcct : table.getChildAccts()) {
            BankAcnt.Proxy proxy = new BankAcnt.Proxy();
            proxy.setInquiryaccount(childAcct.getAccNo());
            proxy.setPayaccount(childAcct.getReserve());
            proxy.setCurrency(childAcct.getCurrency());
            proxy.setSwiftCode(childAcct.getSwiftCode());
            proxyList.add(proxy);
        }
        acnt.setProxy(proxyList);
        return acnt;
    }

    private DynamicObject packEntity(DynamicObject dynamicObject, MappingTable.TableStruct table, String parentAcct) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        } else {
            this.setDynamicParamater(dynamicObject, "id", Long.parseLong(table.getId()));
        }
        this.setDynamicParamater(dynamicObject, "parentacct", parentAcct);
        this.setDynamicParamater(dynamicObject, "childacct", table.getAccNo());
        this.setDynamicParamater(dynamicObject, "currency", table.getCurrency());
        this.setDynamicParamater(dynamicObject, "swiftcode", table.getSwiftCode());
        this.setDynamicParamater(dynamicObject, "reserve", table.getReserve());
        return dynamicObject;
    }

    private MappingTable.TableStruct unpackEntity(DynamicObject dynamicObject) {
        String childacct = dynamicObject.getString("childacct");
        String currency = dynamicObject.getString("currency");
        String swiftcode = dynamicObject.getString("swiftcode");
        String reserve = dynamicObject.getString("reserve");
        MappingTable.TableStruct tableStruct = new MappingTable.TableStruct();
        tableStruct.setAccNo(childacct);
        tableStruct.setCurrency(currency);
        tableStruct.setSwiftCode(swiftcode);
        tableStruct.setReserve(reserve);
        return tableStruct;
    }

    public MappingTable loadByAccAndCurrency(String acc, String cur) {
        QFilter qFilter = QFilter.of((String)"parentacct = ? and currency = ?", (Object[])new Object[]{acc, cur});
        return this.load(acc, qFilter);
    }

    public MappingTable loadByAcc(String acc) {
        QFilter qFilter = QFilter.of((String)"parentacct = ?", (Object[])new Object[]{acc});
        return this.load(acc, qFilter);
    }

    private MappingTable load(String acc, QFilter qFilter) {
        Map maps = BusinessDataServiceHelper.loadFromCache((String)ENTITY_NAME, (String)SELECT_PROPERTIES, (QFilter[])qFilter.toArray());
        MappingTable mappingTable = new MappingTable();
        ArrayList<MappingTable.TableStruct> childAccts = new ArrayList<MappingTable.TableStruct>(1);
        mappingTable.setChildAccts(childAccts);
        mappingTable.setParentAcct(acc);
        if (maps != null && maps.size() > 0) {
            for (Map.Entry entry : maps.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                childAccts.add(this.unpackEntity(dynamicObject));
            }
        }
        return mappingTable;
    }

    public void save(MappingTable mt) {
        if (mt.getChildAccts() == null || mt.getChildAccts().isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(4);
        String parentAcct = mt.getParentAcct();
        long count = this.getCountsByParentAcct(parentAcct);
        if (count > 0L) {
            this.delete(parentAcct);
        }
        for (MappingTable.TableStruct ts : mt.getChildAccts()) {
            dynamicObjects.add(this.packEntity(null, ts, parentAcct));
        }
        DynamicObject[] dynamicObjArray = dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]);
        SaveServiceHelper.save((DynamicObject[])dynamicObjArray);
    }

    public int delete(String parentAcct) {
        QFilter qFilter = QFilter.of((String)"parentacct = ? ", (Object[])new Object[]{parentAcct});
        return DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])qFilter.toArray());
    }

    public void setDynamicParamater(DynamicObject dynamicObject, String key, Object value) {
        if (value instanceof String) {
            if (StringUtils.isEmpty((String)value)) {
                value = " ";
            }
        } else if (value instanceof Integer && value == null) {
            value = 0;
        }
        dynamicObject.set(key, value);
    }
}

