/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.bank.config;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.constant.CertType;
import kd.ebg.egf.common.model.proxy.BankLoginProxyConfig;
import kd.ebg.egf.common.utils.db.QueryCacheUtil;
import org.apache.commons.codec.binary.Base64;

public class BankLoginProxyConfigRepository {
    private String entity = "aqap_proxy_config";
    private String properties = "id,proxy_host,proxy_port,proxy_type,custom_id,rsa_sign_algo,public_key_tag,public_key_alias,public_key_secret,private_key_tag,private_key_alias,private_key_secret";
    private static BankLoginProxyConfigRepository instance = new BankLoginProxyConfigRepository();

    public static BankLoginProxyConfigRepository getInstance() {
        return instance;
    }

    public BankLoginProxyConfig findById(String customID) {
        BankLoginProxyConfig bankLoginProxyConfig = null;
        QFilter filter = QFilter.of((String)"custom_id=?", (Object[])new Object[]{customID});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)this.entity, (String)this.properties, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            DynamicObject[] dynamicObjects;
            bankLoginProxyConfig = new BankLoginProxyConfig();
            String privateValue = "";
            String publicValue = "";
            for (DynamicObject certObject : dynamicObjects = QueryCacheUtil.getDynamicObjects("aqap_bd_cert", "id, bank_config_id, bank_config_value_tag", new QFilter[]{QFilter.of((String)"custom_id=? and type=?", (Object[])new Object[]{customID, CertType.PROXY_CER.getType()})})) {
                int version = this.getCipherVersion(certObject.getString("bank_config_value_tag"));
                if ("private_key".equalsIgnoreCase(certObject.getString("bank_config_id"))) {
                    privateValue = certObject.getString("bank_config_value_tag");
                    bankLoginProxyConfig.setPrivateCertID(certObject.getString("id"));
                    bankLoginProxyConfig.setPrivateCertCipherVer(version);
                    continue;
                }
                if (!"public_key".equalsIgnoreCase(certObject.getString("bank_config_id"))) continue;
                publicValue = certObject.getString("bank_config_value_tag");
                bankLoginProxyConfig.setPublicCertID(certObject.getString("id"));
                bankLoginProxyConfig.setPublicCertCipherVer(version);
            }
            bankLoginProxyConfig.setCustomerNo(customID);
            bankLoginProxyConfig.setProxyID(String.valueOf(dynamicObject.getLong("id")));
            bankLoginProxyConfig.setPrivateKey(this.decode(privateValue));
            bankLoginProxyConfig.setPrivateKeyAlias(dynamicObject.getString("private_key_alias"));
            bankLoginProxyConfig.setPrivateKeySecret(dynamicObject.getString("private_key_secret"));
            bankLoginProxyConfig.setPublicKey(this.decode(publicValue));
            bankLoginProxyConfig.setPublicKeyAlias(dynamicObject.getString("public_key_alias"));
            bankLoginProxyConfig.setPublicKeySecret(dynamicObject.getString("public_key_secret"));
            bankLoginProxyConfig.setProxyHost(dynamicObject.getString("proxy_host"));
            bankLoginProxyConfig.setProxyPort(dynamicObject.getString("proxy_port"));
            bankLoginProxyConfig.setProxyType(String.valueOf(2));
            bankLoginProxyConfig.setRsaSignAlgo(dynamicObject.getString("rsa_sign_algo"));
        }
        return bankLoginProxyConfig;
    }

    public String encode(byte[] key) {
        String base64String = java.util.Base64.getEncoder().encodeToString(key);
        return base64String;
    }

    public byte[] decode(String Base64String) {
        byte[] key;
        if (this.getCipherVersion(Base64String) == 0) {
            key = java.util.Base64.getDecoder().decode(Base64String);
        } else {
            String cipherData = Base64String.split("\\|")[0];
            key = Base64.decodeBase64((String)cipherData);
        }
        return key;
    }

    private int getCipherVersion(String certStr) {
        int version = 0;
        try {
            String[] str = certStr.split("\\|");
            if (str.length == 2) {
                version = Integer.parseInt(str[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }
}

