/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.bank.login;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;
import kd.ebg.egf.common.model.bank.login.BankLoginConfigKey;

public class BankLoginConfigRepository {
    public String ENTITY_KEY = "aqap_bank_login_config";
    private static BankLoginConfigRepository instance = new BankLoginConfigRepository();

    public static BankLoginConfigRepository getInstance() {
        return instance;
    }

    public List<BankLoginConfig> findAllByBankVersionIdAndCustomID(String bankVersionId, String customerId) {
        return new ArrayList<BankLoginConfig>(1);
    }

    public List<BankLoginConfig> findByBankVersionIdAndCustomIDAndBankLoginId(String bankVersionId, String customId, String bankLoginId) {
        return new ArrayList<BankLoginConfig>(1);
    }

    public void delete(String bankLogin, String configType) {
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)bankLogin), new QFilter("config_type", "=", (Object)configType)};
        DeleteServiceHelper.delete((String)this.ENTITY_KEY, (QFilter[])qFilters);
    }

    public OperationResult save(String bankConfigId, String bankConfigName, boolean isNullable, boolean isReadOnly, String bankLogin, String bankVersion, String value, String customID, String configType) {
        return this.save(bankConfigId, bankConfigName, isNullable, isReadOnly, bankLogin, bankVersion, value, customID, configType, " ");
    }

    public OperationResult save(String bankConfigId, String bankConfigName, boolean isNullable, boolean isReadOnly, String bankLogin, String bankVersion, String value, String customID, String configType, String inputType) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)this.ENTITY_KEY);
        dataEntity.set("number", (Object)bankLogin);
        dataEntity.set("bank_config_id", (Object)bankConfigId);
        dataEntity.set("name", (Object)bankConfigName);
        dataEntity.set("bank_version_id", (Object)bankVersion);
        dataEntity.set("bank_config_value", (Object)value);
        dataEntity.set("nullable", (Object)isNullable);
        dataEntity.set("readonly", (Object)isReadOnly);
        dataEntity.set("custom_id", (Object)customID);
        dataEntity.set("config_type", (Object)configType);
        dataEntity.set("input_type", (Object)inputType);
        OperationResult result = SaveServiceHelper.saveOperate((String)this.ENTITY_KEY, (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
        return result;
    }

    public int deleteByCustomID(String customId) {
        return 0;
    }

    public BankLoginConfig findById(BankLoginConfigKey key) {
        BankLoginConfig bankLoginConfig = null;
        String entityName = "aqap_bank_login_config";
        String selectFields = "id,name,bank_config_value,nullable,readonly,input_type";
        BusinessDataServiceHelper.newDynamicObject((String)entityName);
        QFilter filter = QFilter.of((String)"bank_version_id=? and number=? and bank_config_id=?", (Object[])new Object[]{key.getBankVersionId(), key.getBankLoginId(), key.getBankConfigId()});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)selectFields, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            bankLoginConfig = new BankLoginConfig();
            bankLoginConfig.setId(dynamicObject.getString("id"));
            bankLoginConfig.setBankConfigName(dynamicObject.getString("name"));
            bankLoginConfig.setBankConfigValue(dynamicObject.getString("bank_config_value"));
            bankLoginConfig.setKey(key);
            bankLoginConfig.setReadOnly(Boolean.parseBoolean(dynamicObject.getString("readonly")));
            bankLoginConfig.setNullable(Boolean.parseBoolean(dynamicObject.getString("nullable")));
            bankLoginConfig.setInputType(dynamicObject.getString("input_type"));
        }
        return bankLoginConfig;
    }

    public void save(BankLoginConfig bankLoginConfig) {
    }

    public OperationResult saveOperate(List<DynamicObject> dynamicObjects) {
        OperationResult result = SaveServiceHelper.saveOperate((String)this.ENTITY_KEY, (DynamicObject[])dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]), (OperateOption)OperateOption.create());
        return result;
    }

    public void save(List<DynamicObject> dynamicObjects) {
        BusinessDataWriter.save((IDataEntityType)dynamicObjects.get(0).getDataEntityType(), (Object[])dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]));
    }

    public DynamicObjectCollection findByBankLoginIDAndCustomID(String bankLoginID, String customID) {
        String selectFields = "number, name, bank_config_id, bank_config_value, nullable, readonly";
        QFilter filter = QFilter.of((String)"number=? and custom_id=?", (Object[])new Object[]{bankLoginID, customID});
        DynamicObjectCollection collections = QueryServiceHelper.query((String)this.ENTITY_KEY, (String)selectFields, (QFilter[])filter.toArray());
        return collections;
    }

    public DynamicObject findByBankLoginIDAndCustomIDAndBankConfigID(String bankLoginID, String customID, String bankConfigID) {
        String selectFields = "number, name, bank_config_id, bank_config_value, nullable, readonly";
        QFilter filter = QFilter.of((String)"number=? and custom_id=? and bank_config_id=?", (Object[])new Object[]{bankLoginID, customID, bankConfigID});
        return QueryServiceHelper.queryOne((String)this.ENTITY_KEY, (String)selectFields, (QFilter[])filter.toArray());
    }

    public DynamicObject loadByBankLoginIDAndCustomIDAndBankConfigID(String bankLoginID, String customID, String bankConfigID) {
        String selectFields = "number, name, bank_config_id, bank_config_value, nullable, readonly";
        QFilter filter = QFilter.of((String)"number=? and custom_id=? and bank_config_id=?", (Object[])new Object[]{bankLoginID, customID, bankConfigID});
        return BusinessDataServiceHelper.loadSingle((String)this.ENTITY_KEY, (String)selectFields, (QFilter[])filter.toArray());
    }

    public int deleteByBankLoginIDAndCustomID(String bankLoginID, String customID) {
        return DeleteServiceHelper.delete((String)this.ENTITY_KEY, (QFilter[])QFilter.of((String)"number=? and custom_id=?", (Object[])new Object[]{bankLoginID, customID}).toArray());
    }

    public int deleteByBankLoginIDAndCustomIDAndBankConfigID(String bankLoginID, String customID, String bankConfigID) {
        return DeleteServiceHelper.delete((String)this.ENTITY_KEY, (QFilter[])QFilter.of((String)"number=? and custom_id=? and bank_config_id=?", (Object[])new Object[]{bankLoginID, customID, bankConfigID}).toArray());
    }

    public void update(String accountID, String newAccountID) {
        DynamicObject[] dynamicObject;
        for (DynamicObject dynamicObject1 : dynamicObject = this.findOneById(accountID)) {
            dynamicObject1.set("custom_id", (Object)newAccountID);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObject);
    }

    public DynamicObject[] findOneById(String customID) {
        String selectProperties = "id, custom_id";
        QFilter filter = QFilter.of((String)"custom_id=?", (Object[])new Object[]{customID});
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)this.ENTITY_KEY, (String)selectProperties, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    public List<BankLoginConfig> getBankLoginConfigByBankLogin(String bankLoginID, String customID) {
        ArrayList<BankLoginConfig> bankLoginConfigList = new ArrayList<BankLoginConfig>(16);
        QFilter filter = QFilter.of((String)"number=? and custom_id=?", (Object[])new Object[]{bankLoginID, customID});
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)this.ENTITY_KEY, (QFilter[])filter.toArray());
        for (Map.Entry map : dynamicObjectMap.entrySet()) {
            BankLoginConfig bankLoginConfig = new BankLoginConfig();
            DynamicObject dynamicObject = (DynamicObject)map.getValue();
            BankLoginConfigKey key = new BankLoginConfigKey();
            key.setBankConfigId(dynamicObject.getString("bank_config_id"));
            key.setBankLoginId(bankLoginID);
            key.setCustomID(customID);
            bankLoginConfig.setKey(key);
            bankLoginConfig.setId(dynamicObject.getString("id"));
            bankLoginConfig.setBankConfigValue(dynamicObject.getString("bank_config_value"));
            bankLoginConfig.setInputType(dynamicObject.getString("input_type"));
            bankLoginConfigList.add(bankLoginConfig);
        }
        return bankLoginConfigList;
    }

    public DynamicObject[] loadByCustomID(String customID) {
        QFilter filter = QFilter.of((String)"custom_id = ?", (Object[])new Object[]{customID});
        String selectFields = " id, number, name, bank_config_id, bank_config_value, nullable, readonly, custom_id";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.ENTITY_KEY, (String)selectFields, (QFilter[])filter.toArray());
        return dynamicObjects;
    }
}

