/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.monitor;

import com.alibaba.fastjson.JSON;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.model.monitor.LoginMonitorCollection;
import kd.ebg.egf.common.model.monitor.LoginMonitorStatisticInfo;
import kd.ebg.egf.common.model.monitor.MonitorRequestInfo;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BankReqRecordRepository {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BankReqRecordRepository.class);
    public static String ENTITY_NAME = "aqap_bank_req_record";
    public static String PROPERTIES = "status,custom_id,bank_login_id,bank_version,req_number,biz_type,wait_lock_time,get_lock_time,block_millis,block_flag,process_millis,lock_num,ext_data";
    DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S");
    private static BankReqRecordRepository instance = new BankReqRecordRepository();

    public static BankReqRecordRepository getInstance() {
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, List<LoginMonitorStatisticInfo>> getStatisticMapByCustomID(String customID, LocalDateTime startTime, LocalDateTime endTime) {
        long entryTime = System.currentTimeMillis();
        int qty = 1;
        TimeUnit timeUnit = TimeUnit.HOURS;
        BankLoginRepository bankLoginRepository = BankLoginRepository.getInstance();
        List<BankLogin> bankLoginList = bankLoginRepository.findAllByCustomerID(customID);
        String value = CosmicCache.get(this.getCacheKey(customID));
        Map<Object, Object> map = new HashMap(16);
        LoginMonitorCollection collection = new LoginMonitorCollection();
        collection.setKey(customID);
        if (StringUtils.isNotEmpty(value)) {
            Map tempMap = (Map)JSON.parseObject((String)value, Map.class);
            Map map2 = (Map)tempMap.get("busyMonitorInfoMap");
            for (Map.Entry entry : map2.entrySet()) {
                ArrayList<LoginMonitorStatisticInfo> infos = new ArrayList<LoginMonitorStatisticInfo>(16);
                List list = (List)entry.getValue();
                for (int i = 0; i < list.size(); ++i) {
                    String jsonStr = JSON.toJSONString(list.get(i));
                    LoginMonitorStatisticInfo info = (LoginMonitorStatisticInfo)JSON.parseObject((String)jsonStr, LoginMonitorStatisticInfo.class);
                    infos.add(info);
                }
                collection.setBusyMonitorInfoMap((String)entry.getKey(), infos);
            }
            map = collection.getBusyMonitorInfoMap();
        }
        for (BankLogin bankLogin : bankLoginList) {
            void var15_25;
            List<LoginMonitorStatisticInfo> statisticInfoList;
            void var15_23;
            Object var15_21 = null;
            String bankLoginID = bankLogin.getKey().getBankLoginId();
            if (map.size() > 0 && map.containsKey(bankLoginID)) {
                List list = (List)map.get(bankLoginID);
            }
            if (var15_23 == null) {
                ArrayList arrayList = new ArrayList(16);
            }
            if ((statisticInfoList = this.getStatisticInfoByCustomID(customID, (List<LoginMonitorStatisticInfo>)var15_25, bankLogin.getKey().getBankLoginId(), startTime, endTime, qty, timeUnit)) == null || statisticInfoList.size() <= 0) continue;
            collection.setBusyMonitorInfoMap(bankLogin.getKey().getBankLoginId(), statisticInfoList);
        }
        CosmicCache.putIfAbsentWithExpire(this.getCacheKey(customID), JsonUtil.toJson(collection), 1, TimeUnit.DAYS);
        Map<String, List<LoginMonitorStatisticInfo>> infoMap = collection.getBusyMonitorInfoMap();
        for (Map.Entry<String, List<LoginMonitorStatisticInfo>> entry : infoMap.entrySet()) {
            String key = entry.getKey();
            List<LoginMonitorStatisticInfo> statisticInfos = entry.getValue();
            infoMap.put(key, this.buildLoginMonitorInfo(statisticInfos, startTime, endTime, timeUnit, qty));
        }
        for (BankLogin bankLogin : bankLoginList) {
            if (infoMap.containsKey(bankLogin.getKey().getBankLoginId())) continue;
            infoMap.put(bankLogin.getKey().getBankLoginId(), this.buildLoginMonitorInfo(null, startTime, endTime, timeUnit, qty));
        }
        long l = System.currentTimeMillis();
        long cost = l - entryTime;
        this.logger.info("\u524d\u7f6e\u673a\u7e41\u5fd9\u67e5\u8be2\u8017\u65f6" + cost + "s==\u67e5\u8be2\u524d\u7f6e\u673a==" + infoMap.size() + "\u5bb6");
        return infoMap;
    }

    private String getCacheKey(String customID) {
        StringBuilder sb = new StringBuilder();
        String day = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        sb.append("eb_login_monitor_").append(customID).append('_').append(day);
        return sb.toString();
    }

    private String getTimeSlot(LocalDateTime startTime, int hour, int delta) {
        int year = startTime.getYear();
        int month = startTime.getMonthValue();
        int dayOfMonth = startTime.getDayOfMonth();
        LocalDateTime time1 = LocalDateTime.of(year, month, dayOfMonth, delta - hour, 0, 0);
        String timeFormat1 = time1.format(DateTimeFormatter.ofPattern("yyyyMMdd HH:mm:ss"));
        LocalDateTime time2 = LocalDateTime.of(year, month, dayOfMonth, delta - hour, 59, 59);
        String timeFormat2 = time2.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        return timeFormat1 + "-" + timeFormat2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LoginMonitorStatisticInfo> getStatisticInfoByCustomID(String customID, List<LoginMonitorStatisticInfo> list, String bankLoginID, LocalDateTime startTime, LocalDateTime endTime, int qty, TimeUnit timeUnit) {
        String queryDate;
        String tag = "";
        String today = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        if (today.equalsIgnoreCase(queryDate = startTime.format(DateTimeFormatter.ofPattern("yyyyMMdd")))) {
            endTime = LocalDateTime.now();
        }
        Date start = Date.from(startTime.atZone(ZoneId.systemDefault()).toInstant());
        Date end = Date.from(endTime.atZone(ZoneId.systemDefault()).toInstant());
        try (DataSet ds = this.getStatisticDataSet(customID, bankLoginID, start, end);){
            Duration duration = Duration.between(startTime, endTime);
            long deltaTime = duration.toHours();
            if (timeUnit.compareTo(TimeUnit.MINUTES) == 0) {
                deltaTime = duration.toMinutes();
            } else if (timeUnit.compareTo(TimeUnit.HOURS) == 0) {
                deltaTime = duration.toHours();
            }
            deltaTime += (long)qty;
            boolean flag = false;
            int i = 0;
            while ((long)i < deltaTime) {
                int dQty = qty;
                int j = i + qty;
                if ((long)j > deltaTime) {
                    j = (int)deltaTime;
                    dQty = i + qty - j;
                }
                start = Date.from(this.plusDateTime(startTime, i, timeUnit).atZone(ZoneId.systemDefault()).toInstant());
                end = Date.from(this.plusDateTime(startTime, j, timeUnit).atZone(ZoneId.systemDefault()).toInstant());
                tag = String.valueOf(deltaTime - (long)j + (long)dQty);
                flag = false;
                String timeSlot = this.getTimeSlot(startTime, Integer.parseInt(tag), (int)deltaTime);
                if (list == null) {
                    list = new ArrayList<LoginMonitorStatisticInfo>(16);
                }
                for (LoginMonitorStatisticInfo info : list) {
                    if (!info.getTimeSlot().equalsIgnoreCase(timeSlot)) continue;
                    flag = true;
                    break;
                }
                if (!flag) {
                    try (DataSet copyDataSet = ds.copy();
                         DataSet filterDs = this.getStatisticDataSetByTime(copyDataSet, start, end);){
                        if (!filterDs.isEmpty()) {
                            LoginMonitorStatisticInfo info = this.getStatisticData(filterDs, tag, timeUnit);
                            info.setTimeSlot(timeSlot);
                            list.add(info);
                        }
                    }
                }
                i += qty;
            }
        }
        return list;
    }

    private DataSet getStatisticDataSetByTime(DataSet dataSet, final Date start, final Date end) {
        DataSet filter = dataSet.filter(new FilterFunction(){

            public boolean test(Row row) {
                Date waitTime = row.getDate("wait_lock_time");
                return waitTime.after(start) && waitTime.before(end);
            }
        });
        return filter;
    }

    private LocalDateTime plusDateTime(LocalDateTime dateTime, int num, TimeUnit timeUnit) {
        LocalDateTime localDateTime = timeUnit.compareTo(TimeUnit.MINUTES) == 0 ? dateTime.plusMinutes(num) : (timeUnit.compareTo(TimeUnit.HOURS) == 0 ? dateTime.plusHours(num) : LocalDateTime.now());
        return localDateTime;
    }

    private DataSet getStatisticDataSet(String customID, String bankLoginID, Date start, Date end) {
        QFilter filter = QFilter.of((String)"custom_id=? and bank_login_id=? and wait_lock_time >= ? and wait_lock_time <= ?", (Object[])new Object[]{customID, bankLoginID, start, end});
        DataSet ds = QueryServiceHelper.queryDataSet((String)"reqStatistic", (String)ENTITY_NAME, (String)PROPERTIES, (QFilter[])filter.toArray(), (String)"");
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoginMonitorStatisticInfo getStatisticData(DataSet ds, String tag, TimeUnit timeUnit) {
        LoginMonitorStatisticInfo info = new LoginMonitorStatisticInfo();
        DataSet ds1 = ds.copy();
        DataSet ds2 = ds.copy();
        try {
            Integer totalCount = ds.count("req_number", true);
            if (totalCount == 0) {
                info.setTag(tag);
                LoginMonitorStatisticInfo loginMonitorStatisticInfo = info;
                return loginMonitorStatisticInfo;
            }
            LoginMonitorStatisticInfo blockInfo = this.getRequestStatisticData(ds1, true, totalCount, tag, timeUnit);
            LoginMonitorStatisticInfo unBlockInfo = this.getRequestStatisticData(ds2, false, totalCount, tag, timeUnit);
            info.setBlockCount(blockInfo.getBlockCount());
            info.setTotalCount(totalCount);
            info.setTotalBlockTime(blockInfo.getTotalBlockTime() + unBlockInfo.getTotalBlockTime());
            info.setTotalProcessTime(blockInfo.getTotalProcessTime() + unBlockInfo.getTotalProcessTime());
            info.setTag(tag);
            info.setTimeUnit(timeUnit);
        }
        finally {
            ds1.close();
            ds2.close();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoginMonitorStatisticInfo getRequestStatisticData(DataSet dsCopy, boolean isBlock, int totalCount, String tag, TimeUnit timeUnit) {
        LoginMonitorStatisticInfo info = new LoginMonitorStatisticInfo();
        String filterStr = String.format("block_flag=\"" + isBlock + "\"", new Object[0]);
        DataSet ds = dsCopy.filter(filterStr);
        GroupbyDataSet groupDataSet = ds.groupBy(new String[]{"custom_id", "lock_num"});
        DataSet dataSet = groupDataSet.sum("block_millis", "blockSum").sum("process_millis", "processSum").count("count").finish();
        try {
            Iterator iterator = dataSet.iterator();
            Integer totalBlockTime = 0;
            Integer totalProcessTime = 0;
            Integer blockCount = 0;
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                int lockNum = row.getInteger("lock_num") == 0 ? 1 : row.getInteger("lock_num");
                totalBlockTime = totalBlockTime + row.getInteger("blockSum") / lockNum;
                totalProcessTime = totalProcessTime + row.getInteger("processSum") / lockNum;
                blockCount = blockCount + row.getInteger("count");
            }
            info.setBlockCount(blockCount);
            info.setTotalCount(totalCount);
            info.setTotalBlockTime(totalBlockTime);
            info.setTotalProcessTime(totalProcessTime);
            info.setTag(tag);
            info.setTimeUnit(timeUnit);
        }
        finally {
            dataSet.close();
            ds.close();
        }
        return info;
    }

    public boolean isHasRecords(String customID, String bankLoginID, LocalDateTime startTime, LocalDateTime endTime) {
        boolean result = false;
        try {
            QFilter filter = QFilter.of((String)"custom_id=? and bank_login_id=? and wait_lock_time >= ? and wait_lock_time <= ?", (Object[])new Object[]{customID, bankLoginID, startTime, endTime});
            result = QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])filter.toArray());
        }
        catch (Exception e) {
            this.logger.error("\u68c0\u67e5\u662f\u5426\u5b58\u5728\u8bf7\u6c42\u8bb0\u5f55\u62a5\u9519:" + e.getMessage(), e);
        }
        return result;
    }

    public String getErrorRecords(String customID, String bankLoginID, LocalDateTime startTime, LocalDateTime endTime) {
        String errorMsg = "";
        try {
            QFilter filter = QFilter.of((String)"custom_id=? and bank_login_id=? and wait_lock_time >= ? and wait_lock_time <= ? and status=?", (Object[])new Object[]{customID, bankLoginID, startTime, endTime, EBException.CONNECTION_EXCEPTION});
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)PROPERTIES, (QFilter[])filter.toArray());
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                DynamicObject dynamicObject;
                DynamicObject[] dynamicObjectArray = dynamicObjects;
                int n = dynamicObjectArray.length;
                for (int i = 0; i < n && !StringUtils.isNotEmpty(errorMsg = (dynamicObject = dynamicObjectArray[i]).getString("ext_data")); ++i) {
                    errorMsg = ResManager.loadKDString((String)"\u8fde\u63a5\u5f02\u5e38\uff0c\u62a5\u9519\u4fe1\u606f\u4e3a\u7a7a", (String)"BankReqRecordRepository_0", (String)"ebg-egf-common", (Object[])new Object[0]);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u68c0\u67e5\u662f\u5426\u5b58\u5728\u8bf7\u6c42\u8bb0\u5f55\u62a5\u9519:" + e.getMessage(), e);
        }
        return errorMsg;
    }

    public void save(MonitorRequestInfo info) {
        DynamicObject dynamicObject = this.transFormat(info);
        QFilter filter = QFilter.of((String)"req_number=?", (Object[])new Object[]{info.getRequestID()});
        if (QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])filter.toArray())) {
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
        } else {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public void insertAll(List<MonitorRequestInfo> infos) {
        if (infos != null && infos.size() > 0) {
            DynamicObject[] dynamicObjects = new DynamicObject[infos.size()];
            for (int i = 0; i < infos.size(); ++i) {
                dynamicObjects[i] = this.transFormat(infos.get(i));
                dynamicObjects[i].set("createtime", (Object)Date.from(infos.get(i).getWaitLockTime().atZone(ZoneId.systemDefault()).toInstant()));
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    public void clearHistory() {
        this.clearHistory(1L);
    }

    public void clearHistory(long month) {
        LocalDateTime time = LocalDateTime.now().minusMonths(month);
        QFilter filter = QFilter.of((String)"wait_lock_time <= ?", (Object[])new Object[]{time});
        DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])filter.toArray());
    }

    private MonitorRequestInfo transFormat(DynamicObject dynamicObject) {
        MonitorRequestInfo monitorRequestInfo = new MonitorRequestInfo();
        monitorRequestInfo.setCustomID(dynamicObject.getString("custom_id"));
        monitorRequestInfo.setStatus(dynamicObject.getString("status"));
        monitorRequestInfo.setBankLoginID(dynamicObject.getString("bank_login_id"));
        monitorRequestInfo.setBankVersionID(dynamicObject.getString("bank_version"));
        monitorRequestInfo.setRequestID(dynamicObject.getString("req_number"));
        monitorRequestInfo.setType(dynamicObject.getString("biz_type"));
        if (StringUtils.isNotEmpty(dynamicObject.getString("wait_lock_time"))) {
            monitorRequestInfo.setWaitLockTime(DTFactoryUtil.parseDateTime(dynamicObject.getString("wait_lock_time")));
        }
        if (StringUtils.isNotEmpty(dynamicObject.getString("get_lock_time"))) {
            monitorRequestInfo.setGetLockTime(DTFactoryUtil.parseDateTime(dynamicObject.getString("get_lock_time")));
        }
        if (StringUtils.isNotEmpty(dynamicObject.getString("block_millis"))) {
            monitorRequestInfo.setBlockMillis(Long.valueOf(dynamicObject.getString("block_millis")));
        }
        if (StringUtils.isNotEmpty(dynamicObject.getString("process_millis"))) {
            monitorRequestInfo.setProcessMillis(Long.valueOf(dynamicObject.getString("process_millis")));
        }
        monitorRequestInfo.setBlockFlag(Boolean.parseBoolean(dynamicObject.getString("block_flag")));
        monitorRequestInfo.setLoginLockNum(dynamicObject.getInt("lock_num"));
        monitorRequestInfo.setExtData(dynamicObject.getString("ext_data"));
        return monitorRequestInfo;
    }

    private DynamicObject transFormat(MonitorRequestInfo info) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        dynamicObject.set("custom_id", (Object)info.getCustomID());
        dynamicObject.set("status", (Object)info.getStatus());
        dynamicObject.set("bank_login_id", (Object)info.getBankLoginID());
        dynamicObject.set("bank_version", (Object)info.getBankVersionID());
        dynamicObject.set("req_number", (Object)info.getRequestID());
        dynamicObject.set("biz_type", (Object)info.getType());
        dynamicObject.set("wait_lock_time", (Object)Date.from(info.getWaitLockTime().atZone(ZoneId.systemDefault()).toInstant()));
        dynamicObject.set("get_lock_time", (Object)Date.from(info.getGetLockTime().atZone(ZoneId.systemDefault()).toInstant()));
        dynamicObject.set("block_millis", (Object)info.getBlockMillis());
        dynamicObject.set("block_flag", (Object)info.getBlockFlag());
        dynamicObject.set("process_millis", (Object)info.getProcessMillis());
        dynamicObject.set("lock_num", (Object)info.getLoginLockNum());
        if (StringUtils.isNotEmpty(info.getExtData())) {
            String msg = info.getExtData();
            if (info.getExtData().length() > 600) {
                msg = msg.substring(0, 599);
            }
            dynamicObject.set("ext_data", (Object)msg);
        } else {
            dynamicObject.set("ext_data", (Object)"");
        }
        return dynamicObject;
    }

    private List<LoginMonitorStatisticInfo> buildLoginMonitorInfo(List<LoginMonitorStatisticInfo> list, LocalDateTime startTime, LocalDateTime endTime, TimeUnit timeUnit, int qty) {
        String tag = "";
        Duration duration = Duration.between(startTime, endTime);
        long deltaTime = duration.toHours();
        if (timeUnit.compareTo(TimeUnit.MINUTES) == 0) {
            deltaTime = duration.toMinutes();
        } else if (timeUnit.compareTo(TimeUnit.HOURS) == 0) {
            deltaTime = duration.toHours();
        }
        deltaTime += (long)qty;
        boolean flag = false;
        int i = 0;
        while ((long)i < deltaTime) {
            int dQty = qty;
            int j = i + qty;
            if ((long)j > deltaTime) {
                j = (int)deltaTime;
                dQty = i + qty - j;
            }
            tag = String.valueOf(deltaTime - (long)j + (long)dQty);
            flag = false;
            String timeSlot = this.getTimeSlot(startTime, Integer.parseInt(tag), (int)deltaTime);
            if (list == null) {
                list = new ArrayList<LoginMonitorStatisticInfo>(16);
            }
            for (LoginMonitorStatisticInfo info : list) {
                if (!info.getTimeSlot().equalsIgnoreCase(timeSlot)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                LoginMonitorStatisticInfo info = new LoginMonitorStatisticInfo();
                info.setTimeSlot(timeSlot);
                list.add(info);
            }
            i += qty;
        }
        return list;
    }

    public void saveLoginConnectTestFail(EBContext context, String errorMsg) {
        MonitorRequestInfo monitorRequestInfo = new MonitorRequestInfo();
        monitorRequestInfo.setWaitLockTime(LocalDateTime.now());
        monitorRequestInfo.setGetLockTime(LocalDateTime.now());
        monitorRequestInfo.setExtData(errorMsg);
        monitorRequestInfo.setStatus(EBException.CONNECTION_EXCEPTION);
        monitorRequestInfo.setRequestID(context.getRequestSeqID());
        monitorRequestInfo.setBlockFlag(false);
        monitorRequestInfo.setBlockMillis(0L);
        monitorRequestInfo.setProcessMillis(0L);
        monitorRequestInfo.setCustomID(context.getCustomID());
        monitorRequestInfo.setBankVersionID(context.getBankVersionID());
        monitorRequestInfo.setBankLoginID(context.getBankLoginID());
        monitorRequestInfo.setType(context.getBizName());
        monitorRequestInfo.setLoginLockNum(1);
        try {
            this.save(monitorRequestInfo);
        }
        catch (Throwable t) {
            this.logger.error("saveLoginConnectTestFail invoke error", t);
        }
    }
}

