/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.utils.datetime;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.annotation.SdkDeprecated;

public class DateTimeUtils {
    private static TimeZone gmt = new SimpleTimeZone(0, "GMT");

    @SdkDeprecated
    public static String format(Date d, String fmt) {
        return DateTimeUtils.format(d, fmt, null);
    }

    @SdkDeprecated
    public static String format(Date d, String fmt, TimeZone timezone) {
        return DateTimeUtils.format(d, fmt, timezone, null);
    }

    @SdkDeprecated
    public static String format(Date d, String fmt, TimeZone timezone, Locale locale) {
        if (fmt == null) {
            fmt = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(fmt) : new SimpleDateFormat(fmt, locale);
        if (timezone == null) {
            df.setTimeZone(TimeZone.getDefault());
        } else {
            df.setTimeZone(timezone);
        }
        return df.format(d);
    }

    @SdkDeprecated
    public static String format(Date d) {
        return DateTimeUtils.format(d, null, null);
    }

    @SdkDeprecated
    public static String format(Date d, TimeZone timezone) {
        return DateTimeUtils.format(d, null, timezone);
    }

    public static String formatDate(Date d, TimeZone timezone) {
        return DateTimeUtils.format(d, "yyyy-MM-dd", timezone);
    }

    public static String formatDate(Date d) {
        return DateTimeUtils.formatDate(d, null);
    }

    public static String formatTime(Date d, TimeZone timezone) {
        return DateTimeUtils.format(d, "HH:mm:ss", timezone);
    }

    public static String formatTime(Date d) {
        return DateTimeUtils.formatDate(d, null);
    }

    public static String defaultDateString(Date d) {
        return DateTimeUtils.defaultDateString(d, null);
    }

    public static String defaultDateString(Date d, TimeZone timezone) {
        if (timezone == null) {
            timezone = TimeZone.getDefault();
        }
        long l = timezone.getRawOffset();
        StringBuilder temp = new StringBuilder(DateTimeUtils.format(d, timezone));
        if (l > 0L) {
            temp.append(" +");
        } else {
            temp.append(" -");
            l = -l;
        }
        temp.append(DateTimeUtils.format(new Date(l), "HH:mm", gmt));
        return temp.toString();
    }

    public static Date parseDate(String s) throws ParseException {
        if (StringUtils.isEmpty(s)) {
            return null;
        }
        try {
            return DateTimeUtils.parseDate(s, "yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException parseException) {
            try {
                return DateTimeUtils.parseDate(s, "yyyy-MM-dd");
            }
            catch (ParseException parseException2) {
                try {
                    return DateTimeUtils.parseDate(s, "HH:mm:ss");
                }
                catch (ParseException parseException3) {
                    throw new ParseException("can not udstand your format", -1);
                }
            }
        }
    }

    public static Date parseDate(String s, String fmt) throws ParseException {
        return DateTimeUtils.parseDate(s, fmt, null);
    }

    public static Date parseDate(String s, String fmt, TimeZone timezone) throws ParseException {
        return DateTimeUtils.parseDate(s, fmt, timezone, null);
    }

    public static Date parseDate(String s, String fmt, TimeZone timezone, Locale locale) throws ParseException {
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(fmt) : new SimpleDateFormat(fmt, locale);
        if (timezone == null) {
            timezone = TimeZone.getDefault();
        }
        df.setTimeZone(timezone);
        df.setLenient(false);
        return df.parse(s);
    }

    public static Date parseDefaultDate(String s) throws ParseException {
        int i = s.lastIndexOf(32);
        char c = s.charAt(i + 1);
        long l = DateTimeUtils.parseDate(s.substring(i + 2), "HH:mm", gmt).getTime();
        if (c == '-') {
            l = -l;
        }
        return DateTimeUtils.parseDate(s.substring(0, i), "yyyy-MM-dd HH:mm:ss", new SimpleTimeZone((int)l, "XXX"));
    }

    public static String emailDate(Date d) {
        return DateTimeUtils.emailDate(d, null);
    }

    public static String emailDate(Date d, TimeZone timezone) {
        if (timezone == null) {
            timezone = TimeZone.getDefault();
        }
        long l = timezone.getRawOffset();
        StringBuilder temp = new StringBuilder(DateTimeUtils.format(d, "E, d MMM yyyy HH:mm:ss", timezone, Locale.UK));
        if (l > 0L) {
            temp.append(" +");
        } else {
            temp.append(" -");
            l = -l;
        }
        temp.append(DateTimeUtils.format(new Date(l), "HHmm", gmt));
        return temp.toString();
    }

    public static Date parseEmailDate(String s) throws ParseException {
        try {
            int i = s.lastIndexOf(32);
            char c = s.charAt(i + 1);
            long l = DateTimeUtils.parseDate(s.substring(i + 2), "HHmm", gmt).getTime();
            if (c == '-') {
                l = -l;
            }
            return DateTimeUtils.parseDate(s.substring(0, i), "E, d MMM yyyy HH:mm:ss", new SimpleTimeZone((int)l, "XXX"), Locale.UK);
        }
        catch (Exception exception) {
            return DateTimeUtils.parseDate(s, "E, d MMM yyyy HH:mm:ss z", gmt, Locale.UK);
        }
    }

    public static boolean dayBefore(Date dt, Date dt1) {
        Calendar c = Calendar.getInstance();
        c.setTime(dt);
        int year = c.get(1);
        int date = c.get(6);
        c.setTime(dt1);
        int year1 = c.get(1);
        int date1 = c.get(6);
        return year < year1 || year == year1 && date < date1;
    }

    public static boolean dayAfter(Date dt, Date dt1) {
        Calendar c = Calendar.getInstance();
        c.setTime(dt);
        int year = c.get(1);
        int date = c.get(6);
        c.setTime(dt1);
        int year1 = c.get(1);
        int date1 = c.get(6);
        return year > year1 || year == year1 && date > date1;
    }
}

