/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.utils.datetime;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.inte.api.IInteService;
import kd.bos.service.ServiceFactory;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.sdk.annotation.SdkDeprecated;

public class DateUtil {
    public static String DEFAULT_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static String transTimeZoneSystemToUser(LocalDateTime dateTime) {
        return DateUtil.transTimeZoneSystemToUser(dateTime, DEFAULT_TIME_FORMAT);
    }

    public static String transTimeZoneSystemToUser(LocalDateTime dateTime, String dateFormat) {
        Date date = Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
        return DateUtil.transTimeZoneSystemToUser(date, dateFormat);
    }

    public static String transTimeZoneSystemToUser(Date date) {
        return DateUtil.transTimeZoneSystemToUser(date, DEFAULT_TIME_FORMAT);
    }

    public static String transTimeZoneSystemToUser(Date date, String dateFormat) {
        SimpleDateFormat dft = new SimpleDateFormat(dateFormat);
        dft.setTimeZone(TimeZone.getTimeZone(DateUtil.getUserTimeZone()));
        String userDateStr = dft.format(date);
        return userDateStr;
    }

    private static String getUserTimeZone() {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        long userID = RequestContext.get().getCurrUserId();
        DynamicObject dynamicObject = service.getUserTimezone(Long.valueOf(userID));
        String timezone = dynamicObject.getString("number");
        return timezone;
    }

    public static long getDayDiff(Date date1, Date date2) {
        try {
            long daysBetween = (date2.getTime() - date1.getTime() + 1000000L) / 86400000L;
            return daysBetween;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static Date getNextDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) + i);
        return cal.getTime();
    }

    public static Date getLastDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) - i);
        return cal.getTime();
    }

    public static Date String2Date(String str) {
        Date date = new Date();
        int year = Integer.parseInt(str.substring(0, 4));
        date.setYear(year - 1900);
        int month = Integer.parseInt(str.substring(4, 6));
        date.setMonth(month - 1);
        int day = Integer.parseInt(str.substring(6, 8));
        date.setDate(day);
        if (str.length() > 8) {
            int hour = Integer.parseInt(str.substring(8, 10));
            date.setHours(hour);
            int minute = Integer.parseInt(str.substring(10, 12));
            date.setMinutes(minute);
            int second = Integer.parseInt(str.substring(12, 14));
            date.setSeconds(second);
        }
        return date;
    }

    public static Date string2Date(String str, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        try {
            return formatter.parse(str);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Date nextDay(Date date) {
        long time = date.getTime();
        return new Date(time += 86400000L);
    }

    public static Date nextDay(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int day = cal.get(6);
        cal.set(6, day + n);
        return cal.getTime();
    }

    public static Date preDay(Date date) {
        long time = date.getTime();
        return new Date(time -= 86400000L);
    }

    public static Date preDay(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.get(5) - n);
        return cal.getTime();
    }

    public static Date preMinutes(int minutes) {
        Date now = new Date();
        long time = now.getTime();
        return new Date(time -= (long)(60000 * minutes));
    }

    public static Date preMinutes(Date date, int minutes) {
        long time = date.getTime();
        return new Date(time -= (long)(60000 * minutes));
    }

    public static Date preMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, cal.get(2) - 1);
        return cal.getTime();
    }

    public static Date preMonth(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, cal.get(2) - n);
        return cal.getTime();
    }

    public static Date preYear(Date date, int n) {
        return DateUtil.preMonth(date, n * 12);
    }

    @SdkDeprecated
    public static boolean isSameDay(Date date1, Date date2) {
        return date1.getYear() == date2.getYear() && date1.getMonth() == date2.getMonth() && date1.getDate() == date2.getDate();
    }

    @SdkDeprecated
    public static boolean isSameDay(LocalDate date1, LocalDate date2) {
        return date1.compareTo(date2) == 0;
    }

    public static String formatDateTime(Date date) {
        return new SimpleDateFormat("yyyyMMddHHmmss").format(date);
    }

    public static String formatDate4Log(Date date) {
        return new SimpleDateFormat("yyyy_MM_dd").format(date);
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat("yyyyMMdd").format(date);
    }

    public static String formatDate(Date date, String format) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(format).format(date);
    }

    public static String formatDate(LocalDate date, String format) {
        if (date == null) {
            return null;
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        return date.format(dateTimeFormatter);
    }

    public static String formatDate4Oracle(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static String formatDate4Persion(Date date) {
        if (null == date) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static String formatDate4KSQL(Date date) {
        String dateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
        return "ts{'" + dateString + "'}";
    }

    public static String formatTime(Date date) {
        return new SimpleDateFormat("HHmmss").format(date);
    }

    public static String formatTime4yyyyMMdd(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    public static Date today() {
        Date now = new Date();
        String strToday = DateUtil.formatDate(now);
        Date today = null;
        try {
            today = new SimpleDateFormat("yyyyMMdd").parse(strToday);
        }
        catch (ParseException e) {
            throw EBExceiptionUtil.serviceException(e);
        }
        return DateUtil.getDate(today);
    }

    private static String getString(Calendar c) {
        StringBuilder result = new StringBuilder();
        result.append(c.get(1));
        result.append('-');
        result.append(c.get(2) + 1);
        result.append('-');
        result.append(c.get(5));
        result.append(' ');
        result.append(c.get(11));
        result.append(':');
        result.append(c.get(12));
        result.append(':');
        result.append(c.get(13));
        return result.toString();
    }

    public static Date getAD() {
        Date ad = DateUtil.String2Date("000000000000000000000000000");
        Calendar c = Calendar.getInstance();
        return c.getTime();
    }

    public static Date getDate(Date dateTime) {
        try {
            String dateStr = DateTimeUtils.format(dateTime, "yyyyMMdd");
            return DateTimeUtils.parseDate(dateStr + "000000.0000000", "yyyyMMddHHmmss.SSSSSSS");
        }
        catch (ParseException e) {
            throw EBExceiptionUtil.serviceException(e);
        }
    }

    public static Date getDateTime(Date dateTime) {
        try {
            String dateStr = DateTimeUtils.format(dateTime, "yyyyMMddHHmmss");
            return DateTimeUtils.parseDate(dateStr, "yyyyMMddHHmmss");
        }
        catch (ParseException e) {
            throw EBExceiptionUtil.serviceException(e);
        }
    }

    public static int getMonthDiff(String dateStr1, String dateStr2) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            Calendar bef = Calendar.getInstance();
            Calendar aft = Calendar.getInstance();
            bef.setTime(sdf.parse(dateStr1));
            aft.setTime(sdf.parse(dateStr2));
            int result = aft.get(2) - bef.get(2);
            int month = (aft.get(1) - bef.get(1)) * 12;
            return month + result;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static boolean isBefore(Date date1, Date date2) {
        return date1.getTime() < date2.getTime();
    }

    public static Date nextMonth(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2);
        cal.set(2, month + n);
        return cal.getTime();
    }

    public static String nextMonth(String dateStr, int n) {
        if (n == 0) {
            return dateStr;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        try {
            Date nextMonth = DateUtil.nextMonth(sdf.parse(dateStr), n);
            return sdf.format(nextMonth);
        }
        catch (Exception exception) {
            return "";
        }
    }
}

