/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote.receivable.discount;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.BankBusinessConfig;
import kd.ebg.note.banks.cib.dc.services.newnote.NoteHandlerHelper;
import kd.ebg.note.banks.cib.dc.services.newnote.NoteStatusUtil;
import kd.ebg.note.banks.cib.dc.services.newnote.receivable.QueryNoteReceivableImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class ReceivableDiscountNoteImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(ReceivableDiscountNoteImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "NEWEBDISCNTTRNRQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u8d34\u73b0", (String)"ReceivableDiscountNoteImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String packOnline(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        NoteReceivableInfo[] receivableInfos = bankNoteReceivableRequest.getNotePayableInfosAsArray();
        NoteReceivableInfo info = receivableInfos[0];
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBDRAWTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"XETDISCNTTRNRQ");
        JDomUtils.addChild((Element)EBDRAWTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBDRAWTRNRQ_RQBODY = JDomUtils.addChild((Element)EBDRAWTRNRQ, (String)"RQBODY");
        BankAcnt acnt = RequestContextUtils.getRequestContext().getAcnt();
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"ACCTID", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"DSCNT_RATE", (String)ReceivableDiscountNoteImpl.formatToTwoDecimalPlaces(info.getDisCountRate()));
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"DSCNT_REMARK", (String)info.getExplanation());
        String discountType = info.getDiscountType();
        if (StringUtils.isEmpty((String)discountType)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ed8\u606f\u65b9\u5f0f\u83b7\u53d6\u5931\u8d25", (String)"ReceivableDiscountNoteImpl_12", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
        }
        if ("2".equals(discountType)) {
            JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"PAYINTRSTMODE", (String)"02");
            JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"BUYER_PAY_INTRST_CNTRCT_NO", (String)info.getContractNo());
        } else if ("1".equals(discountType)) {
            JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"PAYINTRSTMODE", (String)"01");
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4ed8\u606f\u65b9\u5f0f\u5f02\u5e38\uff0c\u4ed8\u606f\u65b9\u5f0f\uff1a%s", (String)"ReceivableDiscountNoteImpl_4", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), discountType));
        }
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"DSCNT_USAGE", (String)info.getExplanation());
        int count = 0;
        for (NoteReceivableInfo noteReceivableInfo : receivableInfos) {
            NoteReceivableInfo infoChecked = NoteStatusUtil.INSTANCE.queryOperableNoteDetails(info, "BC08");
            if (infoChecked == null) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53ef\u64cd\u4f5c\u7968\u636e\u67e5\u8be2\u62a5\u9519\uff0c\u5f53\u524d\u7968\u636e\u65e0\u6cd5\u8d34\u73b0\uff0c\u8bf7\u6838\u5b9e\u7968\u636e\u72b6\u6001", (String)"ReceivableDiscountNoteImpl_13", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            }
            noteReceivableInfo.setReserved1(TRNUID);
            Element RQBODY_CONTENT = JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"CONTENT");
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"INDEX", (String)(++count + ""));
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"DRAFT_NO", (String)noteReceivableInfo.getBillNo());
            if (StringUtils.isEmpty((String)infoChecked.getReserved4())) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u53ef\u64cd\u4f5c\u7968\u636e\u67e5\u8be2\u62a5\u9519\uff0c%s\u65e0\u6cd5\u8d34\u73b0\uff0c\u8bf7\u6838\u5b9e\u7968\u636e\u72b6\u6001", (String)"ReceivableDiscountNoteImpl_14", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), infoChecked.getBillNo()));
            }
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"SUB_DRAFT_INTERVAL", (String)NoteHandlerHelper.getFixSubBillRng(infoChecked));
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"DSCNT_DRAFT_AMT", (String)(noteReceivableInfo.getAmount() + ""));
        }
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        NoteReceivableInfo[] receivableInfos = bankNoteReceivableRequest.getNotePayableInfosAsArray();
        NoteReceivableInfo info = receivableInfos[0];
        if (BankBusinessConfig.isOnlinDiscount() && "AC01".equals(info.getDraftType())) {
            return this.packOnline(bankNoteReceivableRequest, s);
        }
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBDRAWTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"NEWEBDISCNTTRNRQ");
        JDomUtils.addChild((Element)EBDRAWTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBDRAWTRNRQ_RQBODY = JDomUtils.addChild((Element)EBDRAWTRNRQ, (String)"RQBODY");
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"DISCNTTYPE", (String)"BC08");
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"ENDORSEFLAG", (String)"EM00");
        String disCountRate = receivableInfos[0].getDisCountRate();
        if (StringUtils.isEmpty((String)disCountRate)) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8d34\u73b0\u5229\u7387\u4e0d\u80fd\u4e3a\u7a7a", (String)"ReceivableDiscountNoteImpl_11", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
        }
        BigDecimal b1 = new BigDecimal(receivableInfos[0].getDisCountRate());
        if (b1.compareTo(BigDecimal.ZERO) < 1) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8d34\u73b0\u5229\u7387\u5fc5\u987b\u4e3a\u6b63\u6570", (String)"ReceivableDiscountNoteImpl_15", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
        }
        BigDecimal b2 = b1.divide(new BigDecimal(1), 4, 4);
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"INTRSTRATE", (String)(b2 + ""));
        BankAcnt acnt = RequestContextUtils.getRequestContext().getAcnt();
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"ACCTID", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"DSCNTBRHBANKNO", (String)info.getPayeeBankCnaps());
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"SETTLEMODE", (String)"ST02");
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"CLEARTYPE", (String)"CT01");
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"SETTLEACCTNAME", (String)info.getAcceptorAccName());
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"SETTLEACCTID", (String)info.getAcceptorAccNo());
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"SETTLEBANKNO", (String)info.getAcceptorBankCnaps());
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"DRAFTTYPE", (String)info.getDraftType());
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"DSCNTPROTYPE", (String)"1");
        String discountType = info.getDiscountType();
        if (StringUtils.isEmpty((String)discountType)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ed8\u606f\u65b9\u5f0f\u83b7\u53d6\u5931\u8d25", (String)"ReceivableDiscountNoteImpl_12", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
        }
        if ("2".equals(discountType)) {
            JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"PAYINTRMODE", (String)"02");
            JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"BUYERPAYINTRCNTNO", (String)info.getContractNo());
        } else if ("1".equals(discountType)) {
            JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"PAYINTRMODE", (String)"01");
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4ed8\u606f\u65b9\u5f0f\u5f02\u5e38\uff0c\u4ed8\u606f\u65b9\u5f0f\uff1a%s", (String)"ReceivableDiscountNoteImpl_4", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), discountType));
        }
        if (StringUtils.isEmpty((String)info.getExplanation())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6458\u8981\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceivableDiscountNoteImpl_5", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"USEAGE", (String)info.getExplanation());
        int count = 0;
        for (NoteReceivableInfo noteReceivableInfo : receivableInfos) {
            NoteReceivableInfo infoChecked = NoteStatusUtil.INSTANCE.queryOperableNoteDetails(info, "BC08");
            if (infoChecked == null) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53ef\u64cd\u4f5c\u7968\u636e\u67e5\u8be2\u62a5\u9519\uff0c\u5f53\u524d\u7968\u636e\u65e0\u6cd5\u8d34\u73b0\uff0c\u8bf7\u6838\u5b9e\u7968\u636e\u72b6\u6001", (String)"ReceivableDiscountNoteImpl_13", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            }
            noteReceivableInfo.setReserved1(TRNUID);
            Element RQBODY_CONTENT = JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"CONTENT");
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"INDEX", (String)(++count + ""));
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"DRAFTNO", (String)noteReceivableInfo.getBillNo());
            if (StringUtils.isEmpty((String)infoChecked.getReserved4())) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u53ef\u64cd\u4f5c\u7968\u636e\u67e5\u8be2\u62a5\u9519\uff0c%s\u65e0\u6cd5\u8d34\u73b0\uff0c\u8bf7\u6838\u5b9e\u7968\u636e\u72b6\u6001", (String)"ReceivableDiscountNoteImpl_14", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), infoChecked.getBillNo()));
            }
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"DRAFTRANGE", (String)NoteHandlerHelper.getFixSubBillRng(infoChecked));
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"DRAFTAMT", (String)(noteReceivableInfo.getDraftAmount() + ""));
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"DSCNTDRAFTAMT", (String)(noteReceivableInfo.getAmount() + ""));
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"DUEDATE", (String)LocalDateUtil.formatDate((LocalDate)noteReceivableInfo.getDueDate()));
        }
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String rsp) {
        List receivableInfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
        Element root = CIB_DC_Parser.parseString2Root(rsp);
        BankResponse bankResponse = CIB_DC_Parser.noteParseString2Root(root);
        if (!"0".equals(bankResponse.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return receivableInfos;
        }
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBDISCNTTRNRS = null;
        EBDISCNTTRNRS = BankBusinessConfig.isOnlinDiscount() && "AC01".equals(info.getDraftType()) ? eb1.getChild("XETDISCNTTRNRS") : eb1.getChild("NEWEBDISCNTTRNRS");
        Element STATUS = EBDISCNTTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        this.logger.info("code:" + code + ",MESSAGE:" + MESSAGE);
        if (!"0".equals(code)) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.FAIL, (String)code, (String)MESSAGE);
        } else {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)MESSAGE);
        }
        return receivableInfos;
    }

    public static String formatToTwoDecimalPlaces(String numberStr) {
        try {
            double number = Double.parseDouble(numberStr);
            DecimalFormat df = new DecimalFormat("#.00");
            df.setRoundingMode(RoundingMode.DOWN);
            return df.format(number);
        }
        catch (NumberFormatException e) {
            throw EBExceiptionUtil.serviceException((String)("Invalid number format: " + numberStr));
        }
    }
}

