/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.note.payable.receive;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.note.payable.receive.QueryReceiveNotePayableImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class ReceiveNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiveNotePayableImpl.class);

    public int getBatchSize() {
        return 10;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryReceiveNotePayableImpl.class;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen16Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBCOLLTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"EBCOLLTRNRQ");
        JDomUtils.addChild((Element)EBCOLLTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBCOLLTRNRQ_RQBODY = JDomUtils.addChild((Element)EBCOLLTRNRQ, (String)"RQBODY");
        JDomUtils.addChild((Element)EBCOLLTRNRQ_RQBODY, (String)"TOTALCOUNT");
        JDomUtils.addChild((Element)EBCOLLTRNRQ_RQBODY, (String)"TOTALAMT");
        JDomUtils.addChild((Element)EBCOLLTRNRQ_RQBODY, (String)"ACCTID", (String)info.getDrawerAccNo());
        JDomUtils.addChild((Element)EBCOLLTRNRQ_RQBODY, (String)"BILLTYPE", (String)info.getDraftType());
        JDomUtils.addChild((Element)EBCOLLTRNRQ_RQBODY, (String)"MEMO", (String)info.getExplanation());
        int count = 0;
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (NotePayableInfo notePayableInfo : notePayableInfos) {
            notePayableInfo.setRqstserialno(TRNUID);
            Element RQBODY_CONTENT = JDomUtils.addChild((Element)EBCOLLTRNRQ_RQBODY, (String)"CONTENT");
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"INDX", (String)(++count + ""));
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"BILLCODE", (String)notePayableInfo.getBillNo());
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"BILLAMT", (String)(notePayableInfo.getAmount() + ""));
            totalAmt = totalAmt.add(notePayableInfo.getAmount());
        }
        JDomUtils.getChildElement((Element)EBCOLLTRNRQ_RQBODY, (String)"TOTALCOUNT").addContent(count + "");
        JDomUtils.getChildElement((Element)EBCOLLTRNRQ_RQBODY, (String)"TOTALAMT").addContent(totalAmt + "");
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        this.logger.info("\u63d0\u793a\u6536\u7968\u62a5\u6587\uff1a" + str);
        return str;
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        Element root = CIB_DC_Parser.parseString2Root(responseStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBCOLLTRNRS = eb1.getChild("EBCOLLTRNRS");
        Element STATUS = EBCOLLTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        this.logger.info("code:" + code + ",MESSAGE:" + MESSAGE);
        if (!"0".equals(code)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"ReceiveNotePayableImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (String)MESSAGE);
        } else {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"ReceiveNotePayableImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (String)MESSAGE);
        }
        return notePayableInfos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968\u540c\u6b65", (String)"ReceiveNotePayableImpl_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }
}

