/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.note.payable.register;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.BankBusinessConfig;
import kd.ebg.note.banks.cib.dc.services.Common;
import kd.ebg.note.banks.cib.dc.services.note.payable.register.QueryRegisterNotePayableImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class RegisterNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(RegisterNotePayableImpl.class);

    public int getBatchSize() {
        return 100;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryRegisterNotePayableImpl.class;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        List notePayableInfos = request.getNotePayableInfoList();
        if (BankBusinessConfig.isOnlineRegister() && "AC01".equals(((NotePayableInfo)notePayableInfos.get(0)).getDraftType())) {
            return this.packOnline(request, pageTag);
        }
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen16Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBDRAWTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"EBDRAWTRNRQ");
        JDomUtils.addChild((Element)EBDRAWTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBDRAWTRNRQ_RQBODY = JDomUtils.addChild((Element)EBDRAWTRNRQ, (String)"RQBODY");
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"TOTALCOUNT");
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"TOTALAMT");
        if ("1".equals(info.getAutoAccept()) && "1".equals(info.getAutoReceive())) {
            JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"TYPE", (String)"05");
        } else {
            JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"TYPE", (String)"01");
        }
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"BILLTYPE", (String)info.getDraftType());
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"DRAWACCTID", (String)info.getDrawerAccNo());
        int count = 0;
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (NotePayableInfo notePayableInfo : notePayableInfos) {
            notePayableInfo.setRqstserialno(TRNUID);
            Element EBDRAWTRNRQ_CONTENT = JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"CONTENT");
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"INDX", (String)(++count + ""));
            notePayableInfo.setBankSerialNo(count + "");
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"BILLAMT", (String)(notePayableInfo.getAmount() + ""));
            LocalDate issue = info.getBookingDate();
            Date IssueDate = Date.from(issue.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"DRAWDATE", (String)(IssueDate != null ? DateTimeUtils.format((Date)IssueDate, (String)"yyyy-MM-dd") : DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd")));
            LocalDate due = notePayableInfo.getDueDate();
            Date dueDate = Date.from(due.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"DUEDATE", (String)(dueDate != null ? DateTimeUtils.format((Date)dueDate, (String)"yyyy-MM-dd") : ""));
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"NEGTBL", (String)notePayableInfo.getTransferFlag());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"ISCIB", (String)(Common.isSameBank(info.getPayeeBankName(), info.getBankVersionID()) ? "Y" : "N"));
            Element EBDRAWTRNRQ_PAYEEACCT = JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"PAYEEACCT");
            JDomUtils.addChild((Element)EBDRAWTRNRQ_PAYEEACCT, (String)"ACCTID", (String)notePayableInfo.getPayeeAccNo());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_PAYEEACCT, (String)"NAME", (String)notePayableInfo.getPayeeAccName());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_PAYEEACCT, (String)"BANKNUM", (String)notePayableInfo.getPayeeBankCnaps());
            Element EBDRAWTRNRQ_ACACCT = JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"ACACCT");
            JDomUtils.addChild((Element)EBDRAWTRNRQ_ACACCT, (String)"ACCTID", (String)notePayableInfo.getAcceptorAccNo());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_ACACCT, (String)"NAME", (String)notePayableInfo.getAcceptorAccName());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_ACACCT, (String)"BANKNUM", (String)notePayableInfo.getAcceptorBankCnaps());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"ENTRSPAY", (String)"CC00");
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"DRAWMEMO", (String)notePayableInfo.getExplanation());
            totalAmt = totalAmt.add(notePayableInfo.getAmount());
        }
        JDomUtils.getChildElement((Element)EBDRAWTRNRQ_RQBODY, (String)"TOTALCOUNT").addContent(count + "");
        JDomUtils.getChildElement((Element)EBDRAWTRNRQ_RQBODY, (String)"TOTALAMT").addContent(totalAmt + "");
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public String packOnline(BankNotePayableRequest request, String pageTag) {
        this.logger.info("************\u5728\u7ebf\u878d\u8d44\u51fa\u7968\u7533\u8bf7");
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen16Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBDRAWTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"DRAWFINANCETRNRQ");
        JDomUtils.addChild((Element)EBDRAWTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBDRAWTRNRQ_RQBODY = JDomUtils.addChild((Element)EBDRAWTRNRQ, (String)"RQBODY");
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"BIZCODE", (String)"301");
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"CURRENCY", (String)"01");
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"FINPURPOSE", (String)info.getExplanation());
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"DRAWACCTID", (String)info.getDrawerAccNo());
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"TOTALCOUNT");
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"TOTALAMT");
        int count = 0;
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (NotePayableInfo notePayableInfo : notePayableInfos) {
            Element EBDRAWTRNRQ_CONTENT = JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"CONTENT");
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"INDX", (String)(++count + ""));
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"BILLTYPE", (String)"AC01");
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"BILLAMT", (String)(notePayableInfo.getAmount() + ""));
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"DRAWDATE", (String)notePayableInfo.getBookingDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"DUEDATE", (String)notePayableInfo.getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"NEGTBL", (String)notePayableInfo.getTransferFlag());
            Element EBDRAWTRNRQ_ACACCT = JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"ACACCT");
            JDomUtils.addChild((Element)EBDRAWTRNRQ_ACACCT, (String)"NAME", (String)notePayableInfo.getAcceptorAccName());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_ACACCT, (String)"ACCTID", (String)notePayableInfo.getAcceptorAccNo());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_ACACCT, (String)"BANKNUM", (String)notePayableInfo.getAcceptorBankCnaps());
            Element EBDRAWTRNRQ_PAYEEACCT = JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"PAYEEACCT");
            JDomUtils.addChild((Element)EBDRAWTRNRQ_PAYEEACCT, (String)"NAME", (String)notePayableInfo.getPayeeAccName());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_PAYEEACCT, (String)"ACCTID", (String)notePayableInfo.getPayeeAccNo());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_PAYEEACCT, (String)"BANKNUM", (String)notePayableInfo.getPayeeBankCnaps());
            JDomUtils.addChild((Element)EBDRAWTRNRQ_CONTENT, (String)"ENTRSPAY", (String)"CC00");
            notePayableInfo.setBankSerialNo(TRNUID);
            notePayableInfo.setReserved2(TRNUID);
            this.logger.info("\u5b58\u50a8\u7684TRNUID" + TRNUID);
            totalAmt = totalAmt.add(notePayableInfo.getAmount());
        }
        JDomUtils.getChildElement((Element)EBDRAWTRNRQ_RQBODY, (String)"TOTALCOUNT").addContent(count + "");
        JDomUtils.getChildElement((Element)EBDRAWTRNRQ_RQBODY, (String)"TOTALAMT").addContent(totalAmt + "");
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        Element root = CIB_DC_Parser.parseString2Root(responseStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        if (BankBusinessConfig.isOnlineRegister() && "AC01".equals(((NotePayableInfo)notePayableInfos.get(0)).getDraftType())) {
            Element DRAWFINANCETRNRS = eb1.getChild("DRAWFINANCETRNRS");
            Element STATUS = DRAWFINANCETRNRS.getChild("STATUS");
            String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
            String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
            if (!"0".equals(code)) {
                EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"RegisterNotePayableImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (String)MESSAGE);
            } else {
                String srvrid = JDomUtils.getChildText((Element)DRAWFINANCETRNRS.getChild("RSBODY"), (String)"SRVRID");
                ((NotePayableInfo)notePayableInfos.get(0)).setObssid(srvrid);
                this.logger.info("\u5b58\u50a8\u7684\u7f51\u94f6\u8ddf\u8e2a\u53f7\uff1a" + srvrid);
                EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"RegisterNotePayableImpl_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (String)MESSAGE);
            }
        } else {
            Element EBDRAWTRNRS = eb1.getChild("EBDRAWTRNRS");
            Element STATUS = EBDRAWTRNRS.getChild("STATUS");
            String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
            String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
            if (!"0".equals(code)) {
                EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u72b6\u6001\u672a\u77e5", (String)"RegisterNotePayableImpl_2", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (String)MESSAGE);
            } else {
                EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"RegisterNotePayableImpl_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (String)MESSAGE);
            }
        }
        return notePayableInfos;
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968", (String)"RegisterNotePayableImpl_3", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }
}

