/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.note.receivable.discount;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.Common;
import kd.ebg.note.banks.cib.dc.services.note.receivable.discount.QueryDiscountNoteReceivableImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class DiscountNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryDiscountNoteReceivableImpl.class;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List receivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen16Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBDRAWTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"EBDISCNTTRNRQ");
        JDomUtils.addChild((Element)EBDRAWTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBDRAWTRNRQ_RQBODY = JDomUtils.addChild((Element)EBDRAWTRNRQ, (String)"RQBODY");
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"TOTALCOUNT");
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"TOTALAMT");
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"TRADETYPE", (String)"TT00");
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"APPDATE", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"BILLTYPE", (String)info.getDraftType());
        BankAcnt acnt = request.getAcnt();
        Element RQBODY_ACCTFROM = JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"ACCTFROM");
        JDomUtils.addChild((Element)RQBODY_ACCTFROM, (String)"ACCTID", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)RQBODY_ACCTFROM, (String)"NAME", (String)acnt.getAccName());
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"ISCIB", (String)(Common.isSameBank(info.getPayeeBankName(), info.getBankVersionID()) ? "Y" : "N"));
        Element RQBODY_ACCTTO = JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"ACCTTO");
        JDomUtils.addChild((Element)RQBODY_ACCTTO, (String)"ACCTID", (String)"0");
        JDomUtils.addChild((Element)RQBODY_ACCTTO, (String)"NAME", (String)info.getPayeeBankName());
        JDomUtils.addChild((Element)RQBODY_ACCTTO, (String)"BANKNUM", (String)info.getPayeeBankCnaps());
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"DISCNTTYPE", (String)"RM00");
        BigDecimal b1 = new BigDecimal(((NoteReceivableInfo)receivableInfos.get(0)).getDisCountRate());
        BigDecimal b2 = b1.divide(new BigDecimal(1), 6, 4);
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"INTRSTRATE", (String)(b2 + ""));
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"NEGTBL", (String)info.getTransferFlag());
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"MEMO", (String)info.getExplanation());
        if ("0".equals(info.getAutoAccept())) {
            JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"LQMODE", (String)"SM00");
        } else {
            JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"LQMODE", (String)"SM01");
        }
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"INACCTID", (String)info.getPayeeAccNo());
        JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"INBANKNUM", (String)info.getPayeeBankCnaps());
        if ("2".equals(info.getDiscountType())) {
            JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"PAYINTRMODE", (String)"2");
        } else if ("1".equals(info.getDiscountType())) {
            JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"PAYINTRMODE", (String)"1");
        } else {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8d34\u73b0\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38\u3002", (String)"DiscountNoteReceivableImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
        }
        int count = 0;
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (NoteReceivableInfo noteReceivableInfo : receivableInfos) {
            noteReceivableInfo.setRqstserialno(TRNUID);
            Element RQBODY_CONTENT = JDomUtils.addChild((Element)EBDRAWTRNRQ_RQBODY, (String)"CONTENT");
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"INDX", (String)(++count + ""));
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"BILLCODE", (String)noteReceivableInfo.getBillNo());
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"BILLAMT", (String)(noteReceivableInfo.getAmount() + ""));
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"REALPAY", (String)(noteReceivableInfo.getDisCountAmount() + ""));
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"DUEDATE", (String)noteReceivableInfo.getDueDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            BigDecimal amount = noteReceivableInfo.getAmount();
            totalAmt = totalAmt.add(amount);
        }
        JDomUtils.getChildElement((Element)EBDRAWTRNRQ_RQBODY, (String)"TOTALCOUNT").addContent(count + "");
        JDomUtils.getChildElement((Element)EBDRAWTRNRQ_RQBODY, (String)"TOTALAMT").addContent(totalAmt + "");
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List receivableInfos = request.getNoteReceivableInfos();
        Element root = CIB_DC_Parser.parseString2Root(responseStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBDISCNTTRNRS = eb1.getChild("EBDISCNTTRNRS");
        Element STATUS = EBDISCNTTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.FAIL, (String)code, (String)MESSAGE);
        } else {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"DiscountNoteReceivableImpl_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (String)MESSAGE);
        }
        return receivableInfos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public long getBankInterval() {
        return 0L;
    }
}

