/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.util;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Constants;
import org.jdom2.Element;

public class CIB_DC_Parser
implements CIB_DC_Constants {
    public static Element parseString2Root(String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)"GBK");
        return root;
    }

    public static BankResponse parseResponse(Element root) {
        BankResponse rsp = new BankResponse();
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element eb = eb1.getChild("XPMTTRNRS");
        Element pub = eb.getChild("STATUS");
        String recode = pub.getChildTextTrim("CODE");
        String reMessage = pub.getChildTextTrim("MESSAGE");
        String errorMessage = pub.getChildText("MESSAGE");
        rsp.setResponseCode(recode);
        if (StringUtils.isEmpty((String)reMessage)) {
            rsp.setResponseMessage(errorMessage);
        } else {
            rsp.setResponseMessage(reMessage);
        }
        return rsp;
    }

    public static void checkRspCode(BankResponse rsp, String successCode) {
        if (!successCode.equals(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5931\u8d25 \uff0c\u94f6\u884c\u8fd4\u56de \uff1a%1$s %2$s\u3002", (String)"CIB_DC_Parser_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
    }

    public static BankResponse noteParseString2Root(Element root) {
        Element status = root.getChild("SIGNONMSGSRSV1").getChild("SONRS").getChild("STATUS");
        String code = JDomUtils.getChildText((Element)status, (String)"CODE");
        BankResponse bankResponse = new BankResponse();
        bankResponse.setResponseCode(code);
        bankResponse.setResponseMessage("0".equals(code) ? "" : JDomUtils.getChildText((Element)status, (String)"MESSAGE"));
        return bankResponse;
    }
}

