/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmb.opa.service.note.util;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.common.model.CertInfo;
import kd.ebg.note.common.model.repository.CertRepository;
import kd.ebg.note.common.model.repository.UserCertRepository;
import kd.ebg.note.common.utils.SpringContextUtil;
import org.apache.commons.codec.binary.Base64;

public class GetStore {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(GetStore.class);

    public static String getAES() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID("aes_key", RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getCustomId());
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6AES\u79c1\u94a5\u8bc1\u4e66\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6eAES\u79c1\u94a5\u8bc1\u4e66", (String)"GetStore_11", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = GetStore.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return GetStore.getKey(fileContent);
    }

    public static String getBank() {
        CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);
        CertInfo certInfo = certRepository.findPlateFormCertByBankVersionIDAndBankConfigID(RequestContextUtils.getRequestContext().getBankVersionID(), "plateForm_public_certInfo");
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25\uff0c\u8054\u7cfb\u94f6\u4f01\u4e91\u7ba1\u7406\u5458\u914d\u7f6e\u94f6\u884c\u516c\u94a5\u8bc1\u4e66\u3002", (String)"GetStore_1", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = GetStore.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return GetStore.getKey(fileContent);
    }

    public static String getRSA() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID("rsa_key", RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getCustomId());
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6RSA\u79c1\u94a5\u8bc1\u4e66\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6eRSA\u79c1\u94a5\u8bc1\u4e66\u3002", (String)"GetStore_2", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = GetStore.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return GetStore.getKey(fileContent);
    }

    public static String getPlateFormRSA() {
        CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);
        CertInfo certInfo = certRepository.findPlateFormCertByBankVersionIDAndBankConfigID(RequestContextUtils.getRequestContext().getBankVersionID(), "plateForm_private_certInfo");
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25\uff0c\u8054\u7cfb\u94f6\u4f01\u4e91\u7ba1\u7406\u5458\u914d\u7f6e\u5e73\u53f0\u7ea7RSA\u79c1\u94a5\u8bc1\u4e66\u3002", (String)"GetStore_3", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = GetStore.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return GetStore.getKey(fileContent);
    }

    private static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(java.util.Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }

    private static String getKey(byte[] fileContent) {
        return StringUtils.byteToString((byte[])fileContent);
    }
}

