/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.detail;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.banks.ccb.dc.services.note.detail.BusCodeUtil;
import kd.ebg.note.banks.ccb.dc.services.note.detail.endorseinfo.EndorseInfoImpl;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.util.NoteDetailUtil;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import org.jdom2.Element;

public class NoteDetailImpl
extends AbstractNoteDetailImpl {
    public static final int PAGE_SIZE = 200;
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteDetailImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "6WH028";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f85\u5e94\u7b54\u67e5\u8be2", (String)"NoteDetailImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        Integer page;
        Integer n = page = Integer.valueOf(Integer.parseInt(pageTag));
        Integer n2 = page = Integer.valueOf(page + 1);
        return page + "";
    }

    public boolean isLastPage(String rspStr, String pageTag, BankNoteDetailRequest request) {
        boolean flag = false;
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        String rspCode = response.getResponseCode();
        String subBizType = request.getHeader().getSubBizType();
        String pageTotalNumStr = "";
        if ("000000".equals(rspCode)) {
            Element txBody = JDomUtils.getChildElement((Element)root, (String)"TX_INFO");
            if ("revocation".equals(subBizType)) {
                this.logger.info("\u8fdb\u5165\u64a4\u9500\u5206\u9875");
                pageTotalNumStr = JDomUtils.getChildText((Element)txBody, (String)"BkTotNum");
            } else {
                pageTotalNumStr = JDomUtils.getChildText((Element)txBody, (String)"BkTotNum");
            }
            this.logger.info("\u603b\u6570\u4e3a" + pageTotalNumStr);
            if (StringUtils.isEmpty((String)pageTotalNumStr) || "0".equals(pageTotalNumStr)) {
                flag = true;
            } else {
                Integer pageTotalNum = Integer.parseInt(pageTotalNumStr);
                Integer page = Integer.parseInt(pageTag) - 1;
                boolean bl = flag = page * 200 >= pageTotalNum;
                if (pageTotalNum < 200) {
                    flag = true;
                }
            }
        } else {
            flag = true;
        }
        this.logger.info("\u8fdb\u5165\u64a4\u9500\u5206\u9875" + flag);
        return flag;
    }

    public boolean isNeedPage() {
        return true;
    }

    public String pack(BankNoteDetailRequest request, String pageTag) {
        BankAcnt ancAcnt = request.getAcnt();
        return this.packNoteDetailRequset(request, pageTag, ancAcnt);
    }

    public List<Detail> parse(BankNoteDetailRequest request, String responseStr) {
        BankAcnt ancAcnt = request.getAcnt();
        return this.parseNoteInfoDetail(request, responseStr, ancAcnt);
    }

    public String packNoteDetailRequset(BankNoteDetailRequest request, String pageTag, BankAcnt ancAcnt) {
        return this.packQueryReplayRequst(request, pageTag, ancAcnt);
    }

    private String packQueryReplayRequst(BankNoteDetailRequest request, String pageTag, BankAcnt ancAcnt) {
        Element root = CCB_DC_Packer.createTransactionHeader("6WH028", Sequence.gen16NumSequence() + "");
        Element txBody = NoteCommonPacker.createTransactionBody(root, "", "");
        JDomUtils.addChild((Element)txBody, (String)"BkType1", (String)"AC01");
        JDomUtils.addChild((Element)txBody, (String)"Bk8Date1", (String)"");
        String type = request.getBody().getTranType();
        if ("03".equals(type)) {
            type = "0003";
        } else if ("10".equals(type)) {
            type = "0004";
        } else if ("18".equals(type)) {
            type = "0001";
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7684\u67e5\u8be2\u7c7b\u578b%1$s\u3002", (String)"NoteDetailImpl_10", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), NoteDetailUtil.INSTANCE.convert2Bank(type)));
        }
        JDomUtils.addChild((Element)txBody, (String)"BkType2", (String)type);
        JDomUtils.addChild((Element)txBody, (String)"PAGE", (String)pageTag);
        JDomUtils.addChild((Element)txBody, (String)"PAGE_SIZE", (String)"200");
        return NoteCommonPacker.root2StringSafeMod(root);
    }

    public List<Detail> parseNoteInfoDetail(BankNoteDetailRequest rqst, String rspStr, BankAcnt ancAcnt) {
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        String rspCode = response.getResponseCode();
        List<Detail> result = new ArrayList<Detail>();
        if ("000000".equals(rspCode)) {
            Element txBody = JDomUtils.getChildElement((Element)root, (String)"TX_INFO");
            Element detailListNode = JDomUtils.getChildElement((Element)txBody, (String)"DETAILLIST");
            List detailLists = detailListNode.getChildren("DETAILINFO");
            result = this.getDetails(rqst, detailLists, ancAcnt);
        } else if ("0130Z1101002".equals(rspCode)) {
            throw EBExceiptionUtil.serviceException((String)("code :0130Z1101002 msg: " + response.getResponseMessage()));
        }
        return result;
    }

    private List<Detail> getDetails(BankNoteDetailRequest rqst, List<Element> detailLists, BankAcnt ancAcnt) {
        ArrayList<Detail> result = new ArrayList<Detail>();
        for (Element node : detailLists) {
            List<NoteSidesInfo> list;
            EndorseInfoImpl impl;
            Detail info = new Detail();
            String bankCode = JDomUtils.getChildText((Element)node, (String)"BkType2");
            String ebgCode = BusCodeUtil.INSTANCE.convert2Bank(bankCode);
            info.setBusinessCode(ebgCode);
            info.setNoteNo(JDomUtils.getChildText((Element)node, (String)"BkListNo1"));
            info.setApplicantAcName(JDomUtils.getChildText((Element)node, (String)"Bk60Name6"));
            info.setApplicantAcNo(JDomUtils.getChildText((Element)node, (String)"BkAcctNo6"));
            info.setApplicantBankCnaps(JDomUtils.getChildText((Element)node, (String)"BkBrchNo6"));
            info.setExplain(JDomUtils.getChildText((Element)node, (String)"BkDetail1"));
            info.setHolderAccNo(JDomUtils.getChildText((Element)node, (String)"BkAcctNo6"));
            info.setPreHolderName(JDomUtils.getChildText((Element)node, (String)"Bk60Name6"));
            info.setHolderCnapsCode(JDomUtils.getChildText((Element)node, (String)"BkBrchNo6"));
            info.setExplain(JDomUtils.getChildText((Element)node, (String)"BkDetail1"));
            info.setBankRefKey(JDomUtils.getChildText((Element)node, (String)"BkOldSeq"));
            String applicationDateStr = JDomUtils.getChildText((Element)node, (String)"BkOldPlatDate");
            info.setBankRefDate(applicationDateStr);
            info.setDraftType("AC01");
            info.setPayeeAccName(JDomUtils.getChildText((Element)node, (String)"Bk60Name2"));
            String accno = JDomUtils.getChildText((Element)node, (String)"BkAcctNo2");
            info.setPayeeAccNo(JDomUtils.getChildText((Element)node, (String)"BkAcctNo2"));
            info.setPayeeCnapsCode(JDomUtils.getChildText((Element)node, (String)"BkBrchNo2"));
            String remark = JDomUtils.getChildText((Element)node, (String)"Bk60Name8");
            if (!StringUtils.isEmpty((String)remark)) {
                info.setExplain(remark);
            }
            info.setDrawerAccName(JDomUtils.getChildText((Element)node, (String)"Bk60Name1"));
            info.setDrawerAccNo(JDomUtils.getChildText((Element)node, (String)"BkAcctNo1"));
            info.setDrawerCnapsCode(JDomUtils.getChildText((Element)node, (String)"BkBrchNo1"));
            info.setAcceptorAccName(JDomUtils.getChildText((Element)node, (String)"Bk60Name3"));
            info.setAcceptorCnapsCode(JDomUtils.getChildText((Element)node, (String)"BkBrchNo3"));
            String amount = JDomUtils.getChildText((Element)node, (String)"BkAmt1");
            info.setAmount(amount);
            String dueStartDate = JDomUtils.getChildText((Element)node, (String)"Bk8Date1");
            if (!StringUtils.isEmpty((String)dueStartDate)) {
                info.setIssueDate(dueStartDate);
            }
            info.setTransferFlag(JDomUtils.getChildText((Element)node, (String)"BkType3"));
            String dueDate = JDomUtils.getChildText((Element)node, (String)"Bk8Date2");
            info.setDueDate(dueDate);
            String type = rqst.getBody().getTranType();
            String status = "";
            String BkFlag1 = JDomUtils.getChildText((Element)node, (String)"BkFlag1");
            info.setNoteStatus(BkFlag1);
            String BkAcctNo7 = JDomUtils.getChildText((Element)node, (String)"BkAcctNo7");
            if (!BkAcctNo7.equals(ancAcnt.getAccNo())) continue;
            if ("19".equals(type) || "18".equals(type)) {
                if (!"190001".equals(status)) continue;
                result.add(info);
                try {
                    impl = new EndorseInfoImpl();
                    list = impl.getinfo(JDomUtils.getChildText((Element)node, (String)"BkListNo1"));
                    info.setNoteSidesInfo(list);
                }
                catch (Exception e) {
                    info.setIsNoteSidesError("Y");
                }
                continue;
            }
            result.add(info);
            if (!"10".equals(type)) continue;
            try {
                impl = new EndorseInfoImpl();
                list = impl.getinfo(JDomUtils.getChildText((Element)node, (String)"BkListNo1"));
                info.setNoteSidesInfo(list);
            }
            catch (Exception e) {
                info.setIsNoteSidesError("Y");
            }
        }
        return result;
    }
}

