/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.payable.cancle;

import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class QueryCancleNotePayableImpl
extends AbstractQueryNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryCancleNotePayableImpl.class);

    public String pack(BankNotePayableRequest request, String pageTag) {
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        Element header = CCB_DC_Packer.createTransactionHeader("6WH026", info.getBankBatchSeqId());
        Element txBody = NoteCommonPacker.createTransactionBody(header, "", "");
        JDomUtils.addChild((Element)txBody, (String)"BKTYPE", (String)info.getDraftType());
        String signDate4Test = RequestContextUtils.getBankParameterValue((String)"TEST_DATE");
        if (StringUtils.isEmpty((String)signDate4Test)) {
            JDomUtils.addChild((Element)txBody, (String)"Bk10Date1", (String)info.getBookingDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)txBody, (String)"Bk10Date2", (String)DateUtil.formatDate((Date)new Date()));
        } else {
            JDomUtils.addChild((Element)txBody, (String)"Bk10Date1", (String)signDate4Test);
            JDomUtils.addChild((Element)txBody, (String)"Bk10Date2", (String)signDate4Test);
        }
        JDomUtils.addChild((Element)txBody, (String)"Bk8Date3", (String)info.getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)txBody, (String)"Bk8Date4", (String)info.getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)txBody, (String)"Bk60Name1", (String)info.getPayeeAccName());
        JDomUtils.addChild((Element)txBody, (String)"BkAmt1", (String)info.getAmount().toString());
        JDomUtils.addChild((Element)txBody, (String)"BkAmt2", (String)info.getAmount().toString());
        if (info.getBillNo().length() == 30) {
            JDomUtils.addChild((Element)txBody, (String)"BkListNo1", (String)info.getBillNo());
        }
        JDomUtils.addChild((Element)txBody, (String)"BkType2", (String)"0016");
        JDomUtils.addChild((Element)txBody, (String)"PAGE", (String)"1");
        JDomUtils.addChild((Element)txBody, (String)"PAGE_SIZE", (String)"200");
        return NoteCommonPacker.root2StringSafeMod(header);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo notePayableInfo = (NotePayableInfo)notePayableInfos.get(0);
        Element root = CCB_DC_Parser.parseString2Root(responseStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if (!response.getResponseCode().equals("000000")) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            Element txBody = root.getChild("TX_INFO");
            Element detaillist = txBody.getChild("DETAILLIST");
            List lists = detaillist.getChildren("DETAILINFO");
            for (NotePayableInfo info : notePayableInfos) {
                for (Element list : lists) {
                    String BkListNo1 = JDomUtils.getChildTextTrim((Element)list, (String)"BkListNo1");
                    if (!BkListNo1.equals(info.getBillNo())) continue;
                    String BkFlag1 = JDomUtils.getChildTextTrim((Element)list, (String)"BkFlag1");
                    if (BkListNo1.equals(info.getBillNo())) {
                        String BkFlag2 = JDomUtils.getChildTextTrim((Element)list, (String)"BkFlag2");
                        String BkSumry = JDomUtils.getChildTextTrim((Element)list, (String)"BkSumry");
                        if (BkFlag2.equals("00")) {
                            info.setNoteStatus(BkFlag1);
                            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)BkListNo1, (String)ResManager.loadKDString((String)"\u64a4\u9500\u64cd\u4f5c\u6210\u529f", (String)"QueryCancleNotePayableImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                            continue;
                        }
                        if (BkFlag2.equals("22") || BkFlag2.equals("03") || BkFlag2.equals("05") || BkFlag2.equals("09") || BkFlag2.equals("11") || BkFlag2.equals("14") || BkFlag2.equals("23")) {
                            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)BkListNo1, (String)BkSumry);
                            info.setNoteStatus(BkFlag1);
                            continue;
                        }
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)BkListNo1, (String)BkSumry);
                        continue;
                    }
                    this.logger.info("\u8fd4\u56de\u7684\u65e5\u5fd7\u4e2d\u4e0d\u5305\u542b\u5f53\u524d\u7968\u53f7");
                }
            }
        }
        return notePayableInfos;
    }

    public int getBatchSize() {
        return 0;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "6WH026";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }
}

