/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.note.common.utils.PropertiesConstantsUtils;

public class AcntNumberHelper {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(AcntNumberHelper.class);
    private static Map<String, String> provinceCodes = new HashMap<String, String>(16);

    public static String fixAccNoTo15Or19(String accNo) {
        String retAccNo = null;
        if (null != accNo) {
            String str2 = accNo.trim();
            retAccNo = str2.length() == 19 ? accNo : (str2.length() == 21 ? str2.substring(2) : AcntNumberHelper.getLastNString(str2, 15));
        }
        logger.info("SrcAcnt:" + accNo + ", RetAcnt:" + retAccNo);
        return retAccNo;
    }

    private static String getLastNString(String accNo, int count) {
        String str = accNo;
        if (accNo.length() > count) {
            int i = accNo.length() - count;
            str = accNo.substring(i);
        }
        return str;
    }

    public static String getPrefix2AsAreaCode(String accNo) {
        String retP2 = accNo;
        if (null != accNo && accNo.length() >= 2) {
            retP2 = accNo.substring(0, 2);
        }
        logger.info("SrcAcnt:" + accNo + ", Prefix2AsAreaCode:" + retP2);
        return retP2;
    }

    public static String getAreaCodeByAcnt(BankAcnt acnt) {
        return AcntNumberHelper.getAreaCode(acnt.getAreaCode(), acnt.getCity(), acnt.getProvince(), acnt.getAccNo());
    }

    private static String getAreaCode(String areaCode, String city, String provice, String accNo) {
        if (!StrUtil.isEmpty((String)areaCode)) {
            return areaCode.trim();
        }
        String resultAreaCode = null;
        if (!StrUtil.isEmpty((String)city)) {
            if (city.contains(ResManager.loadKDString((String)"\u6d77\u5357\u85cf\u65cf\u81ea\u6cbb\u5dde", (String)"AcntNumberHelper_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]))) {
                return "28";
            }
            resultAreaCode = AcntNumberHelper.getCode(city.trim());
        }
        if (!StrUtil.isEmpty(resultAreaCode)) {
            return resultAreaCode;
        }
        if (!StrUtil.isEmpty((String)provice)) {
            resultAreaCode = AcntNumberHelper.getCode(provice.trim());
        }
        if (!StrUtil.isEmpty(resultAreaCode)) {
            return resultAreaCode;
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u5e73\u53f0\u6821\u9a8c\u4e0d\u901a\u8fc7\uff1a\u8d26\u53f7[%s]\u7684\u5730\u533a\u7801\u4e3a\u7a7a\uff0c\u4e1a\u52a1\u65e0\u6cd5\u8fdb\u884c\u3002\u8bf7\u7ef4\u62a4\u8be5\u8d26\u53f7\u7684\u5730\u533a\u7801\u3002", (String)"AcntNumberHelper_44", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), accNo));
    }

    private static String getCode(String provinceOrCity) {
        if (StrUtil.isEmpty((String)provinceOrCity)) {
            return "";
        }
        for (Map.Entry<String, String> entry : provinceCodes.entrySet()) {
            String pName = entry.getValue();
            String pCode = entry.getKey();
            if (-1 == provinceOrCity.indexOf(pName)) continue;
            return pCode;
        }
        return "";
    }

    public static String getFullAccNo(BankAcnt acnt) {
        String fixedAccNo = AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo());
        String areaCode = acnt.getAreaCode();
        StringBuilder sBuffer = new StringBuilder();
        if (!StrUtil.isEmpty((String)areaCode)) {
            sBuffer.append(areaCode);
        }
        sBuffer.append(fixedAccNo);
        return sBuffer.toString();
    }

    static {
        provinceCodes.put("02", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_3"));
        provinceCodes.put("04", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_4"));
        provinceCodes.put("05", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_5"));
        provinceCodes.put("06", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_6"));
        provinceCodes.put("07", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_7"));
        provinceCodes.put("08", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_8"));
        provinceCodes.put("03", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_9"));
        provinceCodes.put("10", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_10"));
        provinceCodes.put("11", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_11"));
        provinceCodes.put("12", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_12"));
        provinceCodes.put("13", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_13"));
        provinceCodes.put("14", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_14"));
        provinceCodes.put("15", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_15"));
        provinceCodes.put("16", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_16"));
        provinceCodes.put("17", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_17"));
        provinceCodes.put("18", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_18"));
        provinceCodes.put("19", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_19"));
        provinceCodes.put("20", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_20"));
        provinceCodes.put("21", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_21"));
        provinceCodes.put("22", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_22"));
        provinceCodes.put("23", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_23"));
        provinceCodes.put("24", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_24"));
        provinceCodes.put("25", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_25"));
        provinceCodes.put("26", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_26"));
        provinceCodes.put("27", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_27"));
        provinceCodes.put("28", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_28"));
        provinceCodes.put("29", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_29"));
        provinceCodes.put("30", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_30"));
        provinceCodes.put("31", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_31"));
        provinceCodes.put("34", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_32"));
        provinceCodes.put("38", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_33"));
        provinceCodes.put("39", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_34"));
        provinceCodes.put("40", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_35"));
        provinceCodes.put("41", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_36"));
        provinceCodes.put("44", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_37"));
        provinceCodes.put("50", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_38"));
        provinceCodes.put("71", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_39"));
        provinceCodes.put("81", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_40"));
        provinceCodes.put("97", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_41"));
        provinceCodes.put("98", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_42"));
        provinceCodes.put("99", PropertiesConstantsUtils.getValue((String)"AcntNumberHelper_43"));
    }
}

