/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.note.noteinfo;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.business.noteinfo.atomic.AbstractNoteInfoImpl;
import kd.ebg.note.business.noteinfo.bank.BankNoteInfoBody;
import kd.ebg.note.business.noteinfo.bank.BankNoteInfoRequest;
import kd.ebg.note.business.noteinfo.bank.EBBankNoteInfoResponse;
import kd.ebg.note.common.entity.biz.noteinfo.NoteInfoDetail;
import kd.ebg.note.common.entity.biz.noteinfo.NoteInfoRequest;
import org.jdom2.Element;

public class OldNoteInfoImpl
extends AbstractNoteInfoImpl {
    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CQRD80";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d34\u73b0\u5b9e\u4ed8\u91d1\u989d\u8bd5\u7b97\u62a5\u6587", (String)"NoteInfoImpl_10", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteInfoRequest noteInfoRequest) {
        return !"0".equals(noteInfoRequest.getBody().getIsNewECDS());
    }

    public String pack(BankNoteInfoRequest request) {
        BankAcnt acnt = request.getAcnt();
        List details = request.getBody().getDetails();
        NoteInfoDetail detail = (NoteInfoDetail)details.get(0);
        Element root = ABC_DC_Packer.createABCRoot4New("CQRT12");
        Element hermes = CommNotePacker.packNoteHeader(root, "0112");
        Element cmp = CommNotePacker.packCmpElement(root, acnt);
        Element dscnt = JDomUtils.addChild((Element)hermes, (String)"Dscnt");
        JDomUtils.addChild((Element)dscnt, (String)"AppDat", (String)DateUtil.formatTime4yyyyMMdd((Date)new Date()));
        BigDecimal discountRate = new BigDecimal(detail.getDiscountRate());
        BigDecimal bigDecimal100 = new BigDecimal("100");
        discountRate = discountRate.divide(bigDecimal100);
        JDomUtils.addChild((Element)dscnt, (String)"Rate", (String)discountRate.setScale(6).toString());
        Element eblist = JDomUtils.addChild((Element)root, (String)"EBList");
        for (NoteInfoDetail noteInfo : details) {
            Element ebinfo = JDomUtils.addChild((Element)eblist, (String)"EBInfo");
            JDomUtils.addChild((Element)ebinfo, (String)"IdNb", (String)noteInfo.getNoteNo());
            JDomUtils.addChild((Element)ebinfo, (String)"BillAmt", (String)noteInfo.getAmount());
            JDomUtils.addChild((Element)ebinfo, (String)"BillTyp", (String)noteInfo.getDraftType());
            try {
                Date dueDate = DateTimeUtils.parseDate((String)noteInfo.getDueDate(), (String)"yyyyMMdd");
                JDomUtils.addChild((Element)ebinfo, (String)"DueDat", (String)DateTimeUtils.format((Date)dueDate, (String)"yyyy-MM-dd"));
            }
            catch (ParseException e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3002", (String)"OldNoteInfoImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
            }
        }
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankNoteInfoResponse parse(BankNoteInfoRequest request, String rspStr) {
        List details = request.getBody().getDetails();
        NoteInfoDetail detail = (NoteInfoDetail)details.get(0);
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (!"0000".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7535\u7968\u8d34\u73b0\u5b9e\u4ed8\u91d1\u989d\u5931\u8d25\u3002%s", (String)"ReceivableDiscountAmountNoteImpl_6", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), rsp.getResponseMessage()));
        }
        Element hermes = JDomUtils.getChildElement((Element)root, (String)"Hermes");
        String totalAmountStr = JDomUtils.getChildText((Element)hermes, (String)"TotalPayAmt");
        if (StringUtils.isEmpty((String)totalAmountStr) || "0".equals(totalAmountStr)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7535\u7968\u8d34\u73b0\u5b9e\u4ed8\u91d1\u989d\u5931\u8d25\u3002%s", (String)"ReceivableDiscountAmountNoteImpl_6", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), rsp.getResponseMessage()));
        }
        Element eblist = JDomUtils.getChildElement((Element)root, (String)"EBList");
        List ebInfos = eblist.getChildren("EBInfo");
        for (Element element : ebInfos) {
            String idNb = JDomUtils.getChildTextNotNull((Element)element, (String)"IdNb");
            String payAmnt = JDomUtils.getChildText((Element)element, (String)"PayAmt");
            detail.setDiscountAmount(payAmnt);
        }
        EBBankNoteInfoResponse response1 = new EBBankNoteInfoResponse();
        BankNoteInfoBody infoDetail = request.getBody();
        response1.setBody(infoDetail);
        infoDetail.setDetails(details);
        return response1;
    }

    public int getBatchSize() {
        return 1;
    }
}

