/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.note.receivable.pledge;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.note.receivable.pledge.QueryPledheNoteReceivableImpl;
import kd.ebg.note.banks.abc.dc.utils.MatchUtils;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class PledgeNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryPledheNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "CFRT60";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d28\u62bc\u7533\u8bf7", (String)"PledgeNoteReceivableImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        BankAcnt acnt = RequestContextUtils.getRequestContext().getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CFRT60");
        Element hermes = CommNotePacker.packNoteHeader(root, "0180");
        NoteReceivableInfo info = (NoteReceivableInfo)noteReceivableInfos.get(0);
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)acnt.getAreaCode());
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)info.getCurrency());
        JDomUtils.addChild((Element)root, (String)"Amt", (String)info.getAmount().setScale(2).toString());
        if (MatchUtils.isSameBank(info) && info.getPayeeAccNo().length() == 15) {
            String areaCode = MatchUtils.getAreaCode(info);
            JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)(areaCode + info.getPayeeAccNo()));
            JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)areaCode);
        } else {
            JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)info.getPayeeAccNo());
            JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)"");
        }
        Element ebinfo = JDomUtils.addChild((Element)hermes, (String)"EBInfo");
        JDomUtils.addChild((Element)ebinfo, (String)"IdNb", (String)info.getBillNo());
        JDomUtils.addChild((Element)ebinfo, (String)"BillTyp", (String)info.getDraftType());
        String issuedate = info.getIssueDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        JDomUtils.addChild((Element)ebinfo, (String)"IssDat", (String)issuedate);
        String duedate = info.getDueDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        JDomUtils.addChild((Element)ebinfo, (String)"DueDat", (String)duedate);
        if (!StringUtils.isEmpty((String)info.getContractNo())) {
            JDomUtils.addChild((Element)ebinfo, (String)"ContNo", (String)info.getContractNo());
        }
        Element collztnbk = JDomUtils.addChild((Element)hermes, (String)"CollztnBk");
        JDomUtils.addChild((Element)collztnbk, (String)"CbNam", (String)acnt.getAccName());
        JDomUtils.addChild((Element)collztnbk, (String)"CbOpBnk", (String)acnt.getCnaps());
        JDomUtils.addChild((Element)collztnbk, (String)"CbOpBnkNam", (String)acnt.getBankName());
        JDomUtils.addChild((Element)collztnbk, (String)"CpsrTyp", (String)"RC01");
        Element collztnpropsr = JDomUtils.addChild((Element)hermes, (String)"CollztnPropsr");
        JDomUtils.addChild((Element)collztnpropsr, (String)"CpsrNam", (String)info.getPayeeAccName());
        JDomUtils.addChild((Element)collztnpropsr, (String)"CpsrTyp", (String)"RC01");
        JDomUtils.addChild((Element)collztnpropsr, (String)"CpsrOpBnk", (String)info.getPayeeBankCnaps());
        JDomUtils.addChild((Element)collztnpropsr, (String)"CpsrOpBnkNam", (String)info.getPayeeBankName());
        JDomUtils.addChild((Element)hermes, (String)"BatchNo", (String)info.getBankBatchSeqId());
        JDomUtils.addChild((Element)hermes, (String)"Note", (String)info.getExplanation());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        CommNotePacker.parserNoteReq(noteReceivableInfos, responseStr);
        return noteReceivableInfos;
    }
}

