/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.cmp.service.note.payable.register;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.icbc.cmp.service.note.payable.register.QueryRegisterNotePayableImpl;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_NoteParser;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_Packer;
import kd.ebg.note.banks.icbc.cmp.service.note.util.NewNoteUtil;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.bank.EBBankNotePayableResponse;
import kd.ebg.note.common.framework.utils.ParserUtils;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class RegisterNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(RegisterNotePayableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryRegisterNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "BIBANK";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968\u5904\u7406", (String)"RegisterNotePayableImpl_0", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        NotePayableInfo[] notePayableInfos = request.getNotePayableInfosAsArray();
        NotePayableInfo notePayableInfo = notePayableInfos[0];
        this.logger.info("register.amount:" + notePayableInfo.getAmount());
        this.logger.info("register.amount:" + ParserUtils.convertCentStr2Yuan((String)notePayableInfo.getAmount().toString()).toString());
        String DraftType = notePayableInfo.getDraftType();
        String TransCode = "";
        if (DraftType.equals("AC01")) {
            TransCode = "BIBANK";
        } else if (DraftType.equals("AC02")) {
            TransCode = "BICORP";
        }
        Element root = ICBC_CMP_Packer.createICBCCMPRootForPay(TransCode, notePayableInfo.getBankBatchSeqId());
        Element eb = JDomUtils.getChildElement((Element)root, (String)"eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"BillType", (String)notePayableInfo.getDraftType());
        JDomUtils.addChild((Element)in, (String)"BillAmt", (String)ParserUtils.convertYuan2CentStr((BigDecimal)notePayableInfo.getAmount()));
        String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
        boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
        if (isProduct) {
            JDomUtils.addChild((Element)in, (String)"BillOpenDate", (String)DateUtil.formatDate((Date)new Date()));
        } else {
            JDomUtils.addChild((Element)in, (String)"BillOpenDate", (String)signDate4Test);
        }
        JDomUtils.addChild((Element)in, (String)"BillDueDate", (String)notePayableInfo.getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)in, (String)"ReciteFlag", (String)notePayableInfo.getTransferFlag());
        JDomUtils.addChild((Element)in, (String)"AccNo", (String)notePayableInfo.getDrawerAccNo());
        JDomUtils.addChild((Element)in, (String)"AccName", (String)notePayableInfo.getDrawerAccName());
        if (DraftType.equals("AC02")) {
            JDomUtils.addChild((Element)in, (String)"AcceptBranch", (String)"");
        } else {
            String num = notePayableInfo.getDrawerAccNo().substring(0, 8);
            if (num.equalsIgnoreCase("11020275")) {
                num = "11020270";
            }
            JDomUtils.addChild((Element)in, (String)"AcceptBranch", (String)num);
        }
        if (DraftType.equals("AC01")) {
            JDomUtils.addChild((Element)in, (String)"TranType", (String)"0");
            JDomUtils.addChild((Element)in, (String)"AgreeNo", (String)"");
        } else {
            JDomUtils.addChild((Element)in, (String)"TranType", (String)"");
            JDomUtils.addChild((Element)in, (String)"AgreeNo", (String)"");
        }
        JDomUtils.addChild((Element)in, (String)"RecAccName", (String)notePayableInfo.getPayeeAccName());
        boolean isSameBank = false;
        if (notePayableInfo.getPayeeBankName() != null && SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)notePayableInfo.getPayeeBankName()).equals("1")) {
            isSameBank = true;
        }
        if (isSameBank) {
            JDomUtils.addChild((Element)in, (String)"SysFlag", (String)"1");
        } else {
            JDomUtils.addChild((Element)in, (String)"SysFlag", (String)"0");
        }
        JDomUtils.addChild((Element)in, (String)"RecBankName", (String)notePayableInfo.getPayeeBankName());
        JDomUtils.addChild((Element)in, (String)"RecCityName", (String)notePayableInfo.getPayeeCity());
        JDomUtils.addChild((Element)in, (String)"RecBankNo", (String)notePayableInfo.getPayeeBankCnaps().trim());
        JDomUtils.addChild((Element)in, (String)"RecAccNo", (String)notePayableInfo.getPayeeAccNo());
        boolean AccptFlag = true;
        if (!StringUtils.equals((String)notePayableInfo.getDrawerAccNo(), (String)notePayableInfo.getAcceptorAccNo())) {
            AccptFlag = false;
        }
        if (AccptFlag) {
            JDomUtils.addChild((Element)in, (String)"AccptFlag", (String)"1");
            JDomUtils.addChild((Element)in, (String)"AccptrAccName", (String)"");
            JDomUtils.addChild((Element)in, (String)"AccptrAccNo", (String)"");
            JDomUtils.addChild((Element)in, (String)"AccptrIsIcbc", (String)"");
            JDomUtils.addChild((Element)in, (String)"AccptrBankName", (String)"");
            JDomUtils.addChild((Element)in, (String)"AccptrBankNo", (String)"");
        } else {
            JDomUtils.addChild((Element)in, (String)"AccptFlag", (String)"2");
            JDomUtils.addChild((Element)in, (String)"AccptrAccName", (String)notePayableInfo.getAcceptorAccName());
            JDomUtils.addChild((Element)in, (String)"AccptrAccNo", (String)notePayableInfo.getAcceptorAccNo());
            boolean isSameBankAccept = false;
            if (notePayableInfo.getAcceptorBankName() != null && SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)notePayableInfo.getAcceptorBankName()).equals("1")) {
                isSameBankAccept = true;
            }
            if (isSameBankAccept) {
                JDomUtils.addChild((Element)in, (String)"AccptrIsIcbc", (String)"1");
            } else {
                JDomUtils.addChild((Element)in, (String)"AccptrIsIcbc", (String)"0");
            }
            JDomUtils.addChild((Element)in, (String)"AccptrBankName", (String)notePayableInfo.getAcceptorBankName());
            JDomUtils.addChild((Element)in, (String)"AccptrBankNo", (String)notePayableInfo.getAcceptorBankCnaps().trim());
        }
        JDomUtils.addChild((Element)in, (String)"AccptrAddr", (String)"");
        JDomUtils.addChild((Element)in, (String)"GuarntFlag", (String)"0");
        JDomUtils.addChild((Element)in, (String)"GuarntrAccName", (String)"");
        JDomUtils.addChild((Element)in, (String)"GuarntrAccNo", (String)"");
        JDomUtils.addChild((Element)in, (String)"GuarntrIsIcbc", (String)"");
        JDomUtils.addChild((Element)in, (String)"GuarntrBankName", (String)"");
        JDomUtils.addChild((Element)in, (String)"GuarntrBankNo", (String)"");
        JDomUtils.addChild((Element)in, (String)"GuarntrAddr", (String)"");
        JDomUtils.addChild((Element)in, (String)"AutoFlag", (String)"0");
        JDomUtils.addChild((Element)in, (String)"SignFlag", (String)"1");
        JDomUtils.addChild((Element)in, (String)"ContractNo", (String)"");
        JDomUtils.addChild((Element)in, (String)"UseCN", (String)"");
        JDomUtils.addChild((Element)in, (String)"RepayAcct", (String)"");
        JDomUtils.addChild((Element)in, (String)"Remark", (String)notePayableInfo.getExplanation());
        JDomUtils.addChild((Element)in, (String)"RefNo", (String)notePayableInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)in, (String)"FileName", (String)"");
        JDomUtils.addChild((Element)in, (String)"FileSeq", (String)"");
        JDomUtils.addChild((Element)in, (String)"SMSFlag", (String)"");
        JDomUtils.addChild((Element)in, (String)"RecList", (String)"");
        JDomUtils.addChild((Element)in, (String)"PhoneList", (String)"");
        if (isProduct) {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS"));
        } else {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)(signDate4Test + DateTimeUtils.format((Date)new Date(), (String)"HHmmssSSS")));
        }
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String reqstMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String msgSigned = ICBC_CMP_Packer.sign(reqstMsg);
        return ICBC_CMP_Packer.createMessageWithHeadNew(msgSigned, TransCode);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        ICBC_CMP_NoteParser.parsePayable(notePayableInfos, responseStr);
        return notePayableInfos;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/servlet/ICBCCMPAPIReqServlet");
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public EBBankNotePayableResponse doBiz(BankNotePayableRequest request) {
        NotePayableInfo notePayableInfo = (NotePayableInfo)request.getNotePayableInfoList().get(0);
        if (notePayableInfo.getIsNewECDS().equals("0")) {
            NewNoteUtil.changeExcontext();
            kd.ebg.note.banks.icbc.opa.service.note.payable.register.RegisterNotePayableImpl impl = new kd.ebg.note.banks.icbc.opa.service.note.payable.register.RegisterNotePayableImpl();
            return impl.doBiz(request);
        }
        return super.doBiz(request);
    }
}

