/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.cmp.service.note.receivable.cancle;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.icbc.cmp.service.note.receivable.cancle.QueryCancleNoteReceivableImpl;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_NoteParser;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_Packer;
import kd.ebg.note.banks.icbc.cmp.service.note.util.NewNoteUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.bank.EBBankNoteReceivableResponse;
import kd.ebg.note.common.framework.utils.ParserUtils;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class CancleNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(CancleNoteReceivableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryCancleNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u7533\u8bf7\u64a4\u56de", (String)"CancleNoteReceivableImpl_0", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        NoteReceivableInfo[] receivableInfos = request.getNotePayableInfosAsArray();
        String operationCode = receivableInfos[0].getOperationCode();
        if ("02".equals(operationCode)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u4e0d\u652f\u6301\u63d0\u793a\u627f\u5151\u64a4\u56de\u3002", (String)"CancleNoteReceivableImpl_1", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        }
        if ("03".equals(operationCode)) {
            return CancleNoteReceivableImpl.packPay(receivableInfos, "BCPCOL");
        }
        if ("10".equals(operationCode)) {
            return CancleNoteReceivableImpl.packPay(receivableInfos, "BCENDO");
        }
        if ("11".equals(operationCode)) {
            return CancleNoteReceivableImpl.packPay(receivableInfos, "BCDISC");
        }
        if ("20".equals(operationCode)) {
            return CancleNoteReceivableImpl.packPay(receivableInfos, "BCPPAY");
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6682\u65f6\u4e0d\u652f\u6301\u7684\u64a4\u9500\u7c7b\u578b\u3002", (String)"CancleNoteReceivableImpl_2", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
    }

    public static String packPay(NoteReceivableInfo[] noteReceivableInfos, String transCode) {
        NoteReceivableInfo noteReceivableInfo = noteReceivableInfos[0];
        Element root = ICBC_CMP_Packer.createICBCCMPRootForPay(transCode, noteReceivableInfo.getBankBatchSeqId());
        Element eb = JDomUtils.getChildElement((Element)root, (String)"eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"BillNo", (String)noteReceivableInfo.getBillNo());
        JDomUtils.addChild((Element)in, (String)"BillOpenName", (String)noteReceivableInfo.getRegisterNmae());
        JDomUtils.addChild((Element)in, (String)"BillOpenAcc", (String)noteReceivableInfo.getRegisterAcno());
        JDomUtils.addChild((Element)in, (String)"AccNo", (String)noteReceivableInfo.getDrawerAccNo());
        JDomUtils.addChild((Element)in, (String)"BillAmt", (String)ParserUtils.convertYuan2CentStr((BigDecimal)noteReceivableInfo.getAmount()));
        JDomUtils.addChild((Element)in, (String)"SignFlag", (String)noteReceivableInfo.getOtherInfo());
        JDomUtils.addChild((Element)in, (String)"Addr", (String)"");
        JDomUtils.addChild((Element)in, (String)"RejectReason", (String)"");
        JDomUtils.addChild((Element)in, (String)"RejectRemark", (String)"");
        JDomUtils.addChild((Element)in, (String)"SMSFlag", (String)"");
        JDomUtils.addChild((Element)in, (String)"RecList", (String)"");
        JDomUtils.addChild((Element)in, (String)"PhoneList", (String)"");
        String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
        boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
        if (isProduct) {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS"));
        } else {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)(signDate4Test + DateTimeUtils.format((Date)new Date(), (String)"HHmmssSSS")));
        }
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String reqstMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String msgSigned = ICBC_CMP_Packer.sign(reqstMsg);
        return ICBC_CMP_Packer.createMessageWithHead(msgSigned, transCode);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        ICBC_CMP_NoteParser.parsePay(noteReceivableInfos, responseStr);
        return noteReceivableInfos;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/servlet/ICBCCMPAPIReqServlet");
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public EBBankNoteReceivableResponse doBiz(BankNoteReceivableRequest request) {
        NoteReceivableInfo info = (NoteReceivableInfo)request.getNoteReceivableInfos().get(0);
        if (info.getIsNewECDS().equals("0")) {
            NewNoteUtil.changeExcontext();
            kd.ebg.note.banks.icbc.opa.service.note.receivable.cancle.CancleNoteReceivableImpl impl = new kd.ebg.note.banks.icbc.opa.service.note.receivable.cancle.CancleNoteReceivableImpl();
            return impl.doBiz(request);
        }
        return super.doBiz(request);
    }
}

