/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.cmp.service.note.receivable.payment;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.icbc.cmp.service.note.receivable.payment.QueryPaymentNoteReceivableImpl;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_NoteParser;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_Packer;
import kd.ebg.note.banks.icbc.cmp.service.note.util.NewNoteUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.bank.EBBankNoteReceivableResponse;
import kd.ebg.note.common.framework.utils.ParserUtils;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class PaymentNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryPaymentNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "BIPPAY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u63d0\u793a\u4ed8\u6b3e", (String)"PaymentNoteReceivableImpl_0", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo receivableInfo = (NoteReceivableInfo)noteReceivableInfos.get(0);
        String TransCode = "BIPPAY";
        Element root = ICBC_CMP_Packer.createICBCCMPRootForPay(TransCode, receivableInfo.getBankBatchSeqId());
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"BillNo", (String)receivableInfo.getBillNo());
        JDomUtils.addChild((Element)in, (String)"BillOpenName", (String)receivableInfo.getRegisterNmae());
        JDomUtils.addChild((Element)in, (String)"BillOpenAcc", (String)receivableInfo.getRegisterAcno());
        JDomUtils.addChild((Element)in, (String)"AccNo", (String)receivableInfo.getDrawerAccNo());
        JDomUtils.addChild((Element)in, (String)"BillAmt", (String)ParserUtils.convertYuan2CentStr((BigDecimal)receivableInfo.getAmount()));
        JDomUtils.addChild((Element)in, (String)"DueFlag", (String)"");
        JDomUtils.addChild((Element)in, (String)"ValueDate", (String)"");
        String name = receivableInfo.getAcceptorBankName();
        if (name.contains(ResManager.loadKDString((String)"\u5de5\u5546\u94f6\u884c", (String)"PaymentNoteReceivableImpl_1", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0])) || name.contains(ResManager.loadKDString((String)"\u4e2d\u56fd\u5de5\u5546\u94f6\u884c", (String)"PaymentNoteReceivableImpl_2", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0])) || name.contains(ResManager.loadKDString((String)"\u5de5\u884c", (String)"PaymentNoteReceivableImpl_3", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]))) {
            JDomUtils.addChild((Element)in, (String)"OnlineFlag", (String)"SM01");
        } else {
            JDomUtils.addChild((Element)in, (String)"OnlineFlag", (String)receivableInfo.getOtherInfo());
        }
        JDomUtils.addChild((Element)in, (String)"Reason", (String)receivableInfo.getExplanation());
        JDomUtils.addChild((Element)in, (String)"SMSFlag", (String)"");
        JDomUtils.addChild((Element)in, (String)"RecList", (String)"");
        JDomUtils.addChild((Element)in, (String)"PhoneList", (String)"");
        String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
        if (StringUtils.isEmpty((String)signDate4Test)) {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS"));
        } else {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)(signDate4Test + DateTimeUtils.format((Date)new Date(), (String)"HHmmssSSS")));
        }
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String reqstMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String msgSigned = ICBC_CMP_Packer.sign(reqstMsg);
        return ICBC_CMP_Packer.createMessageWithHead(msgSigned, TransCode);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        ICBC_CMP_NoteParser.parsePay(noteReceivableInfos, responseStr);
        return noteReceivableInfos;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/servlet/ICBCCMPAPIReqServlet");
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public EBBankNoteReceivableResponse doBiz(BankNoteReceivableRequest request) {
        NoteReceivableInfo info = (NoteReceivableInfo)request.getNoteReceivableInfos().get(0);
        if (info.getIsNewECDS().equals("0")) {
            NewNoteUtil.changeExcontext();
            kd.ebg.note.banks.icbc.opa.service.note.receivable.payment.PaymentNoteReceivableImpl impl = new kd.ebg.note.banks.icbc.opa.service.note.receivable.payment.PaymentNoteReceivableImpl();
            return impl.doBiz(request);
        }
        return super.doBiz(request);
    }
}

