/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.cmp.service.note.receivable.signin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.icbc.cmp.service.note.receivable.signin.QuerySigninNoteReceivableImpl;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_NoteParser;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_Packer;
import kd.ebg.note.banks.icbc.cmp.service.note.util.NewNoteUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.bank.EBBankNoteReceivableResponse;
import kd.ebg.note.common.framework.utils.ParserUtils;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class SigninNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QuerySigninNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u7b7e\u6536", (String)"SigninNoteReceivableImpl_0", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo noteReceivableInfo = (NoteReceivableInfo)noteReceivableInfos.get(0);
        String code = noteReceivableInfo.getOperationCode();
        String TransCode = "BSPCOL";
        if ("10".equals(code)) {
            TransCode = "BSENDO";
        } else if ("20".equals(code)) {
            TransCode = "BSPPAY";
        } else if ("02".equals(code)) {
            TransCode = "BSACPT";
        }
        if ("02".equals(code)) {
            Element root = ICBC_CMP_Packer.createICBCCMPRootForPay(TransCode, noteReceivableInfo.getBankBatchSeqId());
            Element eb = JDomUtils.getChildElement((Element)root, (String)"eb");
            Element in = JDomUtils.addChild((Element)eb, (String)"in");
            JDomUtils.addChild((Element)in, (String)"TotalNum", (String)"1");
            JDomUtils.addChild((Element)in, (String)"TotalAmt", (String)noteReceivableInfo.getAmount().toString());
            String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
            if (StringUtils.isEmpty((String)signDate4Test)) {
                JDomUtils.addChild((Element)in, (String)"SignTime", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS"));
            } else {
                JDomUtils.addChild((Element)in, (String)"SignTime", (String)(signDate4Test + DateTimeUtils.format((Date)new Date(), (String)"HHmmssSSS")));
            }
            Element rd = JDomUtils.addChild((Element)in, (String)"rd");
            JDomUtils.addChild((Element)rd, (String)"iSeqno", (String)"1");
            JDomUtils.addChild((Element)rd, (String)"BillNo", (String)noteReceivableInfo.getBillNo());
            JDomUtils.addChild((Element)rd, (String)"BillSerialNo", (String)"");
            JDomUtils.addChild((Element)rd, (String)"BillOpener", (String)noteReceivableInfo.getRegisterNmae());
            JDomUtils.addChild((Element)rd, (String)"BillOpenAcct", (String)noteReceivableInfo.getRegisterAcno());
            JDomUtils.addChild((Element)rd, (String)"Account", (String)noteReceivableInfo.getDrawerAccNo());
            JDomUtils.addChild((Element)rd, (String)"BillAmt", (String)ParserUtils.convertYuan2CentStr((BigDecimal)noteReceivableInfo.getAmount()));
            JDomUtils.addChild((Element)rd, (String)"IfDateHintTicket", (String)"2");
            JDomUtils.addChild((Element)rd, (String)"HintTicketDate", (String)"");
            JDomUtils.addChild((Element)rd, (String)"IfDatePayHint", (String)"2");
            JDomUtils.addChild((Element)rd, (String)"PayHintDate", (String)"");
            JDomUtils.addChild((Element)rd, (String)"DrwguarntrAddress", (String)"");
            JDomUtils.addChild((Element)rd, (String)"AccptrCreditLV", (String)"");
            JDomUtils.addChild((Element)rd, (String)"AccptrRateAgency", (String)"");
            JDomUtils.addChild((Element)rd, (String)"AccptrRateMaturity", (String)"");
            JDomUtils.addChild((Element)rd, (String)"Notes", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ProtestReason", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ProtestNotes", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ByResourcerName", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ByResourcerAcct", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ByResourcerBank", (String)"");
            JDomUtils.addChild((Element)rd, (String)"IfMessage", (String)"");
            JDomUtils.addChild((Element)rd, (String)"MessagRange", (String)"");
            JDomUtils.addChild((Element)rd, (String)"PhoneNOList", (String)"");
            String encoding = RequestContextUtils.getCharset();
            String reqstMsg = JDomUtils.root2String((Element)root, (String)encoding);
            String msgSigned = ICBC_CMP_Packer.sign(reqstMsg);
            return ICBC_CMP_Packer.createMessageWithHeadNew(msgSigned, TransCode);
        }
        Element root = ICBC_CMP_Packer.createICBCCMPRootForPay(TransCode, noteReceivableInfo.getBankBatchSeqId());
        Element eb = JDomUtils.getChildElement((Element)root, (String)"eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"BillNo", (String)noteReceivableInfo.getBillNo());
        JDomUtils.addChild((Element)in, (String)"BillOpenName", (String)noteReceivableInfo.getRegisterNmae());
        JDomUtils.addChild((Element)in, (String)"BillOpenAcc", (String)noteReceivableInfo.getRegisterAcno());
        JDomUtils.addChild((Element)in, (String)"AccNo", (String)noteReceivableInfo.getDrawerAccNo());
        JDomUtils.addChild((Element)in, (String)"BillAmt", (String)ParserUtils.convertYuan2CentStr((BigDecimal)noteReceivableInfo.getAmount()));
        JDomUtils.addChild((Element)in, (String)"SignFlag", (String)noteReceivableInfo.getOtherInfo());
        if ("SU00".equals(noteReceivableInfo.getOtherInfo())) {
            JDomUtils.addChild((Element)in, (String)"Addr", (String)"");
            JDomUtils.addChild((Element)in, (String)"RejectReason", (String)"");
            JDomUtils.addChild((Element)in, (String)"RejectRemark", (String)"");
        } else {
            JDomUtils.addChild((Element)in, (String)"Addr", (String)"");
            JDomUtils.addChild((Element)in, (String)"RejectReason", (String)"DC08");
            JDomUtils.addChild((Element)in, (String)"RejectRemark", (String)"");
        }
        JDomUtils.addChild((Element)in, (String)"SMSFlag", (String)"");
        JDomUtils.addChild((Element)in, (String)"RecList", (String)"");
        JDomUtils.addChild((Element)in, (String)"PhoneList", (String)"");
        String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
        if (StringUtils.isEmpty((String)signDate4Test)) {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS"));
        } else {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)(signDate4Test + DateTimeUtils.format((Date)new Date(), (String)"HHmmssSSS")));
        }
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String reqstMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String msgSigned = ICBC_CMP_Packer.sign(reqstMsg);
        return ICBC_CMP_Packer.createMessageWithHead(msgSigned, TransCode);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        ICBC_CMP_NoteParser.parsePay(noteReceivableInfos, responseStr);
        return noteReceivableInfos;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/servlet/ICBCCMPAPIReqServlet");
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public EBBankNoteReceivableResponse doBiz(BankNoteReceivableRequest request) {
        NoteReceivableInfo info = (NoteReceivableInfo)request.getNoteReceivableInfos().get(0);
        if (info.getIsNewECDS().equals("0")) {
            NewNoteUtil.changeExcontext();
            kd.ebg.note.banks.icbc.opa.service.note.receivable.signin.SigninNoteReceivableImpl impl = new kd.ebg.note.banks.icbc.opa.service.note.receivable.signin.SigninNoteReceivableImpl();
            return impl.doBiz(request);
        }
        return super.doBiz(request);
    }
}

