/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service.payable.register;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ceb.dc.service.CEBHelper;
import kd.ebg.note.banks.ceb.dc.service.Parser;
import kd.ebg.note.banks.ceb.dc.service.payable.register.commit.NoteImpl;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class QueryNoteParser {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryNoteParser.class);

    public void parseQueryPay(List<NotePayableInfo> notePayableInfos, String rspStr) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseNoteHeader(root);
        if (!"0000".equals(response.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
            return;
        }
        Namespace ns = root.getNamespace();
        List respDatas = root.getChild("TransContent", ns).getChild("BatchRespList", ns).getChildren("RespData", ns);
        Element rs = (Element)respDatas.get(0);
        String billId = rs.getChildText("BillId", ns);
        if (!billId.equals(notePayableInfos.get(0).getObssid())) {
            this.logger.info("*************\u7968\u636eid\u4e0d\u5339\u914d");
            return;
        }
        String rsBillNo = rs.getChildText("BillNo", ns);
        String BILLSTATUS = rs.getChildText("BillStatus", ns);
        notePayableInfos.get(0).setBillNo(rsBillNo);
        notePayableInfos.get(0).setObssid(billId);
        this.logger.info("BILLSTATUS:" + BILLSTATUS + ",rsBillNo:" + rsBillNo);
        if (StringUtils.isNotEmpty((String)rsBillNo) && !"accepting".equals(notePayableInfos.get(0).getReserved1())) {
            notePayableInfos.get(0).setReserved1("register");
        }
        if ("register".equals(notePayableInfos.get(0).getReserved1())) {
            this.logger.info("\u5f00\u59cb\u63d0\u4ea4\u6279\u6b21\u4fe1\u606f");
            new NoteImpl().doBiz(notePayableInfos);
        } else {
            String[] status = CEBHelper.BATCHCODEMAP.get(BILLSTATUS);
            String[] success = new String[]{ResManager.loadKDString((String)"\u627f\u5151\u5b8c\u6210", (String)"QueryNoteParser_6", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0])};
            String[] fail = new String[]{""};
            if (status != null) {
                PaymentState state = CEBHelper.getNoteState(success, fail, BILLSTATUS);
                EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)state, (String)BILLSTATUS, (String)status[0]);
                notePayableInfos.get(0).setNoteStatus(status[1]);
            } else {
                EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)BILLSTATUS, (String)"");
            }
        }
    }
}

