/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.boc.net.service.note.receivable.cancle;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.note.banks.boc.net.service.note.receivable.cancle.QueryCancleNoteReceivableImpl;
import kd.ebg.note.banks.boc.net.service.note.util.CancleNotePacker;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class CancleNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(CancleNoteReceivableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryCancleNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "b2e0106";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u7533\u8bf7\u64a4\u56de(b2e0106)", (String)"CancleNoteReceivableImpl_0", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        CancleNotePacker cancleNotePacker = new CancleNotePacker();
        return cancleNotePacker.packReceivableCancleInfo(noteReceivableInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0106-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        List noteReceivableInfos = request.getNoteReceivableInfos();
        if (!"B001".equals(rspcod)) {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rspcod, (String)rspmsg);
        } else {
            List list = trn.getChildren("b2e0106-rs");
            Element rs = (Element)list.get(0);
            Element anotherStatus = rs.getChild("status");
            String anotherRspcod = anotherStatus.getChildTextTrim("rspcod");
            String anotherRspmsg = anotherStatus.getChildTextTrim("rspmsg");
            if ("B001".equals(anotherRspcod)) {
                EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.SUBMITED, (String)anotherRspcod, (String)String.format(ResManager.loadKDString((String)"%s\u64a4\u56de\u5df2\u63d0\u4ea4\u5230\u94f6\u884c", (String)"CancleNoteReceivableImpl_2", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]), anotherRspmsg));
            } else {
                EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)anotherRspcod, (String)anotherRspmsg);
            }
        }
        return noteReceivableInfos;
    }
}

