/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.boc.net.service.note.receivable.payment;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.boc.net.service.BocNetUtils;
import kd.ebg.note.banks.boc.net.service.Packer;
import kd.ebg.note.banks.boc.net.service.Parser;
import kd.ebg.note.banks.boc.net.service.login.LoginAccess;
import kd.ebg.note.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.note.banks.boc.net.service.note.receivable.payment.QueryPaymentNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class PaymentNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryPaymentNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "b2e0111";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u63d0\u793a\u4ed8\u6b3e(b2e0111)", (String)"PaymentNoteReceivableImpl_0", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
            JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0111");
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0111-rq");
            if (noteReceivableInfos.size() > 50) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5355\u6b21\u8bf7\u6c42\u4e0d\u80fd\u8d85\u8fc750\u7b14\u3002", (String)"PaymentNoteReceivableImpl_1", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
            }
            for (int i = 0; i < noteReceivableInfos.size(); ++i) {
                Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0111-rq");
                JDomUtils.addChild((Element)rq, (String)"ibknum", (String)"");
                JDomUtils.addChild((Element)rq, (String)"actacn", (String)request.getAcnt().getAccNo());
                JDomUtils.addChild((Element)rq, (String)"draftno", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getBillNo());
                LocalDate today = LocalDate.now();
                LocalDate bookingDate = ((NoteReceivableInfo)noteReceivableInfos.get(i)).getBookingDate();
                if (bookingDate.isBefore(today) || bookingDate.equals(today)) {
                    JDomUtils.addChild((Element)rq, (String)"bookdate", (String)"");
                } else {
                    JDomUtils.addChild((Element)rq, (String)"bookdate", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getBookingDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                }
                JDomUtils.addChild((Element)rq, (String)"amount", (String)(((NoteReceivableInfo)noteReceivableInfos.get(i)).getAmount() + ""));
                if ("0".equals(((NoteReceivableInfo)noteReceivableInfos.get(i)).getAutoAccept())) {
                    JDomUtils.addChild((Element)rq, (String)"onlflg", (String)"SM00");
                } else {
                    JDomUtils.addChild((Element)rq, (String)"onlflg", (String)"SM01");
                }
                String overdueReason = "";
                LocalDate dueDate = ((NoteReceivableInfo)noteReceivableInfos.get(i)).getDueDate();
                if ("21".equals(((NoteReceivableInfo)noteReceivableInfos.get(i)).getOperationCode()) && bookingDate.isAfter(dueDate.plusDays(10L))) {
                    overdueReason = ((NoteReceivableInfo)noteReceivableInfos.get(i)).getExplanation();
                }
                JDomUtils.addChild((Element)rq, (String)"overduereason", (String)overdueReason);
                String sequence = Sequence.genSequence();
                JDomUtils.addChild((Element)rq, (String)"memo", (String)sequence);
                ((NoteReceivableInfo)noteReceivableInfos.get(i)).setSequence(sequence);
            }
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            la.unavailableRelease();
        }
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Parser.parserB2eError(root);
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0111-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equals(rspcod)) {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rspcod, (String)rspmsg);
        } else {
            List list = trn.getChildren("b2e0111-rs");
            int size = list.size();
            block0: for (int i = 0; i < size; ++i) {
                Element rs = (Element)list.get(i);
                Element anotherStatus = rs.getChild("status");
                String another_rspcod = anotherStatus.getChildTextTrim("rspcod");
                String another_rspmsg = anotherStatus.getChildTextTrim("rspmsg");
                String obssid = rs.getChildTextTrim("obssid");
                ((NoteReceivableInfo)noteReceivableInfos.get(0)).setObssid(obssid);
                ((NoteReceivableInfo)noteReceivableInfos.get(0)).setBankRefKey(obssid);
                String draftno = rs.getChildTextTrim("draftno");
                for (NoteReceivableInfo noteReceivableInfo : noteReceivableInfos) {
                    if (!draftno.equals(noteReceivableInfo.getBillNo())) continue;
                    if ("B001".equals(another_rspcod) || "B266".equals(another_rspcod)) {
                        EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.SUBMITED, (String)another_rspcod, (String)another_rspmsg);
                        continue block0;
                    }
                    EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)another_rspcod, (String)another_rspmsg);
                    continue block0;
                }
            }
        }
        return noteReceivableInfos;
    }
}

