/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.ccip.service.news.info;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.note.banks.ccb.ccip.service.news.LoginUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CCBHCBankResponse;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonPacker;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonParser;
import kd.ebg.note.banks.ccb.ccip.service.note.util.JDomExtUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.PackerUtil;
import kd.ebg.note.business.noteinfo.atomic.AbstractNoteInfoImpl;
import kd.ebg.note.business.noteinfo.bank.BankNoteInfoBody;
import kd.ebg.note.business.noteinfo.bank.BankNoteInfoRequest;
import kd.ebg.note.business.noteinfo.bank.EBBankNoteInfoResponse;
import kd.ebg.note.common.entity.biz.noteinfo.NoteInfoDetail;
import kd.ebg.note.common.entity.biz.noteinfo.NoteInfoRequest;
import org.jdom2.Content;
import org.jdom2.Element;

public class NoteInfoImpl
extends AbstractNoteInfoImpl {
    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "P1CPEN010";
    }

    public String getBizDesc() {
        return null;
    }

    public int getBatchSize() {
        return 10;
    }

    public String pack(BankNoteInfoRequest bankNoteInfoRequest) {
        LoginUtils.login();
        BankNoteInfoBody body1 = bankNoteInfoRequest.getBody();
        List details = body1.getDetails();
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CPEN010", Sequence.genSequence());
        root.addContent((Content)headr);
        Element common = PackerUtil.packComEntity(Sequence.genSequence(), "", "0", "200");
        JDomExtUtils.addChild((Element)body, (Element)common);
        JDomExtUtils.addChildCDData(common, "Txn_Tdnum", details.size() + "");
        JDomExtUtils.addChildCDData(common, "Bl_Txn_MsgRp_Src_Tp", "100003");
        for (NoteInfoDetail detail : details) {
            Element group = JDomExtUtils.addChild((Element)common, (String)"Bkqqhptxss_GRP");
            JDomExtUtils.addChildCDData(group, "Bill_No", detail.getNoteNo());
            JDomExtUtils.addChildCDData(group, "SbBll_Rng_Strt_SN", detail.getStartNo());
            JDomExtUtils.addChildCDData(group, "SbBll_Rng_End_SN", detail.getEndNo());
            JDomExtUtils.addChildCDData(group, "Bl_Aply_Amt", detail.getAmount());
            JDomExtUtils.addChildCDData(group, "Bill_ExDat", detail.getDueDate());
            JDomExtUtils.addChildCDData(group, "Bl_Bsn_TpCd", "BC08");
            JDomExtUtils.addChildCDData(group, "Bl_Dsct_IntRt", detail.getDiscountRatePer());
            JDomExtUtils.addChildCDData(group, "Buyr_IntPymt_Pct", detail.getIncreaseRate());
            JDomExtUtils.addChildCDData(group, "IntPymtPrt_Way", detail.getPayRateType());
            JDomExtUtils.addChildCDData(group, "Bl_Dsct_Aply_Dt", LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
        }
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankNoteInfoResponse parse(BankNoteInfoRequest bankNotePayableRequest, String rspStr) {
        BankNoteInfoBody detailBody = bankNotePayableRequest.getBody();
        CCBHCBankResponse rsp = CommonParser.getFrontResponse(rspStr);
        if (!rsp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\uff0c%1$s %2$s\u3002", (String)"AcceptImpl_2", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        rspStr = rsp.getBankMsg();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(rspStr);
        ArrayList<NoteInfoDetail> noteInfoDetails = new ArrayList<NoteInfoDetail>(16);
        detailBody.setDetails(noteInfoDetails);
        EBBankNoteInfoResponse result = new EBBankNoteInfoResponse();
        result.setBody(detailBody);
        if (!bankResp.isSuccess()) {
            return result;
        }
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        List bkhptxss_grp = response.getChildren("Bkhptxss_GRP");
        for (Element info : bkhptxss_grp) {
            NoteInfoDetail temp = new NoteInfoDetail();
            String bill_no = info.getChildTextTrim("Bill_No");
            temp.setNoteNo(bill_no);
            String sbBll_rng_strt_sn = info.getChildTextTrim("SbBll_Rng_Strt_SN");
            temp.setStartNo(sbBll_rng_strt_sn);
            String sbBll_rng_end_sn = info.getChildTextTrim("SbBll_Rng_End_SN");
            temp.setEndNo(sbBll_rng_end_sn);
            String int_adj_dys = info.getChildTextTrim("Int_Adj_Dys");
            temp.setIntDaysAdjust(int_adj_dys);
            String intAr_dys = info.getChildTextTrim("IntAr_Dys");
            temp.setIntDays(intAr_dys);
            String recInt = info.getChildTextTrim("RecInt");
            temp.setRecInt(recInt);
            String actCashPymt_amt = info.getChildTextTrim("ActCashPymt_Amt");
            temp.setDiscountAmount(actCashPymt_amt);
            noteInfoDetails.add(temp);
        }
        return result;
    }

    public boolean match(NoteInfoRequest noteInfoRequest) {
        return "0".equals(noteInfoRequest.getBody().getIsNewECDS());
    }
}

