/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.ccip.service.note.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.utils.net.NetUtil;
import kd.ebg.note.banks.ccb.ccip.service.note.util.JDomExtUtils;
import org.jdom2.Element;

public class CommonPacker {
    public static Element packCommonHeader(String sysTXCode, String sequence) {
        return CommonPacker.packCommonHeader(sysTXCode, sequence, "", "1");
    }

    public static Element packCommonHeader(String sysTXCode, String sequence, String traceID, String nextPage) {
        IParameter parameter = EBContext.getContext().getParameter();
        Element root = new Element("Transaction_Header");
        JDomExtUtils.addChildCDData(root, "SYS_TX_CODE", sysTXCode);
        JDomExtUtils.addChildCDData(root, "SYS_REQ_LEN", "1021");
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("hhmmssSSS");
        try {
            JDomExtUtils.addChildCDData(root, "SYS_REQ_TIME", dateFormat.format(LocalDateTime.now()));
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u683c\u5f0f\u5316\u65f6\u95f4\u51fa\u9519\u3002", (String)"CommonPacker_0", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), (Throwable)e);
        }
        JDomExtUtils.addChildCDData(root, "SYS_TX_VRSN", "01");
        JDomExtUtils.addChildCDData(root, "TXN_DT", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomExtUtils.addChildCDData(root, "TXN_TM", LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        String opNo = parameter.getBankParameter("cusopr");
        JDomExtUtils.addChildCDData(root, "TXN_STFF_ID", opNo);
        JDomExtUtils.addChildCDData(root, "MULTI_TENANCY_ID", "CN000");
        JDomExtUtils.addChildCDData(root, "LNG_ID", "zh-cn");
        JDomExtUtils.addChildCDData(root, "REC_IN_PAGE", "100");
        JDomExtUtils.addChildCDData(root, "PAGE_JUMP", nextPage);
        JDomExtUtils.addChildCDData(root, "STS_TRACE_ID", traceID);
        String coustomerNo = parameter.getBankParameter("custid");
        JDomExtUtils.addChildCDData(root, "CHNL_CUST_NO", coustomerNo);
        JDomExtUtils.addChildCDData(root, "IttParty_Jrnl_No", sequence);
        String ip = NetUtil.getLocalhostStr();
        JDomExtUtils.addChildCDData(root, "Txn_Itt_IP_Adr", ip);
        return root;
    }

    public static Element packComEntity(String proCode, String sequence) {
        return CommonPacker.packComEntity(proCode, "000000000000000", "000000000000000", "", sequence, "01");
    }

    public static Element packComEntity(String proCode, String schlNo, String fwctlNodeID, String fileName, String sequence, String functionCode) {
        IParameter parameter = EBContext.getContext().getParameter();
        Element root = new Element("request");
        JDomExtUtils.addChildCDData(root, "ASPD_ECD", proCode);
        JDomExtUtils.addChildCDData(root, "SChl_No", schlNo);
        JDomExtUtils.addChildCDData(root, "FwCtl_Node_ID", fwctlNodeID);
        JDomExtUtils.addChildCDData(root, "IttParty_Bsn_Dt", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String grpid = parameter.getBankParameter("grpid");
        JDomExtUtils.addChildCDData(root, "Grp_ID", grpid);
        String cstid = parameter.getBankParameter("cstid");
        JDomExtUtils.addChildCDData(root, "Cst_ID", cstid);
        String primarno = parameter.getBankParameter("primarno");
        JDomExtUtils.addChildCDData(root, "Prim_AR_No", primarno);
        JDomExtUtils.addChildCDData(root, "Root_Node_PdAr_ID", "");
        JDomExtUtils.addChildCDData(root, "PdAr_ID", "");
        JDomExtUtils.addChildCDData(root, "SvM24Hr_Ind", "0");
        JDomExtUtils.addChildCDData(root, "Tmzon_ECD", "08");
        JDomExtUtils.addChildCDData(root, "Rqs_Upload_File_Nm", fileName);
        JDomExtUtils.addChildCDData(root, "Cmpt_Ent_ID", "0000CN000");
        JDomExtUtils.addChildCDData(root, "WF_BIZ_ID", sequence);
        JDomExtUtils.addChildCDData(root, "WF_MNPLT_TP", functionCode);
        JDomExtUtils.addChildCDData(root, "WF_FCN_ID", "");
        String ccsttrid = parameter.getBankParameter("ccsttrid");
        JDomExtUtils.addChildCDData(root, "CCstTr_ID", ccsttrid);
        String ccstrndid = parameter.getBankParameter("ccsttrnddid");
        JDomExtUtils.addChildCDData(root, "CCstTrNdID", ccstrndid);
        return root;
    }
}

