/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.ccip.service.note.util;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.ksql.util.Base64;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CCBHCBankResponse;
import kd.ebg.note.banks.ccb.ccip.service.note.util.JDomExtUtils;
import org.jdom2.Element;

public class CommonParser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CommonParser.class);

    public static CCBHCBankResponse getBankPreResponse(String rspStr) {
        CCBHCBankResponse response = new CCBHCBankResponse();
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element header = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Header");
        String statusCode = JDomExtUtils.getChildText((Element)header, (String)"SYS_TX_STATUS");
        String bankCode = JDomExtUtils.getChildText((Element)header, (String)"SYS_RESP_CODE");
        String bankMsg = JDomExtUtils.getChildText((Element)header, (String)"SYS_RESP_DESC");
        response.setResponseCode(bankCode);
        response.setResponseMessage(bankMsg);
        response.setBankMsg(bankMsg);
        if ("01".equals(statusCode)) {
            response.setSuccess(false);
        } else {
            response.setSuccess(true);
        }
        Element tranResponse = JDomExtUtils.getChildElement((Element)header, (String)"tran_response");
        if (null != tranResponse) {
            String status = JDomExtUtils.getChildText((Element)tranResponse, (String)"status");
            if ("COMPLETE".equals(status)) {
                response.setPaySuccess(true);
            } else {
                response.setUnkown(true);
            }
        } else {
            response.setUnkown(true);
        }
        return response;
    }

    public static CCBHCBankResponse getFrontResponse(String rspStr) {
        CCBHCBankResponse response = new CCBHCBankResponse();
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element header = JDomUtils.getChildElement((Element)root, (String)"header");
        String returnCode = JDomUtils.getChildText((Element)header, (String)"returnCode");
        String returnMsg = JDomUtils.getChildText((Element)header, (String)"returnMsg");
        String exception = JDomUtils.getChildText((Element)header, (String)"exception");
        response.setResponseCode(returnCode);
        response.setResponseMessage(returnMsg);
        if (!"0000".equals(returnCode)) {
            logger.info("\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5931\u8d25\u3002");
            response.setSuccess(false);
        } else {
            response.setSuccess(true);
            Element body = JDomUtils.getChildElement((Element)root, (String)"body");
            String bankMsg = "";
            try {
                String msg = JDomUtils.getChildText((Element)body, (String)"bankMsg");
                bankMsg = new String(Base64.decode((String)msg), RequestContextUtils.getCharset());
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u8282\u70b9\u53d1\u751f\u5f02\u5e38\u3002", (String)"CommonParser_0", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), (Throwable)e);
            }
            response.setBankMsg(bankMsg);
            logger.info("\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u62a5\u6587\uff1a" + bankMsg);
        }
        return response;
    }
}

