/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.zsb.opa.services.codeless.info;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.czb.sap.sdk.ServiceBean;
import com.czb.sap.sdk.inf.ApiHeader;
import com.czb.sap.sdk.inf.ApiRspData;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.FetchTokenUtils;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.note.banks.zsb.opa.services.utils.SdkInit;
import kd.ebg.note.business.noteinfo.atomic.AbstractNoteInfoImpl;
import kd.ebg.note.business.noteinfo.bank.BankNoteInfoBody;
import kd.ebg.note.business.noteinfo.bank.BankNoteInfoRequest;
import kd.ebg.note.business.noteinfo.bank.EBBankNoteInfoResponse;
import kd.ebg.note.common.entity.biz.noteinfo.NoteInfoDetail;
import kd.ebg.note.common.entity.biz.noteinfo.NoteInfoRequest;

public class DiscountInfo
extends AbstractNoteInfoImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(DiscountInfo.class);

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "nbts_queryCalculateInterestYqt";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u5229\u606f\u8bd5\u7b97", (String)"DiscountInfo_0", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]);
    }

    public boolean match(NoteInfoRequest noteInfoRequest) {
        return false;
    }

    public String pack(BankNoteInfoRequest bankNoteInfoRequest) {
        return "";
    }

    public EBBankNoteInfoResponse parse(BankNoteInfoRequest bankNoteInfoRequest, String rspStr) {
        JSONObject root = JSONObject.parseObject((String)rspStr);
        String statusCode = root.getString("resultcode");
        String statusDesc = root.getString("resultdesc");
        if (!"000000".equalsIgnoreCase(statusCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 , \u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s \u9519\u8bef\u4fe1\u606f:%2$s", (String)"DiscountInfo_1", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]), statusCode, statusDesc));
        }
        JSONObject jsonBody = root.getJSONObject("body");
        JSONArray calculateInterestResultYqtOutBeanList = jsonBody.getJSONArray("calculateInterestResultYqtOutBeanList");
        NoteInfoDetail noteInfoDetail = (NoteInfoDetail)bankNoteInfoRequest.getBody().getDetails().get(0);
        for (int i = 0; i < calculateInterestResultYqtOutBeanList.size(); ++i) {
            JSONObject element = calculateInterestResultYqtOutBeanList.getJSONObject(i);
            String calAmount = element.getString("calAmount");
            noteInfoDetail.setDiscountAmount(calAmount);
            String interest = element.getString("interest");
            noteInfoDetail.setRecInt(interest);
            String daysoff = element.getString("daysoff");
            noteInfoDetail.setIntDays(daysoff);
        }
        EBBankNoteInfoResponse response1 = new EBBankNoteInfoResponse();
        BankNoteInfoBody infoDetail = bankNoteInfoRequest.getBody();
        response1.setBody(infoDetail);
        infoDetail.setDetails(bankNoteInfoRequest.getBody().getDetails());
        return response1;
    }

    public EBBankNoteInfoResponse doBiz(BankNoteInfoRequest request) {
        String rspStr = "";
        try {
            SdkInit.init();
            ApiHeader header = new ApiHeader();
            header.setMsgtype("nbts_queryCalculateInterestYqt");
            header.setTraceno(Sequence.genSequence());
            String token = FetchTokenUtils.getToken();
            header.setToken(token);
            HashMap<String, Object> body = new HashMap<String, Object>(1);
            body.put("certifyAcctNo", request.getAcnt().getAccNo());
            body.put("custAcctNo", request.getAcnt().getAccNo());
            String disCountRate = ((NoteInfoDetail)request.getBody().getDetails().get(0)).getDiscountRate();
            if (StringUtils.isEmpty((String)disCountRate)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5229\u7387\u4e0d\u80fd\u4e3a\u7a7a", (String)"DiscountInfo_2", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]));
            }
            BigDecimal rate = new BigDecimal(disCountRate);
            BigDecimal ratePer = rate.divide(new BigDecimal("100.00"));
            body.put("rate", ratePer.toString());
            body.put("eleSign", Sequence.gen16Sequence());
            ArrayList calculateInterestBillYqtOutBeanList = new ArrayList(1);
            body.put("calculateInterestBillYqtOutBeanList", calculateInterestBillYqtOutBeanList);
            HashMap<String, String> discount = new HashMap<String, String>(1);
            calculateInterestBillYqtOutBeanList.add(discount);
            discount.put("billAmount", ((NoteInfoDetail)request.getBody().getDetails().get(0)).getAmount());
            discount.put("beginDate", LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
            discount.put("endDate", ((NoteInfoDetail)request.getBody().getDetails().get(0)).getDueDate());
            discount.put("serialNo", "1");
            logger.info("\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString(body));
            ApiRspData data = ServiceBean.getService((String)SdkInit.getTenantKey()).invoke(header, body);
            rspStr = JSON.toJSONString((Object)data);
            logger.info("\u6d59\u5546\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr);
            if (!"000000".equalsIgnoreCase(data.getResultcode())) {
                SdkInit.checkToken(token);
            }
            return this.parse(request, rspStr);
        }
        catch (Throwable e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6d59\u5546\u67e5\u8be2\u5f02\u5e38\uff1a%1$s\u3002", (String)"DiscountInfo_3", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }
}

