/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.zsb.opa.services.codeless.receivable;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.note.banks.zsb.opa.services.utils.NoteStatus;
import kd.ebg.note.banks.zsb.opa.services.utils.QueryStatusImpl;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;

public class QueryResultUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryResultUtil.class);

    public static void parser(List<NoteReceivableInfo> infos, String rspStr) {
        NoteReceivableInfo info = infos.get(0);
        JSONObject root = JSONObject.parseObject((String)rspStr);
        String statusCode = root.getString("resultcode");
        String statusDesc = root.getString("resultdesc");
        if (!"000000".equalsIgnoreCase(statusCode)) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)statusCode, (String)statusDesc);
            return;
        }
        JSONObject jsonBody = root.getJSONObject("body");
        JSONObject PageResponse = jsonBody.getJSONObject("pageResponse");
        int totalRows = PageResponse.getInteger("totalRows");
        int totalPages = PageResponse.getInteger("totalPages");
        if (totalRows == 0 || totalPages == 0) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)statusCode, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5224\u65ad\u4ea4\u6613\u7ed3\u679c\u3002", (String)"QueryResultUtil_0", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]));
            return;
        }
        JSONArray TradeDetailInfoYqtOutBean = jsonBody.getJSONArray("tradeDetailInfoYqtOutBeanslist");
        if (TradeDetailInfoYqtOutBean != null && TradeDetailInfoYqtOutBean.size() > 0) {
            JSONObject element = TradeDetailInfoYqtOutBean.getJSONObject(0);
            String status = element.getString("status");
            String failReason = element.getString("failReason");
            String rangeStart = element.getString("rangeStart");
            info.setStartNo(rangeStart);
            String rangeEnd = element.getString("rangeEnd");
            info.setEndNo(rangeEnd);
            if ("note_cancle".equals(info.getSubBizType())) {
                if ("TS21".equals(status) || "TS02".equals(status)) {
                    QueryResultUtil.dealStaus(info);
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"QueryResultUtil_1", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]));
                } else if ("TS22".equals(status)) {
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryResultUtil_2", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]));
                    QueryResultUtil.dealStaus(info);
                } else if ("TS23".equals(status)) {
                    QueryResultUtil.dealStaus(info);
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)status, (String)failReason);
                } else {
                    QueryResultUtil.dealStaus(info);
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)status, (String)failReason);
                }
            } else if ("note_signin".equals(info.getSubBizType())) {
                if ("TS11".equals(status) || "TS02".equals(status)) {
                    QueryResultUtil.dealStaus(info);
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"QueryResultUtil_1", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]));
                } else if ("TS12".equals(status)) {
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryResultUtil_2", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]));
                    if ("02".equals(info.getOperationCode())) {
                        info.setNoteStatus("CS02");
                        info.setCirStatus("TF0101");
                    } else {
                        info.setNoteStatus("CS03");
                        info.setCirStatus("TF0301");
                    }
                } else if ("TS13".equals(status)) {
                    QueryResultUtil.dealStaus(info);
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)status, (String)failReason);
                } else {
                    QueryResultUtil.dealStaus(info);
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)status, (String)failReason);
                }
            } else if ("TS01".equals(status) || "TS02".equals(status)) {
                QueryResultUtil.dealStaus(info);
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"QueryResultUtil_1", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]));
            } else if ("TS12".equals(status)) {
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryResultUtil_2", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]));
                if ("note_endorse".equals(info.getSubBizType())) {
                    info.setNoteStatus("CS03");
                    info.setCirStatus("TF0301");
                } else if ("pledge_note".equals(info.getSubBizType())) {
                    info.setNoteStatus("CS03");
                    info.setCirStatus("TF0304");
                } else if ("note_discount".equals(info.getSubBizType())) {
                    info.setNoteStatus("CS03");
                    info.setCirStatus("TF0304");
                } else if ("present_payment".equals(info.getSubBizType())) {
                    info.setNoteStatus("CS06");
                    info.setCirStatus("TF0501");
                }
            } else if ("TS03".equals(status)) {
                QueryResultUtil.dealStaus(info);
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)status, (String)failReason);
            } else {
                QueryResultUtil.dealStaus(info);
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)status, (String)failReason);
            }
        } else {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ResManager.loadKDString((String)"\u67e5\u8be2\u7968\u636e\u72b6\u6001\u672a\u8fd4\u56de\u6570\u636e\u3002", (String)"QueryResultUtil_4", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]));
        }
    }

    public static void parserCommon(List<NoteReceivableInfo> infos, String rspStr) {
        JSONObject root = JSONObject.parseObject((String)rspStr);
        String statusCode = root.getString("resultcode");
        String statusDesc = root.getString("resultdesc");
        if (!"000000".equalsIgnoreCase(statusCode)) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)statusCode, (String)statusDesc);
        } else {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)statusCode, (String)statusDesc);
        }
    }

    public static void dealStaus(NoteReceivableInfo info) {
        try {
            QueryStatusImpl queryStatus = new QueryStatusImpl();
            NoteStatus noteStatus = queryStatus.getMessage(info.getDrawerAccNo(), info.getBillNo(), info.getStartNo(), info.getEndNo());
            info.setNoteStatus(noteStatus.getNoteStatus());
            info.setCirStatus(noteStatus.getCircus());
        }
        catch (Exception e) {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ResManager.loadKDString((String)"\u67e5\u8be2\u7968\u636e\u72b6\u6001\u5f02\u5e38", (String)"QueryResultUtil_3", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]));
        }
    }
}

