/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.zsb.opa.services.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.czb.sap.sdk.ServiceBean;
import com.czb.sap.sdk.inf.ApiHeader;
import com.czb.sap.sdk.inf.ApiRspData;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.FetchTokenUtils;
import kd.ebg.note.banks.zsb.opa.services.utils.NoteStatus;
import kd.ebg.note.banks.zsb.opa.services.utils.SdkInit;

public class QueryStatusImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryStatusImpl.class);

    public NoteStatus parseNoteSides(String rspStr) {
        JSONObject root = JSONObject.parseObject((String)rspStr);
        String statusCode = root.getString("resultcode");
        String statusDesc = root.getString("resultdesc");
        if (!"000000".equalsIgnoreCase(statusCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 , \u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s \u9519\u8bef\u4fe1\u606f:%2$s", (String)"QueryStatusImpl_0", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]), statusCode, statusDesc));
        }
        JSONObject jsonBody = root.getJSONObject("body");
        JSONObject element = jsonBody.getJSONObject("queryFrontBillInfoOutBean");
        NoteStatus detailInfo = new NoteStatus();
        String rangeStatus = element.getString("rangeStatus");
        detailInfo.setNoteStatus(rangeStatus);
        String flowFlag = element.getString("flowFlag");
        detailInfo.setCircus(flowFlag);
        return detailInfo;
    }

    public NoteStatus getMessage(String accno, String billNo, String startNo, String endNo) {
        String rspStr = "";
        NoteStatus details = null;
        try {
            boolean pageTag = true;
            SdkInit.init();
            ApiHeader header = new ApiHeader();
            header.setMsgtype("nbts_queryBillPrintInfoYqt");
            header.setTraceno(Sequence.genSequence());
            String token = FetchTokenUtils.getToken();
            header.setToken(token);
            HashMap<String, String> body = new HashMap<String, String>(1);
            body.put("certifyAcctNo", accno);
            body.put("eleSign", Sequence.gen16Sequence());
            body.put("billNo", billNo);
            body.put("rangeStart", startNo);
            body.put("rangeEnd", endNo);
            body.put("printType", "1");
            logger.info("\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString(body));
            ApiRspData data = ServiceBean.getService((String)SdkInit.getTenantKey()).invoke(header, body);
            rspStr = JSON.toJSONString((Object)data);
            logger.info("\u6d59\u5546\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr);
            if (!"000000".equalsIgnoreCase(data.getResultcode())) {
                SdkInit.checkToken(token);
            }
            details = this.parseNoteSides(rspStr);
        }
        catch (Throwable e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6d59\u5546\u67e5\u8be2\u5f02\u5e38\uff1a%1$s\u3002", (String)"QueryStatusImpl_2", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        return details;
    }
}

