/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.bocom.dc.service.news.payable.register;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.bocom.dc.service.news.payable.register.CodelessQueryRegisterNotePayableImpl;
import kd.ebg.note.banks.bocom.dc.service.news.util.BOCOM_DC_NotePacker;
import kd.ebg.note.banks.bocom.dc.service.news.util.BOCOM_DC_Parser;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class CodelessRegisterNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(CodelessRegisterNotePayableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return CodelessQueryRegisterNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "420201";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968\u5904\u7406-\u7968\u636e\u7b7e\u53d1(420201)", (String)"CodelessRegisterNotePayableImpl_0", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        List infos = request.getNotePayableInfoList();
        NotePayableInfo paymentInfo = (NotePayableInfo)infos.get(0);
        Element root = BOCOM_DC_NotePacker.packRootForNote("420201", paymentInfo.getBankDetailSeqId());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"DrwrAcctId", (String)paymentInfo.getDrawerAccNo());
        JDomUtils.addChild((Element)body, (String)"Tp", (String)paymentInfo.getDraftType());
        JDomUtils.addChild((Element)body, (String)"Ccy", (String)paymentInfo.getCurrency());
        String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
        boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
        JDomUtils.addChild((Element)body, (String)"DueDt", (String)((NotePayableInfo)infos.get(0)).getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"BanEndrsmtMk", (String)paymentInfo.getTransferFlag());
        Boolean isSameBank = false;
        if (paymentInfo.getPayeeBankName() != null && SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)paymentInfo.getPayeeBankName()).equals("1")) {
            isSameBank = true;
        }
        JDomUtils.addChild((Element)body, (String)"PyeeBankFlg", (String)(isSameBank != false ? "0" : "1"));
        JDomUtils.addChild((Element)body, (String)"PyeeAcctId", (String)paymentInfo.getPayeeAccNo());
        if (isSameBank.booleanValue()) {
            JDomUtils.addChild((Element)body, (String)"PyeeNm", (String)"");
            JDomUtils.addChild((Element)body, (String)"PyeeAcctSvcr", (String)"");
        } else {
            JDomUtils.addChild((Element)body, (String)"PyeeNm", (String)paymentInfo.getPayeeAccName());
            JDomUtils.addChild((Element)body, (String)"PyeeAcctSvcr", (String)paymentInfo.getPayeeBankCnaps());
        }
        JDomUtils.addChild((Element)body, (String)"DrwrCdtRatgs", (String)"");
        JDomUtils.addChild((Element)body, (String)"CdtRatgAgcy", (String)"");
        JDomUtils.addChild((Element)body, (String)"CdtRatgDueDt", (String)"");
        boolean isAcceptSameBank = false;
        if (paymentInfo.getAcceptorBankName() != null && SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)paymentInfo.getAcceptorBankName()).equals("1")) {
            isAcceptSameBank = true;
        }
        JDomUtils.addChild((Element)body, (String)"AccptrBankFlg", (String)(isAcceptSameBank ? "0" : "1"));
        if ("AC01".equals(paymentInfo.getDraftType()) && isAcceptSameBank) {
            JDomUtils.addChild((Element)body, (String)"AccptrAcctId", (String)"");
        } else {
            JDomUtils.addChild((Element)body, (String)"AccptrAcctId", (String)paymentInfo.getAcceptorAccNo());
        }
        if (isAcceptSameBank && "AC01".equals(paymentInfo.getDraftType())) {
            JDomUtils.addChild((Element)body, (String)"AccptrNm", (String)"");
            JDomUtils.addChild((Element)body, (String)"AccptrAcctSvcr", (String)"");
        } else {
            JDomUtils.addChild((Element)body, (String)"AccptrNm", (String)paymentInfo.getAcceptorAccName());
            JDomUtils.addChild((Element)body, (String)"AccptrAcctSvcr", (String)paymentInfo.getAcceptorBankCnaps());
        }
        JDomUtils.addChild((Element)body, (String)"RmrkByPropsr", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"NoteFlag", (String)"1");
        JDomUtils.addChild((Element)body, (String)"IsseAmt", (String)paymentInfo.getAmount().toPlainString());
        JDomUtils.addChild((Element)body, (String)"SplitFlag", (String)paymentInfo.getGrdBag());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        if (!"0000".equals(rsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return notePayableInfos;
        }
        EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        Element body = ap.getChild("body");
        Element head = ap.getChild("head");
        String flwNo = body.getChildTextTrim("FlwNo");
        this.logger.info("\u8fd4\u56de\u7684\u7f51\u94f6\u6d41\u6c34\u53f7\u4e3a\uff1a{}", (Object)flwNo);
        ((NotePayableInfo)notePayableInfos.get(0)).setRspserialno(flwNo);
        String req_no = head.getChildTextTrim("req_no");
        this.logger.info("\u4f01\u4e1a\u51ed\u8bc1\u53f7\u4e3a\uff1a{}", (Object)req_no);
        return notePayableInfos;
    }
}

