/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.common.framework.info;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.ebg.egf.common.annotation.Autowired;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.bank.api.IBankServiceDesc;
import kd.ebg.egf.common.model.bank.BankConfig;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;
import kd.ebg.note.common.framework.frame.AtomicBizMeta;
import kd.ebg.note.common.framework.frame.Bank;
import kd.ebg.note.common.framework.frame.BankBundleManager;
import kd.ebg.note.common.framework.frame.BankVersion;
import kd.ebg.note.common.framework.info.BankImplInfo;
import kd.ebg.note.common.framework.info.BankInfo;
import kd.ebg.note.common.framework.info.BankLoginInfo;
import kd.ebg.note.common.framework.info.BankVersionInfo;
import kd.ebg.note.common.framework.info.BizInfo;
import kd.ebg.note.common.framework.info.Info;
import kd.ebg.note.common.framework.info.InfoContributor;
import kd.ebg.note.common.framework.info.PropertyConfigInfo;
import kd.ebg.note.common.framework.info.PropertyConfigItemInfo;
import kd.ebg.note.common.framework.properties.GlobalPropertyConfig;
import kd.ebg.note.common.framework.properties.PropertyConfig;
import kd.ebg.note.common.framework.properties.PropertyConfigItem;

@Component
public class FrameworkInfoContributor
implements InfoContributor {
    @Autowired
    private BankBundleManager bankBundleManager;
    @Autowired
    private GlobalPropertyConfig globalPropertyConfig;
    private List<BankInfo> infoBanks;
    private List<BankVersionInfo> infoBankVersions;
    private List<BizInfo> infoBizs;
    private List<PropertyConfigInfo> infoPropertyConfigs;
    private Map<String, List<BankLoginInfo>> infoBankLogins;
    private volatile boolean inited = false;

    @Override
    public void contribute(Info.Builder builder) {
        if (!this.inited) {
            this.initInfos();
        }
        builder.withDetail("banks", this.infoBanks);
        builder.withDetail("bankVersions", this.infoBankVersions);
        builder.withDetail("bizMetas", this.infoBizs);
        builder.withDetail("propertyConfigs", this.infoPropertyConfigs);
        builder.withDetail("bankLogins", this.infoBankLogins);
    }

    private synchronized void initInfos() {
        if (!this.inited) {
            Collection<Bank> banks = this.bankBundleManager.getBanks();
            Collection<BankVersion> bankVersions = this.bankBundleManager.getBankVersions();
            List<AtomicBizMeta> bizMetas = this.bankBundleManager.getBizMetas();
            List<PropertyConfig> propertyConfigs = this.globalPropertyConfig.getPropertyConfigList();
            this.infoBanks = new ArrayList<BankInfo>(banks.size());
            this.infoBankVersions = new ArrayList<BankVersionInfo>(bankVersions.size());
            this.infoBizs = new ArrayList<BizInfo>(bizMetas.size());
            this.infoPropertyConfigs = new ArrayList<PropertyConfigInfo>(1);
            this.infoBankLogins = Maps.newHashMap();
            for (Bank bank : banks) {
                BankInfo bankInfo = new BankInfo();
                this.infoBanks.add(bankInfo);
                bankInfo.setBankName(bank.getBankName());
                bankInfo.setBankShortName(bank.getBankShortName());
                bankInfo.setBankDescription(bank.getBankDescription());
                bankInfo.setBankNameKeyWords(bank.getBankNameKeyWords());
                List<BankVersion> bankVersionList = bank.getBankVersions();
                ArrayList<BankVersionInfo> tempBankVersionInfos = new ArrayList<BankVersionInfo>(bankVersionList.size());
                bankInfo.setVersionInfos(tempBankVersionInfos);
                for (BankVersion version : bankVersionList) {
                    BankLoginInfo loginInfo;
                    BankVersionInfo info = new BankVersionInfo();
                    tempBankVersionInfos.add(info);
                    info.setBankVersionID(version.getBankVersionID());
                    info.setBankVersionName(version.getBankVersionName());
                    info.setBankName(version.getBankName());
                    info.setAvailable(version.isAvailable());
                    info.setVersion(version.getVersion());
                    info.setConcurrentCount(version.getConcurrentCount());
                    List<BankLoginConfig> configs = version.getBankLoginConfigs();
                    List<BankConfig> bankConfigs = version.getBankConfigs();
                    ArrayList<BankLoginInfo> loginInfos = new ArrayList<BankLoginInfo>(configs.size());
                    for (BankLoginConfig bankLoginConfig : configs) {
                        loginInfo = new BankLoginInfo();
                        loginInfos.add(loginInfo);
                        loginInfo.setBankConfigId(bankLoginConfig.getKey().getBankConfigId());
                        loginInfo.setBankConfigName(bankLoginConfig.getBankConfigName());
                        loginInfo.setBankConfigValue(bankLoginConfig.getBankConfigValue());
                        loginInfo.setNullable(bankLoginConfig.getNullable());
                        loginInfo.setReadOnly(bankLoginConfig.getReadOnly());
                        loginInfo.setInputType(bankLoginConfig.getInputType());
                        loginInfo.setBankConfig(false);
                        loginInfo.setDesc(bankLoginConfig.getDesc());
                        loginInfo.setType(bankLoginConfig.getType());
                        loginInfo.setSourceValues(bankLoginConfig.getSourceValues());
                        loginInfo.setMaxLength(bankLoginConfig.getMaxLength());
                    }
                    for (BankConfig bankConfig : bankConfigs) {
                        loginInfo = new BankLoginInfo();
                        loginInfos.add(loginInfo);
                        loginInfo.setBankConfigId(bankConfig.getKey().getBankConfigId());
                        loginInfo.setBankConfigName(bankConfig.getBankConfigName());
                        loginInfo.setBankConfigValue(bankConfig.getBankConfigValue());
                        loginInfo.setNullable(true);
                        loginInfo.setReadOnly(false);
                        loginInfo.setInputType(bankConfig.getInputType());
                        loginInfo.setBankConfig(true);
                    }
                    info.setLogins(loginInfos);
                    this.infoBankLogins.put(info.getBankVersionID(), loginInfos);
                    PropertyConfig propertyConfig = version.getPropertyConfig();
                    PropertyConfigInfo propertyConfigInfo = new PropertyConfigInfo();
                    info.setPropertyConfigInfo(propertyConfigInfo);
                    propertyConfigInfo.setPropertyConfigID(propertyConfig.getPropertyConfigID());
                    propertyConfigInfo.setConfigName(propertyConfig.getConfigName());
                    propertyConfigInfo.setPropertyName(propertyConfig.getPropertyName().name());
                    propertyConfigInfo.setConfigDesc(propertyConfig.getConfigDesc());
                    List<PropertyConfigItem> configItems = propertyConfig.getAllPropertyConfigItems();
                    ArrayList<PropertyConfigItemInfo> itemInfos = new ArrayList<PropertyConfigItemInfo>(configItems.size());
                    propertyConfigInfo.setConfigItems(itemInfos);
                    for (PropertyConfigItem item : configItems) {
                        PropertyConfigItemInfo itemInfo = new PropertyConfigItemInfo();
                        itemInfos.add(itemInfo);
                        itemInfo.setKey(item.getKey());
                        itemInfo.setName(item.getName());
                        itemInfo.setDesc(item.getDesc());
                        itemInfo.setMinValueNum(item.getMinValueNum());
                        itemInfo.setMaxValueNum(item.getMaxValueNum());
                        itemInfo.setSourceNames(item.getSourceNames());
                        itemInfo.setSourceValues(item.getSourceValues());
                        itemInfo.setDefaultValues(item.getDefaultValues());
                        itemInfo.setReadonly(item.isReadonly());
                        itemInfo.setAccNo(item.isAccNo());
                        itemInfo.setType(item.getType());
                        itemInfo.setMustInput(item.isMustInput());
                    }
                    this.infoPropertyConfigs.add(propertyConfigInfo);
                    ArrayList<BizInfo> infoBizs = new ArrayList<BizInfo>();
                    info.setInfoBizs(infoBizs);
                    Map<Class<? extends IBankServiceDesc>, List<Class<? extends IBankService>>> implMaps = version.getImplMap();
                    for (Map.Entry<Class<? extends IBankServiceDesc>, List<Class<? extends IBankService>>> entry : implMaps.entrySet()) {
                        Class<? extends IBankServiceDesc> bizInterfaceClass = entry.getKey();
                        List<Class<? extends IBankService>> implClasses = entry.getValue();
                        AtomicBizMeta atomicBizMeta = this.getBizMeta(bizMetas, bizInterfaceClass);
                        if (!Objects.nonNull(atomicBizMeta)) continue;
                        BizInfo bizInfo = new BizInfo();
                        infoBizs.add(bizInfo);
                        bizInfo.setBizInterfaceClassName(atomicBizMeta.getBizInterface().getName());
                        bizInfo.setBizName(atomicBizMeta.getBizName());
                        bizInfo.setSubBizName(atomicBizMeta.getSubBizName());
                        bizInfo.setBizDesc(atomicBizMeta.getBizDesc());
                        ArrayList<BankImplInfo> infoBankImpls = new ArrayList<BankImplInfo>(implClasses.size());
                        bizInfo.setBankImpls(infoBankImpls);
                        for (Class<? extends IBankService> implClass : implClasses) {
                            BankImplInfo bankImplInfo = new BankImplInfo();
                            infoBankImpls.add(bankImplInfo);
                            IBankService bankService = this.bankBundleManager.getImpl(implClass);
                            bankImplInfo.setClassName(implClass.getName());
                            bankImplInfo.setBizCode(bankService.getBizCode());
                            bankImplInfo.setBizDesc(bankService.getBizDesc());
                            bankImplInfo.setDeveloper(bankService.getDeveloper());
                        }
                    }
                }
                this.infoBankVersions.addAll(tempBankVersionInfos);
            }
            for (AtomicBizMeta meta : bizMetas) {
                BizInfo bizInfo = new BizInfo();
                this.infoBizs.add(bizInfo);
                bizInfo.setBizInterfaceClassName(meta.getBizInterface().getName());
                bizInfo.setBizName(meta.getBizName());
                bizInfo.setSubBizName(meta.getSubBizName());
                bizInfo.setBizDesc(meta.getBizDesc());
            }
            for (PropertyConfig propertyConfig : propertyConfigs) {
                PropertyConfigInfo infoPropertyConfig = new PropertyConfigInfo();
                infoPropertyConfig.setPropertyConfigID(propertyConfig.getPropertyConfigID());
                infoPropertyConfig.setConfigName(propertyConfig.getConfigName());
                infoPropertyConfig.setPropertyName(propertyConfig.getPropertyName().name());
                infoPropertyConfig.setConfigDesc(propertyConfig.getConfigDesc());
                List<PropertyConfigItem> configItems = propertyConfig.getAllPropertyConfigItems();
                ArrayList<PropertyConfigItemInfo> itemInfos = new ArrayList<PropertyConfigItemInfo>(configItems.size());
                infoPropertyConfig.setConfigItems(itemInfos);
                for (PropertyConfigItem item : configItems) {
                    PropertyConfigItemInfo itemInfo = new PropertyConfigItemInfo();
                    itemInfos.add(itemInfo);
                    itemInfo.setKey(item.getKey());
                    itemInfo.setName(item.getName());
                    itemInfo.setDesc(item.getDesc());
                    itemInfo.setMinValueNum(item.getMinValueNum());
                    itemInfo.setMaxValueNum(item.getMaxValueNum());
                    itemInfo.setSourceNames(item.getSourceNames());
                    itemInfo.setSourceValues(item.getSourceValues());
                    itemInfo.setDefaultValues(item.getDefaultValues());
                    itemInfo.setReadonly(item.isReadonly());
                    itemInfo.setAccNo(item.isAccNo());
                    itemInfo.setType(item.getType());
                    itemInfo.setMustInput(item.isMustInput());
                }
                this.infoPropertyConfigs.add(infoPropertyConfig);
            }
            this.inited = true;
        }
    }

    private AtomicBizMeta getBizMeta(Collection<AtomicBizMeta> metas, Class<? extends IBankServiceDesc> bizInterfaceClass) {
        for (AtomicBizMeta meta : metas) {
            if (!meta.getBizInterface().equals(bizInterfaceClass)) continue;
            return meta;
        }
        return null;
    }
}

