/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.common.framework.services;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.ebg.egf.common.annotation.Autowired;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.zookeeper.node.SingleNodeIDGetter;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.repository.NotePayableInfoRepository;
import kd.ebg.note.common.utils.SpringContextUtil;

@Service
public class NotePayableInfoService {
    EBGLogger log = EBGLogger.getInstance().getLogger(NotePayableInfoService.class);
    private final String nodeId;
    @Autowired
    private NotePayableInfoRepository notePayableInfoRepository;

    public NotePayableInfoService(SingleNodeIDGetter nodeIDGetter) {
        this.nodeId = nodeIDGetter.nodeID();
    }

    public static NotePayableInfoService getInstance() {
        return SpringContextUtil.getBean(NotePayableInfoService.class);
    }

    public List<NotePayableInfo> selectByBatchSeqID(String batchSeqID) {
        return this.notePayableInfoRepository.findByBatchSeqId(batchSeqID);
    }

    public List<NotePayableInfo> selectByBillno(String billno) {
        return this.notePayableInfoRepository.selectByBillno(billno);
    }

    public boolean batchSeqIDExist(String batchSeqID) {
        return this.notePayableInfoRepository.countByBatchSeqId(batchSeqID) > 0L;
    }

    public List<NotePayableInfo> save(List<NotePayableInfo> notePayableInfos) {
        notePayableInfos.forEach(paymentInfo -> paymentInfo.setUpdateTime(LocalDateTime.now()));
        TXHandle h = TX.requiresNew();
        try {
            List<NotePayableInfo> result;
            List<NotePayableInfo> list = result = this.notePayableInfoRepository.save(notePayableInfos);
            return list;
        }
        catch (Exception e) {
            this.log.error("\u4ed8\u6b3e\u8bb0\u5f55\u5199\u5165\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
            h.markRollback();
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u8bb0\u5f55\u5199\u5165\u51fa\u73b0\u5f02\u5e38\u3002", (String)"NotePayableInfoService_0", (String)"ebg-note-common", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            try {
                h.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean isBatchOwnMe(String bankBatchSeqId) {
        List<NotePayableInfo> notePayableInfos = this.notePayableInfoRepository.findByBankBatchSeqId(bankBatchSeqId);
        for (NotePayableInfo info : notePayableInfos) {
            if (Objects.equals(info.getEbgID(), this.nodeId)) continue;
            return false;
        }
        return true;
    }

    public List<NotePayableInfo> selectBankBatchSeqId(String bankBatchSeqId) {
        List<NotePayableInfo> notePayableInfos = this.notePayableInfoRepository.findByBankBatchSeqId(bankBatchSeqId);
        return notePayableInfos;
    }

    public List<NotePayableInfo> compareAndStateState(List<NotePayableInfo> notePayableInfos, PaymentState expectedState, PaymentState state) {
        for (NotePayableInfo info : notePayableInfos) {
            if (info.getStatus().intValue() != expectedState.getId()) {
                this.log.info("\u4ed8\u6b3e :{} \u7684\u72b6\u6001:{} \u4e0e\u9884\u671f\u7684\u72b6\u6001: {}\u4e0d\u4e00\u81f4", new Object[]{info.getId(), info.getStatus(), expectedState.getId()});
                return null;
            }
            info.setStatus(state.getId());
            info.setStatusMsg(state.getCnName());
            info.setStatusName(state.getEnName());
            info.setSubmitSuccessTime(LocalDateTime.now());
        }
        try {
            return this.save(notePayableInfos);
        }
        catch (Throwable e) {
            String bankBatchSeqID = notePayableInfos.get(0).getBankBatchSeqId();
            this.log.error("\u94f6\u884c\u6279\u6b21\u53f7\u4e3a:{}", new Object[]{bankBatchSeqID});
            this.log.error("\u5c1d\u8bd5\u4fee\u6539\u72b6\u6001\u5931\u8d25" + e.getMessage(), e);
            return null;
        }
    }

    public int update(NotePayableInfo[] toUpdate) {
        NotePayableInfo[] toUpdateCopyOrderById = new NotePayableInfo[toUpdate.length];
        System.arraycopy(toUpdate, 0, toUpdateCopyOrderById, 0, toUpdate.length);
        Arrays.sort(toUpdateCopyOrderById, Comparator.comparing(o -> o.getId()));
        for (int i = 0; i < toUpdateCopyOrderById.length; ++i) {
            toUpdateCopyOrderById[i].setStatusMsg(toUpdateCopyOrderById[i].getStatusMsg());
            toUpdateCopyOrderById[i].setBankStatus(toUpdateCopyOrderById[i].getBankStatus());
            toUpdateCopyOrderById[i].setBankMsg(toUpdateCopyOrderById[i].getBankMsg());
            toUpdateCopyOrderById[i].setErrorMsg(toUpdateCopyOrderById[i].getErrorMsg());
            toUpdateCopyOrderById[i].setBakStatusMsg(toUpdateCopyOrderById[i].getBakStatusMsg());
            toUpdateCopyOrderById[i].setBakBankStatus(toUpdateCopyOrderById[i].getBakBankStatus());
            toUpdateCopyOrderById[i].setBakBankMsg(toUpdateCopyOrderById[i].getBakBankMsg());
            toUpdateCopyOrderById[i].setBakErrorMsg(toUpdateCopyOrderById[i].getBakErrorMsg());
            this.notePayableInfoRepository.save(toUpdateCopyOrderById[i]);
        }
        return toUpdateCopyOrderById.length;
    }

    public int update4SubmitFail(NotePayableInfo[] input, Exception t) {
        NotePayableInfo[] cloned = new NotePayableInfo[input.length];
        for (int i = 0; i < input.length; ++i) {
            NotePayableInfo info = new NotePayableInfo();
            FieldUtils.fieldsCopy((Object)input[i], (Object)info);
            info.setUpdateBatchSeq(Sequence.gen16Sequence());
            info.setStatus(PaymentState.FAIL.getId());
            info.setStatusName(PaymentState.FAIL.getCnName());
            info.setStatusMsg(PaymentState.FAIL.getCnName());
            info.setErrorMsg(t.getMessage());
            cloned[i] = this.notePayableInfoRepository.save(input[i]);
        }
        return this.update(cloned);
    }

    public List<NotePayableInfo> selectByBatchSeqIDAndDetailSeqID(String batchSeqID, String detailSeqID) {
        return this.notePayableInfoRepository.findByBatchSeqIDAndDetailSeqID(batchSeqID, detailSeqID);
    }

    public List<NotePayableInfo> findByStatusAndInsertTime(int status, LocalDateTime dateTime, LocalDateTime limitTime) {
        return this.notePayableInfoRepository.findByStatusAndInsertTime(status, dateTime, limitTime);
    }
}

