/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.file;

import java.util.List;
import java.util.Map;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBPayUnknownException;
import kd.ebg.egf.common.model.file.PayAttachment;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.business.file.AbstractAttachmentImpl;
import kd.ebg.note.common.entity.biz.status.AttachmentState;
import org.slf4j.MDC;

public abstract class AbstractAttachmentHttpImpl
extends AbstractAttachmentImpl {
    public abstract String getUploadUri();

    public abstract Map<String, String> getUploadBody();

    public abstract String getBinaryBodyName();

    public abstract void parseUpload(PayAttachment var1, String var2);

    public List<PayAttachment> doBiz(List<PayAttachment> attachments) {
        if (CollectionUtil.isEmpty(attachments)) {
            return null;
        }
        super.prepareAttachment(attachments);
        StringBuilder requestUrl = new StringBuilder();
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        requestUrl.append("http://").append(ip);
        String filePort = RequestContextUtils.getBankParameterValue((String)"filePort");
        if (StringUtils.isEmpty((String)filePort)) {
            filePort = RequestContextUtils.getBankParameterValue((String)"fileport");
        }
        requestUrl.append(":").append(filePort);
        String uploadUri = this.getUploadUri();
        if (StringUtils.isNotEmpty((String)uploadUri)) {
            requestUrl.append(uploadUri);
        }
        MDC.put((String)"bussiness_type", (String)"bussiness_bank");
        attachments.forEach(payAttachment -> {
            try {
                String responseStr = this.uploadToBankByHttp(requestUrl.toString(), super.getOverseaAttachmentPath(payAttachment.getBankVersionID()), payAttachment.getFileName(), this.getBinaryBodyName(), this.getUploadBody());
                this.parseUpload((PayAttachment)payAttachment, responseStr);
                EBContext.getContext().setProcessFlag(PROCESS_PACK);
                String rqstStr = this.pack((PayAttachment)payAttachment);
                String rspStr = super.sendAndRecvMsg(rqstStr);
                this.parse((PayAttachment)payAttachment, rspStr);
            }
            catch (Throwable e) {
                String message = e.getMessage();
                if (StringUtils.isNotEmpty((String)message) && message.length() > 255) {
                    message = message.substring(0, 255);
                }
                if (e instanceof EBPayUnknownException) {
                    this.setUploadStatus((PayAttachment)payAttachment, AttachmentState.UNKNOWN, "", message);
                }
                this.setUploadStatus((PayAttachment)payAttachment, AttachmentState.FAIL, "", message);
            }
        });
        return attachments;
    }
}

