/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.properties.ObjectProperties;
import kd.ebg.egf.common.repository.properties.ObjectPropertiesRepository;
import kd.ebg.egf.common.utils.AESUtil;
import kd.ebg.egf.common.utils.file.FileCommonUtils;

public class OpenApiUtil {
    public static String appTokenUrlCangqiong = "/api/getAppToken.do";
    public static String accessTokenUrl = "/api/login.do";

    public static boolean isUseOpenApi() {
        ObjectPropertiesRepository objectPropertiesRepository = ObjectPropertiesRepository.getInstance();
        ObjectProperties properties = objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("isUseOpenApi", "receipt", "common_business");
        if (properties == null) {
            return false;
        }
        return !Boolean.parseBoolean(properties.getAttrValue());
    }

    public static String getAppTokenUrlFromCosmic() {
        return OpenApiUtil.getCosmicApiUrl() + appTokenUrlCangqiong;
    }

    public static String getAccessTokenUrlCangqiong() {
        return OpenApiUtil.getCosmicApiUrl() + accessTokenUrl;
    }

    private static String getCosmicApiUrl() {
        ObjectPropertiesRepository objectPropertiesRepository = ObjectPropertiesRepository.getInstance();
        ObjectProperties properties = objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("cosmic_api_url", "receipt", "common_business");
        return OpenApiUtil.handleUrl(properties.getAttrValue());
    }

    public static String getAppIdCangqiong() {
        ObjectPropertiesRepository objectPropertiesRepository = ObjectPropertiesRepository.getInstance();
        ObjectProperties properties = objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("cosmic_app_id", "receipt", "common_business");
        return properties.getAttrValue();
    }

    public static String getAppSecuretCangqiong() {
        ObjectPropertiesRepository objectPropertiesRepository = ObjectPropertiesRepository.getInstance();
        ObjectProperties properties = objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("cosmic_app_securet", "receipt", "common_business");
        return AESUtil.unencryptedDesEncrypt((String)properties.getAttrValue(), (String)"");
    }

    public static String getCosmicAccountId() {
        ObjectPropertiesRepository objectPropertiesRepository = ObjectPropertiesRepository.getInstance();
        ObjectProperties properties = objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("cosmic_account_id", "receipt", "common_business");
        return properties.getAttrValue();
    }

    public static Object getUserCangqiong() {
        ObjectPropertiesRepository objectPropertiesRepository = ObjectPropertiesRepository.getInstance();
        ObjectProperties properties = objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("cosmic_user_name", "receipt", "common_business");
        return properties.getAttrValue();
    }

    public static String handleUrl(String url) {
        if (!Objects.nonNull(url)) {
            return "";
        }
        String[] array = url.split("//");
        if (array.length < 1) {
            return url;
        }
        String second = array[array.length - 1];
        return !second.contains("/") ? url + "/ierp" : url;
    }

    public static void download(String urlStr, String fileName, String savePath) {
        try {
            HttpURLConnection conn;
            HttpURLConnection connection;
            boolean https = urlStr.contains("https");
            URL url = new URL(urlStr);
            if (https) {
                connection = (HttpsURLConnection)url.openConnection();
                SSLContext sc = null;
                sc = SSLContext.getInstance("TLSv1.2");
                sc.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
                ((HttpsURLConnection)connection).setSSLSocketFactory(sc.getSocketFactory());
                ((HttpsURLConnection)connection).setHostnameVerifier(new TrustAnyHostnameVerifier());
                conn = connection;
            } else {
                conn = connection = (HttpURLConnection)url.openConnection();
            }
            conn.setReadTimeout(180000);
            conn.setConnectTimeout(3000);
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            try (InputStream inputStream = conn.getInputStream();){
                byte[] getData = OpenApiUtil.readInputStream(inputStream);
                File saveDir = FileCommonUtils.getFileByPath((String)savePath);
                if (!saveDir.exists()) {
                    saveDir.mkdirs();
                }
                try (FileOutputStream fos = new FileOutputStream(saveDir + File.separator + fileName);){
                    fos.write(getData);
                }
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    private static byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int len;
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    private static class TrustAnyHostnameVerifier
    implements HostnameVerifier {
        private TrustAnyHostnameVerifier() {
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return s.equalsIgnoreCase(sslSession.getPeerHost());
        }
    }

    private static class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

