/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.fileupload;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.HttpConnection;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class FroxyImpl
extends AbstractImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(FroxyImpl.class);

    public String uploadFile(String bizSeqId, String fileName, String Content, String type) {
        String rqstStr = this.packUplaodFileXML(fileName, Content, type);
        String rspStr = this.sendAndRecvMsg(rqstStr);
        return this.parseUplaodFileXML(rspStr);
    }

    public static String getMD5(String s, String encoding) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty((String)s)) {
            return null;
        }
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (md5 != null) {
            md5.update(s.getBytes(encoding));
        }
        StringBuilder sb = new StringBuilder();
        if (md5 != null) {
            for (byte b : md5.digest()) {
                sb.append(String.format("%02X", b));
            }
        }
        return sb.toString().toLowerCase(Locale.ENGLISH);
    }

    public String packUplaodFileXML(String fileName, String Content, String type) {
        Element simulator = JDomUtils.createRoot((String)"simulator");
        Element head = FroxyImpl.createHead(type);
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"bankMsg", (String)"");
        JDomUtils.addChild((Element)reqPara, (String)"file", (String)fileName);
        JDomUtils.addChild((Element)reqPara, (String)"fileContent", (String)Content);
        return JDomUtils.root2String((Element)simulator, (String)"UTF-8");
    }

    public static Element createHead(String bizType) {
        return FroxyImpl.createHead(bizType, Sequence.genSequence());
    }

    public static Element createHead(String bizType, String seqno) {
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"sequence", (String)seqno);
        JDomUtils.addChild((Element)head, (String)"bizType", (String)bizType);
        TimeZone china = TimeZone.getTimeZone("GMT+:08:00");
        JDomUtils.addChild((Element)head, (String)"reqDate", (String)DateTimeUtils.formatDate((Date)new Date(), (TimeZone)china));
        JDomUtils.addChild((Element)head, (String)"reqTime", (String)DateTimeUtils.formatTime((Date)new Date(), (TimeZone)china));
        return head;
    }

    public String sendAndRecvMsg(String rqstStr, String bizSeqId) {
        String rspStr = "";
        try {
            ConnectionFactory connectionFactory = this.getConnectionFactory();
            IConnection conn = this.getFrontProxyConnection(connectionFactory);
            this.openConnection(conn);
            try (OutputStream os = this.getOutputStream(conn);){
                this.send(os, rqstStr);
                try (InputStream is = this.getInputStream(conn);){
                    rspStr = this.recv(is);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return rspStr;
    }

    private String parseUplaodFileXML(String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)"UTF-8");
        BankResponse rsp = FroxyImpl.parseHeader(root);
        if (!"BIZ_SUCCESS".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38 ,%1$s,%2$s", (String)"FroxyImpl_9", (String)"ebg-note-business", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        Element status = JDomUtils.getChildElementNotNull((Element)rspPara, (String)"status");
        String ReturnCode = JDomUtils.getChildTextTrimNotNull((Element)status, (String)"code", (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u7801", (String)"FroxyImpl_1", (String)"ebg-note-business", (Object[])new Object[0]));
        String ReturnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
        if (!"SUCCESS".equals(ReturnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25 ,%1$s,%2$s", (String)"FroxyImpl_8", (String)"ebg-note-business", (Object[])new Object[0]), ReturnCode, ReturnMsg));
        }
        Element filContent = JDomUtils.getChildElementNotNull((Element)rspPara, (String)"fileContent");
        String fileName = filContent.getTextTrim();
        return fileName;
    }

    public static BankResponse parseHeader(Element root) {
        Element Head = JDomUtils.getChildElementNotNull((Element)root, (String)"head");
        String IBSReturnCode = JDomUtils.getChildTextNotNull((Element)Head, (String)"rspcode", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u7801", (String)"FroxyImpl_2", (String)"ebg-note-business", (Object[])new Object[0]));
        String IBSReturnMsg = JDomUtils.getChildTextNullAsBlank((Element)Head, (String)"rspMsg");
        BankResponse response = new BankResponse();
        response.setResponseCode(IBSReturnCode);
        response.setResponseMessage(IBSReturnMsg);
        return response;
    }

    private String sendAndRecvMsg(String rqstStr) {
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        String portStr = RequestContextUtils.getBankParameterValue((String)"frontProxy_port");
        String timeOutStr = RequestContextUtils.getBankParameterValue((String)"timeout");
        int port = Integer.parseInt(portStr);
        int timeOut = Integer.parseInt(timeOutStr);
        HashMap header = new HashMap();
        HttpConnection conn = new HttpConnection(ip, port, "", header, timeOut);
        this.openConnection((IConnection)conn);
        String rspStr = "";
        try (OutputStream os = this.getOutputStream((IConnection)conn);){
            IOUtils.sendFully((OutputStream)os, (String)rqstStr, (String)"UTF-8");
            try (InputStream is = this.getInputStream((IConnection)conn);){
                rspStr = IOUtils.readFully((InputStream)is, (String)"UTF-8");
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7968\u636e\u4fe1\u606f\u4e1a\u52a1\u51fa\u73b0\u5f02\u5e38\u3002", (String)"FroxyImpl_6", (String)"ebg-note-business", (Object[])new Object[0]), (Throwable)e);
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7968\u636e\u4fe1\u606f\u4e1a\u52a1\u51fa\u73b0\u5f02\u5e38\u3002", (String)"FroxyImpl_6", (String)"ebg-note-business", (Object[])new Object[0]), (Throwable)e);
        }
        return rspStr;
    }
}

